/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.publisher;

import com.trs.components.common.publish.config.PublishServerConfigMapper;
import com.trs.components.common.publish.domain.distribute.FileDistributeShip;
import com.trs.components.common.publish.domain.publisher.PublishPathCompass;
import com.trs.components.common.publish.domain.publisher.PublishTaskContext;
import com.trs.components.common.publish.domain.taskdispatch.IPublishProgressMonitor;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyString;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.aton.container.IClearable;

public class PublishPageContext
implements IClearable {
    private Logger s_logger = Logger.getLogger(PublishPageContext.class);
    private Map m_extraAttributes;
    private Map m_variableAttributes;
    private PublishTaskContext m_taskContext;
    private IPublishElement m_pageElement;
    private IPublishFolder m_root = null;
    private Template m_oTemplate = null;
    private IPublishProgressMonitor m_oProgressMonitor = null;
    private StringBuffer m_buffWarnings = null;
    private String m_sPageHttpPath = null;
    private String m_sPageHttpURL = null;
    private String m_sFileName = null;

    public PublishPageContext(PublishPageContext pageContext) {
        this.m_pageElement = pageContext.getPageElement();
        this.m_taskContext = pageContext.getTaskContext();
        this.m_oProgressMonitor = pageContext.getProgressMonitor();
    }

    public PublishPageContext(IPublishElement _pageElement, PublishTaskContext _taskContext) {
        this(_pageElement, _taskContext, null);
    }

    public PublishPageContext(IPublishElement _pageElement, PublishTaskContext _taskContext, IPublishProgressMonitor _monitor) {
        this.m_pageElement = _pageElement;
        this.m_taskContext = _taskContext;
        this.m_oProgressMonitor = _monitor;
    }

    public PublishTaskContext getTaskContext() {
        return this.m_taskContext;
    }

    public IPublishElement getPageElement() {
        return this.m_pageElement;
    }

    public IPublishFolder getPageFolder() {
        if (this.m_pageElement instanceof IPublishFolder) {
            return (IPublishFolder)this.m_pageElement;
        }
        return ((IPublishContent)this.m_pageElement).getFolder();
    }

    public void clear() {
        if (this.m_buffWarnings != null) {
            this.m_buffWarnings.setLength(0);
        }
        if (this.m_sPageHttpPath != null) {
            this.m_sPageHttpPath = null;
        }
    }

    public boolean isPreview() {
        return this.m_taskContext.isPreview();
    }

    public IPublishFolder getRoot() throws WCMException {
        if (this.m_root != null) {
            return this.m_root;
        }
        if (this.m_pageElement.isFolder()) {
            this.m_root = this.m_pageElement.getFolder().getRoot();
            return this.m_root;
        }
        this.m_root = this.m_taskContext.getRoot();
        Template currPageTemplate = this.m_oTemplate;
        if (currPageTemplate == null) {
            currPageTemplate = ((IPublishContent)this.m_pageElement).getDetailTemplate();
        }
        if (currPageTemplate.getRootId() != this.m_root.getId()) {
            this.m_root = currPageTemplate.getRoot();
        }
        return this.m_root;
    }

    public void setRoot(IPublishFolder root) {
        this.m_root = root;
    }

    public PublishPathCompass getPathCompass() {
        return this.m_taskContext.getPathCompass();
    }

    public FileDistributeShip getFileDistributeShip() {
        return this.m_taskContext.getFileDistributeShip();
    }

    public void incDetailPageCount() {
        this.m_taskContext.incDetailPageCount();
    }

    public void incOutlinePageCount() {
        this.m_taskContext.incOutlinePageCount();
    }

    public void addWarning(String _sObjName, int _nObjId, String _sDesc) throws WCMException {
        if (!PublishServerConfigMapper.isSendWarningIfFileNotFound()) {
            return;
        }
        if (this.m_buffWarnings == null) {
            this.m_buffWarnings = new StringBuffer();
        }
        this.m_buffWarnings.append(_sObjName).append("(ID=").append(_nObjId).append("): ");
        this.m_buffWarnings.append(_sDesc).append("\n");
    }

    public void addWarning(String _sDesc) throws WCMException {
        if (!PublishServerConfigMapper.isSendWarningIfFileNotFound()) {
            return;
        }
        if (this.m_buffWarnings == null) {
            this.m_buffWarnings = new StringBuffer();
        }
        this.m_buffWarnings.append(_sDesc).append("\n");
    }

    public String getWarnings() {
        return this.m_buffWarnings == null ? null : this.m_buffWarnings.toString();
    }

    public boolean hasWarnings() {
        return this.m_buffWarnings != null;
    }

    public String getPageHttpPath() throws WCMException {
        if (this.m_sPageHttpPath == null && this.m_sPageHttpPath == null) {
            PublishPathCompass compass = this.getPathCompass();
            this.m_sPageHttpPath = this.m_pageElement instanceof IPublishFolder ? compass.getAbsoluteHttpPath((IPublishFolder)this.m_pageElement) : compass.getAbsoluteHttpPath((IPublishContent)this.m_pageElement);
        }
        return this.m_sPageHttpPath;
    }

    public String getPageHttpURL() throws WCMException {
        if (this.m_sPageHttpURL == null && this.m_sPageHttpURL == null) {
            String sPageHttpURL = this.getPageHttpPath();
            if (this.m_pageElement instanceof IPublishContent) {
                if (((IPublishContent)this.m_pageElement).isLink()) {
                    this.m_sPageHttpURL = ((IPublishContent)this.m_pageElement).getLinkUrl();
                } else {
                    if (CMyString.isEmpty(this.m_sFileName)) {
                        IPublishContent content = (IPublishContent)this.m_pageElement;
                        String fn = PublishPathCompass.makeDetailPageFileName(content);
                        Template detail = content.getDetailTemplate();
                        if (detail == null) {
                            throw new WCMException(231, content.getInfo() + I18NMessage.get(PublishPageContext.class, "PublishPageContext.label1", "\u6ca1\u6709\u7ec6\u89c8\u6a21\u677f\uff01"));
                        }
                        String fext = detail.getOutputFileExt();
                        this.m_sFileName = fn + "." + fext;
                    }
                    this.m_sPageHttpURL = sPageHttpURL + this.m_sFileName;
                }
            } else {
                this.m_sPageHttpURL = sPageHttpURL;
            }
        }
        return this.m_sPageHttpURL;
    }

    public String getFileName() {
        return this.m_sFileName;
    }

    public void setFileName(String fileName) {
        this.m_sFileName = fileName;
    }

    public void log2Monitor(String msg) {
        if (this.m_oProgressMonitor != null) {
            this.m_oProgressMonitor.info(msg);
        }
    }

    public IPublishProgressMonitor getProgressMonitor() {
        return this.m_oProgressMonitor;
    }

    public void addErrorLog(int iResult, String sDesc, String sError) {
        try {
            if (this.m_taskContext != null) {
                this.m_taskContext.addErrorLog(iResult, this.m_pageElement, sDesc, sError);
            } else {
                this.s_logger.error((Object)(sError + "\n" + sDesc));
            }
        }
        catch (Throwable t) {
            this.s_logger.error((Object)"Failed to add error log for page publish task!", t);
        }
    }

    public void addErrorLog(int iResult, String sDesc, Throwable t) {
        this.addErrorLog(iResult, sDesc, CMyException.getStackTraceText(t));
    }

    public String getExtraAttribute(String _sName) {
        if (this.m_extraAttributes == null) {
            return null;
        }
        return (String)this.m_extraAttributes.get(_sName.toUpperCase());
    }

    public void setExtraAttribute(String _sName, String _sValue) {
        if (this.m_extraAttributes == null) {
            this.m_extraAttributes = new HashMap(1);
        }
        this.m_extraAttributes.put(_sName.toUpperCase(), _sValue);
    }

    public Template getTemplate() {
        return this.m_oTemplate;
    }

    public void setTemplate(Template template) {
        this.m_oTemplate = template;
    }

    public String getVariableAttribute(String _sName) {
        if (_sName == null) {
            return null;
        }
        if (this.m_variableAttributes == null) {
            return null;
        }
        return (String)this.m_variableAttributes.get(_sName);
    }

    public void setVariableAttribute(String _sName, String _sValue) {
        if (_sName == null || _sName.length() <= 0) {
            return;
        }
        if (this.m_variableAttributes == null) {
            this.m_variableAttributes = new HashMap();
        }
        this.m_variableAttributes.put(_sName.toUpperCase(), _sValue);
    }
}

