/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.process.definition;

import com.trs.DreamFactory;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.cms.content.CMSObj;
import com.trs.cms.process.IFlowCacheMgr;
import com.trs.cms.process.definition.Flow;
import com.trs.cms.process.definition.FlowNodeBranch;
import com.trs.cms.process.definition.FlowNodeBranchs;
import com.trs.cms.process.definition.FlowNodes;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyBitsValue;
import com.trs.infra.util.CMyString;

public class FlowNode
extends CMSObj {
    private static final long serialVersionUID = 1L;
    public static final int OBJ_TYPE = 403;
    public static final String DB_TABLE_NAME = "WCMFLOWNODE";
    public static final String DB_ID_NAME = "NODEID";
    public static final int ACTION_EDIT = 0;
    public static final int ACTION_DELETE = 1;
    public static final int ACTION_PUBLISH = 2;

    @Override
    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    @Override
    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    @Override
    public int getWCMType() {
        return 403;
    }

    public int getFlowId() {
        return this.getPropertyAsInt("FLOWID", 0);
    }

    public Flow getFlow() throws WCMException {
        return Flow.findById(this.getFlowId());
    }

    public boolean setFlow(int _flowId) throws WCMException {
        return this.setFlow(Flow.findById(_flowId));
    }

    public boolean setFlow(Flow _flow) throws WCMException {
        if (!this.isAddMode()) {
            throw new WCMException(1102, I18NMessage.get(FlowNode.class, "FlowNode.label1", "\u5de5\u4f5c\u6d41\u7f16\u53f7\u4e0d\u5141\u8bb8\u4fee\u6539(FlowNode.setFlow)"));
        }
        if (_flow == null || _flow.getId() <= 0) {
            throw new WCMException(10, I18NMessage.get(FlowNode.class, "FlowNode.label2", "\u65e0\u6548\u7684\u5de5\u4f5c\u6d41\u5bf9\u8c61(FlowNode.setFlow)"));
        }
        return this.setProperty("FLOWID", _flow.getId());
    }

    public String getName() {
        return this.getPropertyAsString("NODENAME");
    }

    public boolean setName(String _name) throws WCMException {
        return this.setProperty("NODENAME", _name);
    }

    public String getDesc() {
        return this.getPropertyAsString("NODEDESC");
    }

    public boolean setDesc(String _desc) throws WCMException {
        return this.setProperty("NODEDESC", _desc);
    }

    public int getCenterX() {
        return this.getPropertyAsInt("CENTERX", 0);
    }

    public boolean setCeneterX(int _nCenterX) throws WCMException {
        return this.setProperty("CENTERX", _nCenterX);
    }

    public int getCenterY() {
        return this.getPropertyAsInt("CENTERY", 0);
    }

    public boolean setCeneterY(int _nCenterY) throws WCMException {
        return this.setProperty("CENTERY", _nCenterY);
    }

    public int getDocActionsAsInt() {
        return this.getPropertyAsInt("ACTIONS", 0);
    }

    public CMyBitsValue getDocActions() {
        return new CMyBitsValue(this.getDocActionsAsInt());
    }

    public boolean isCanDoWithDoc(int _actionType) {
        if (_actionType >= 31 || _actionType < 0) {
            return false;
        }
        return CMyBitsValue.getBit(this.getDocActionsAsInt(), _actionType);
    }

    public boolean setDocActions(int _actions) throws WCMException {
        return this.setProperty("ACTIONS", _actions);
    }

    public boolean setDocActions(int _actionType, boolean _bCanDo) throws WCMException {
        int nActionsNow = -1;
        try {
            Number iActions;
            if (!this.isAddMode() && (iActions = (Number)this.getNewProperty("ACTIONS")) != null) {
                nActionsNow = iActions.intValue();
            }
            if (nActionsNow < 0) {
                nActionsNow = this.getDocActionsAsInt();
            }
            nActionsNow = (int)CMyBitsValue.setBit(nActionsNow, _actionType, _bCanDo);
        }
        catch (Exception ex) {
            throw new WCMException(1100, I18NMessage.get(FlowNode.class, "FlowNode.label3", "\u5904\u7406\u6587\u6863\u64cd\u4f5c\u8bbe\u7f6e\u65f6\u5931\u8d25\uff08FlowNode.setDocActions\uff09"), ex);
        }
        return this.setDocActions(nActionsNow);
    }

    public boolean canDelDoc() {
        return this.isCanDoWithDoc(1);
    }

    public boolean canEditDoc() {
        return this.isCanDoWithDoc(0);
    }

    public boolean canPubDoc() {
        return this.isCanDoWithDoc(2);
    }

    public boolean isNeedPostTogether() {
        return this.getPropertyAsBoolean("TOGETHER", false);
    }

    public boolean setNeedPostTogether(boolean _bNeed) throws WCMException {
        return this.setProperty("TOGETHER", _bNeed);
    }

    public boolean isBReasignUsers() {
        return this.getPropertyAsBoolean("BREASIGNUSERS", false);
    }

    public boolean setReasignSepNodes(boolean _bReasignSepNodes) throws WCMException {
        return this.setProperty("BREASIGNSEPNODES", _bReasignSepNodes);
    }

    public boolean isBReasignSepNodes() {
        return this.getPropertyAsBoolean("BREASIGNSEPNODES", false);
    }

    public boolean setReasignUsers(boolean _bReasignUsers) throws WCMException {
        return this.setProperty("BREASIGNUSERS", _bReasignUsers);
    }

    public int getWorkModal() {
        if (this.isNeedPostTogether()) {
            return 1;
        }
        return this.getPropertyAsInt("WorkModal", 0);
    }

    public boolean setWorkModal(int _nWorkModal) throws WCMException {
        return this.setProperty("WorkModal", _nWorkModal);
    }

    @Override
    public boolean isValid() throws WCMException {
        String sName = null;
        if (this.isAddMode()) {
            sName = (String)this.getProperty("NODENAME");
            if (sName == null) {
                throw new WCMException(1106, I18NMessage.get(FlowNode.class, "FlowNode.label4", "\u5c5e\u6027Name\u6ca1\u6709\u8bbe\u7f6e(FlowNode.isValid)"));
            }
            if (this.getProperty("FLOWID") == null) {
                throw new WCMException(1106, I18NMessage.get(FlowNode.class, "FlowNode.label5", "\u5c5e\u6027FlowId\u6ca1\u6709\u8bbe\u7f6e(FlowNode.isValid)"));
            }
        }
        if (sName != null) {
            String strCondition = "(FlowId=" + this.getFlowId() + " and NODENAME='" + CMyString.filterForSQL(sName) + "')";
            if (!this.isAddMode()) {
                strCondition = strCondition + " and (" + this.getIdFieldName() + "<>" + this.getId() + ") ";
            }
            if (this.checkExists(strCondition)) {
                throw new WCMException(1108, I18NMessage.get(FlowNode.class, "FlowNode.label6", "\u540d\u79f0\u5df2\u7ecf\u5b58\u5728(FlowNode.isValid)"));
            }
        }
        return true;
    }

    @Override
    public void insert(User _currUser) throws WCMException {
        if (this.isAddMode()) {
            this.setCrTime();
            super.insert(_currUser);
        }
    }

    @Override
    public int delete(User _currUser) throws WCMException {
        try {
            String[] strSQLs = new String[]{"delete  from wcmFlowNodeOper where  NodeId=" + this.getId()};
            this.getDBManager().sqlExecuteUpdate(strSQLs);
        }
        catch (Exception ex) {
            throw new WCMException(1100, I18NMessage.get(FlowNode.class, "FlowNode.label7", "\u5220\u9664\u8282\u70b9\u4e0a\u7684\u64cd\u4f5c\u8005\u5931\u8d25\uff08FlowNode.delete\uff09"), ex);
        }
        try {
            FlowNodeBranchs branchs = this.getBranchs(_currUser);
            branchs.removeAll();
        }
        catch (Exception ex) {
            throw new WCMException(1100, I18NMessage.get(FlowNode.class, "FlowNode.label8", "\u5220\u9664\u8282\u70b9\u76f8\u5173\u7684\u5206\u652f\u5931\u8d25\uff08FlowNode.delete"), ex);
        }
        return super.delete(_currUser);
    }

    public boolean isStartNode() throws WCMException {
        try {
            Flow flow = this.getFlow();
            if (flow == null) {
                return false;
            }
            String sName = this.getName();
            if (sName == null) {
                return false;
            }
            return sName.compareTo(flow.getStartNodeName()) == 0;
        }
        catch (Exception ex) {
            throw new WCMException(1100, I18NMessage.get(FlowNode.class, "FlowNode.label10", "\u5224\u5b9a\u8d77\u59cb\u8282\u70b9\u5931\u8d25\uff08FlowNode.isStartNode\uff09"), ex);
        }
    }

    public boolean isEndNode() throws WCMException {
        try {
            Flow flow = this.getFlow();
            if (flow == null) {
                return false;
            }
            String sName = this.getName();
            if (sName == null) {
                return false;
            }
            return sName.compareTo(flow.getEndNodeName()) == 0;
        }
        catch (Exception ex) {
            throw new WCMException(1100, I18NMessage.get(FlowNode.class, "FlowNode.label11", "\u5224\u5b9a\u7ed3\u675f\u8282\u70b9\u5931\u8d25\uff08FlowNode.isEndNode\uff09"), ex);
        }
    }

    public Users getOperUsers(User _currUser) throws WCMException {
        return this.getOperUsers(_currUser, false);
    }

    public Users getOperUsers(User _currUser, boolean _bAll) throws WCMException {
        return this.getOperUsers(_currUser, _bAll, "", "", "");
    }

    public Users getOperUsers(User _currUser, boolean _bAll, String _sFrom, String _sWhere, String _sOrder) throws WCMException {
        Users users = null;
        try {
            String sWhere = "wcmFlowNodeOper.OperType=204 and  wcmFlowNodeOper.NodeId=" + this.getId();
            if (_sWhere != null && _sWhere.length() > 1) {
                sWhere = "(" + sWhere + ") and (" + _sWhere + " and wcmFlowNodeOper.OPERID = wcmUser.UserId)";
            }
            String sFrom = "wcmFlowNodeOper";
            if (_sFrom != null && _sFrom.length() > 1) {
                sFrom = sFrom + "," + _sFrom;
            }
            WCMFilter filter = new WCMFilter(sFrom, sWhere, _sOrder, "distinct wcmFlowNodeOper.OPERID as USERID");
            users = new Users(_currUser);
            users.open(filter);
            if (!_bAll) {
                return users;
            }
            sWhere = "wcmGrpUser.GroupId = wcmFlowNodeOper.OPERID and wcmFlowNodeOper.OperType = 201 and  wcmFlowNodeOper.NodeId = " + this.getId();
            if (_sWhere != null && _sWhere.length() > 1) {
                sWhere = "(" + sWhere + ") and (" + _sWhere + " and wcmGrpUser.UserId = wcmUser.UserId)";
            }
            sFrom = "wcmFlowNodeOper,wcmGrpUser";
            if (_sFrom != null && _sFrom.length() > 1) {
                sFrom = sFrom + "," + _sFrom;
            }
            filter = new WCMFilter(sFrom, sWhere, _sOrder, "distinct wcmGrpUser.USERID");
            Users grpUsers = new Users(_currUser);
            grpUsers.open(filter);
            grpUsers.addWith(users);
            String sUserIds = grpUsers.getIdListAsString();
            if (CMyString.isEmpty(sUserIds)) {
                return grpUsers;
            }
            WCMFilter filterAvailable = new WCMFilter("", "IsDeleted=0 and Status=30 and UserId in (" + sUserIds + ")", "");
            grpUsers = new Users(_currUser);
            grpUsers.open(filterAvailable);
            return grpUsers;
        }
        catch (Exception ex) {
            throw new WCMException(1100, I18NMessage.get(FlowNode.class, "FlowNode.label12", "\u53d6\u5de5\u4f5c\u6d41\u8282\u70b9\u7684\u64cd\u4f5c\u7528\u6237\u96c6\u5408\u5931\u8d25(FlowNode.getOperUsers)"), ex);
        }
    }

    public Groups getOperGroups(User _currUser) throws WCMException {
        Groups groups = null;
        try {
            WCMFilter filter = new WCMFilter("wcmFlowNodeOper", "OperType=201 and  NodeId=" + this.getId(), "", "OPERID as GROUPID");
            groups = new Groups(_currUser);
            groups.open(filter);
            return groups;
        }
        catch (Exception ex) {
            throw new WCMException(1100, I18NMessage.get(FlowNode.class, "FlowNode.label13", "\u53d6\u5de5\u4f5c\u6d41\u8282\u70b9\u7684\u64cd\u4f5c\u7528\u6237\u7ec4\u96c6\u5408\u5931\u8d25(FlowNode.getOperGroups)"), ex);
        }
    }

    public FlowNodeBranchs getBranchs(User _currUser) throws WCMException {
        FlowNodeBranchs flowBranchs = null;
        try {
            WCMFilter filter = new WCMFilter("", "NodeId=" + this.getId(), "");
            flowBranchs = new FlowNodeBranchs(_currUser);
            flowBranchs.open(filter);
            return flowBranchs;
        }
        catch (WCMException ex) {
            throw new WCMException(1100, I18NMessage.get(FlowNode.class, "FlowNode.label14", "\u53d6\u5f97\u5de5\u4f5c\u6d41\u8282\u70b9\u4e0a\u7684\u5206\u652f\u96c6\u5408\u65f6\u51fa\u9519\uff08FlowNode.getBranchs\uff09"), ex);
        }
    }

    public FlowNodeBranch getBranchTo(User _currUser, FlowNode _nextNode) throws WCMException {
        if (_nextNode == null) {
            return null;
        }
        WCMFilter filter = new WCMFilter("", "(NodeId=? and NextName=?) or (NodeId=? and NextName=?)", "");
        filter.addSearchValues(this.getId());
        filter.addSearchValues(_nextNode.getName());
        filter.addSearchValues(_nextNode.getId());
        filter.addSearchValues(this.getName());
        FlowNodeBranchs branchs = new FlowNodeBranchs(_currUser, 1, 1);
        branchs.open(filter);
        return branchs.isEmpty() ? null : (FlowNodeBranch)branchs.getAt(0);
    }

    public FlowNodes getNextNodes(User _currUser) throws WCMException {
        return this.getNextNodes(_currUser, null);
    }

    public FlowNodes getNextNodes(User _currUser, WCMFilter _filter) throws WCMException {
        try {
            String sWhere = "(WCMFlowNode.FlowId=" + this.getFlowId() + ") and (WCMFlowBranch.NodeId=" + this.getId() + ") and (WCMFlowNode.NodeName=WCMFlowBranch.NextName)";
            WCMFilter filter = new WCMFilter("WCMFlowNode,WCMFlowBranch", sWhere, "WCMFlowNode.CenterY, WCMFlowNode.NodeId", "distinct WCMFlowNode.NodeId");
            filter.mergeWith(_filter);
            FlowNodes nextNodes = new FlowNodes(_currUser);
            nextNodes.open(filter);
            return nextNodes;
        }
        catch (Exception ex) {
            throw new WCMException(1100, I18NMessage.get(FlowNode.class, "FlowNode.label15", "\u53d6\u4e0b\u4e00\u4e2a\u6d41\u8f6c\u8282\u70b9\u96c6\u5408\uff08FlowNode.getNextNodes\uff09"), ex);
        }
    }

    public boolean isToFirst() {
        return this.getPropertyAsInt("TOFIRST", 0) == 1;
    }

    public void setToFirst(boolean _toFirst) throws WCMException {
        this.setProperty("TOFIRST", _toFirst);
    }

    public static final FlowNode findById(int _nId) throws WCMException {
        if (_nId <= 0) {
            return null;
        }
        return (FlowNode)BaseObj.findById(FlowNode.class, _nId);
    }

    public static final FlowNode createNewInstance() throws WCMException {
        return (FlowNode)BaseObj.createNewInstance(FlowNode.class);
    }

    public static final FlowNode findByKey(Object _oKey) throws WCMException {
        return (FlowNode)BaseObj.findByKey(FlowNode.class, _oKey);
    }

    public static FlowNode findByName(int _nFlowId, String _sNodeName) throws WCMException {
        return FlowNode.getFlowCacheMgr().findFlowNodeByName(_nFlowId, _sNodeName);
    }

    protected static IFlowCacheMgr getFlowCacheMgr() throws WCMException {
        IFlowCacheMgr currMgr = (IFlowCacheMgr)DreamFactory.createObjectById("IFlowCacheMgr");
        if (currMgr == null) {
            throw new WCMException(I18NMessage.get(FlowNode.class, "FlowNode.label16", "IFlowCacheMgr\u5728\u7cfb\u7edf\u4e2d\u6ca1\u6709\u914d\u7f6e\uff01"));
        }
        return currMgr;
    }

    @Override
    public String toString() {
        if (this.IS_ENGVERSION) {
            return this.getName();
        }
        return this.getName() + I18NMessage.get(FlowNode.class, "FlowNode.label17", "[\u8282\u70b9-") + this.getId() + "]";
    }
}

