/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.content;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.persistent.WCMFilter;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public abstract class CMSBaseObjs
extends BaseObjs {
    private static Logger s_logger = Logger.getLogger(CMSBaseObjs.class);
    protected transient User currUser = null;

    public CMSBaseObjs() {
        this.currUser = User.getSystem();
    }

    public CMSBaseObjs(User _currUser) {
        this.currUser = _currUser;
    }

    public CMSBaseObjs(User _currUser, int _initCapacity, int _incCapacity) {
        super(_initCapacity, _incCapacity);
        this.currUser = _currUser;
    }

    public User getCurrUser() {
        return this.currUser;
    }

    public void setCurrUser(User user) {
        this.currUser = user;
    }

    @Override
    protected void updateElement(BaseObj _aObj) throws WCMException {
        if (_aObj == null) {
            throw new WCMException(1100, I18NMessage.get(CMSBaseObjs.class, "CMSBaseObjs.label1", "\u6307\u5b9a\u66f4\u65b0\u7684\u5143\u7d20\u4e3a\u7a7a(") + this.getClass().getName() + ".updateElement)");
        }
        ((CMSObj)_aObj).update(this.currUser);
    }

    public boolean canEditAll() {
        if (this.isEmpty()) {
            return false;
        }
        CMSObj currObj = null;
        for (int i = 0; i < this.size(); ++i) {
            currObj = (CMSObj)this.getAt(i);
            if (currObj == null || currObj.canEdit(this.currUser)) continue;
            for (int j = 0; j < i; ++j) {
                currObj = (CMSObj)this.getAt(j);
                if (currObj == null) continue;
                currObj.cancelUpdate(this.currUser);
            }
            return false;
        }
        return true;
    }

    public boolean canEdit() throws WCMException {
        if (this.currMode != 0) {
            throw new WCMException(1100, I18NMessage.get(CMSBaseObjs.class, "CMSBaseObjs.label2", "\u5f53\u524d\u6a21\u5f0f\u4e0b\u4e0d\u5141\u8bb8\u4fee\u6539\u5143\u7d20(") + this.getClass().getName() + ".canEdit)");
        }
        CMSObj currObj = (CMSObj)this.getCurrent();
        if (currObj == null) {
            return false;
        }
        boolean blCanEdit = currObj.canEdit(this.currUser);
        if (blCanEdit) {
            this.currMode = 2;
        }
        return blCanEdit;
    }

    public boolean canEdit(int _nLockTime) throws WCMException {
        if (this.currMode != 0) {
            throw new WCMException(1100, I18NMessage.get(CMSBaseObjs.class, "CMSBaseObjs.label2", "\u5f53\u524d\u6a21\u5f0f\u4e0b\u4e0d\u5141\u8bb8\u4fee\u6539\u5143\u7d20(") + this.getClass().getName() + ".canEdit)");
        }
        CMSObj currObj = (CMSObj)this.getCurrent();
        if (currObj == null) {
            return false;
        }
        boolean blCanEdit = currObj.canEdit(this.currUser, _nLockTime);
        if (blCanEdit) {
            this.currMode = 2;
        }
        return blCanEdit;
    }

    @Override
    public void cancelUpdateAll(int _end) {
        if (_end <= 0) {
            return;
        }
        switch (this.currMode) {
            case 1: {
                this.objNew = null;
                this.currMode = 0;
                break;
            }
            case 2: {
                int nMax = this.size() > _end ? _end : this.size();
                for (int i = 0; i < nMax; ++i) {
                    try {
                        ((CMSObj)this.getAt(i)).cancelUpdate(this.currUser);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                break;
            }
        }
    }

    @Override
    public void cancelUpdateAll() {
        this.cancelUpdateAll(this.size());
    }

    @Override
    public void cancelUpdate() {
        switch (this.currMode) {
            case 1: {
                this.objNew = null;
                this.currMode = 0;
                break;
            }
            case 2: {
                try {
                    CMSObj currObj = (CMSObj)this.getCurrent();
                    if (currObj != null) {
                        currObj.cancelUpdate(this.currUser);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.currMode = 0;
            }
        }
    }

    public static CMSBaseObjs createInstance(User _currUser, String _sObjsClassName) throws WCMException {
        try {
            return CMSBaseObjs.createInstance(_currUser, Class.forName(_sObjsClassName));
        }
        catch (ClassNotFoundException ex) {
            s_logger.error((Object)("failed to create new instance of " + _sObjsClassName), (Throwable)ex);
            throw new WCMException(1351, I18NMessage.get(CMSBaseObjs.class, "CMSBaseObjs.label3", "\u521b\u5efa\u5bf9\u8c61[") + _sObjsClassName + I18NMessage.get(CMSBaseObjs.class, "CMSBaseObjs.label4", "]\u5b9e\u4f8b\u5931\u8d25!"), ex);
        }
    }

    public static CMSBaseObjs createInstance(User _currUser, Class _classObjs) throws WCMException {
        try {
            return (CMSBaseObjs)_classObjs.getDeclaredConstructor(User.class).newInstance(_currUser);
        }
        catch (Exception ex) {
            s_logger.error((Object)"faile to create new instance of CMSBaseObjs:", (Throwable)ex);
            throw new WCMException(1351, I18NMessage.get(CMSBaseObjs.class, "CMSBaseObjs.label3", "\u521b\u5efa\u5bf9\u8c61[") + _classObjs.getName() + I18NMessage.get(CMSBaseObjs.class, "CMSBaseObjs.label4", "]\u5b9e\u4f8b\u5931\u8d25!"), ex);
        }
    }

    public static CMSBaseObjs openWCMObjs(User _currUser, Class _objsClass, WCMFilter _filter) throws WCMException {
        CMSBaseObjs currObjs = CMSBaseObjs.createInstance(_currUser, _objsClass);
        currObjs.open(_filter);
        return currObjs;
    }

    public static CMSBaseObjs openWCMObjs(User _currUser, String _sObjsClassName, WCMFilter _filter) throws WCMException {
        try {
            return CMSBaseObjs.openWCMObjs(_currUser, Class.forName(_sObjsClassName), _filter);
        }
        catch (ClassNotFoundException ex) {
            s_logger.error((Object)"failed to find objs:", (Throwable)ex);
            throw new WCMException(1100, I18NMessage.get(CMSBaseObjs.class, "CMSBaseObjs.label5", "\u67e5\u8be2\u6307\u5b9a\u5bf9\u8c61\u96c6\u5408[") + _sObjsClassName + "][" + _filter + I18NMessage.get(CMSBaseObjs.class, "CMSBaseObjs.label6", "]\u5931\u8d25!"), ex);
        }
    }

    public static CMSBaseObjs findWCMObjsByIds(User _currUser, Class _classObjs, String _sObjIds) throws WCMException {
        if (_sObjIds == null || _sObjIds.length() == 0) {
            throw new WCMException(10, I18NMessage.get(CMSBaseObjs.class, "CMSBaseObjs.label7", "\u6307\u5b9a\u7684ID\u5e8f\u5217\u65e0\u6548\uff01"));
        }
        if (_classObjs == null) {
            throw new WCMException(10, I18NMessage.get(CMSBaseObjs.class, "CMSBaseObjs.label8", "\u6307\u5b9a\u7684\u96c6\u5408Class\u65e0\u6548\uff01"));
        }
        CMSBaseObjs currObjs = CMSBaseObjs.createInstance(_currUser, _classObjs);
        StringTokenizer stIds = new StringTokenizer(_sObjIds, ",");
        while (stIds.hasMoreTokens()) {
            int nId;
            String sId = stIds.nextToken();
            try {
                nId = Integer.parseInt(sId);
            }
            catch (Exception ex) {
                currObjs.clear();
                currObjs = null;
                throw new WCMException(10, I18NMessage.get(CMSBaseObjs.class, "CMSBaseObjs.label9", "\u6307\u5b9a\u7684ID\u5e8f\u5217\u6709\u8bef[") + _sObjIds + I18NMessage.get(CMSBaseObjs.class, "CMSBaseObjs.label10", "]\uff01\u5305\u542b\u975e\u6570\u5b57\u7c7b\u578b[") + sId + "]!");
            }
            CMSObj currObj = (CMSObj)BaseObj.findById(currObjs.getElementClass(), nId);
            if (currObj == null) continue;
            currObjs.addElement(currObj);
        }
        return currObjs;
    }

    public static CMSBaseObjs findWCMObjsByIds(User _currUser, String _sObjsClassName, String _sObjIds) throws WCMException {
        try {
            return CMSBaseObjs.findWCMObjsByIds(_currUser, Class.forName(_sObjsClassName), _sObjIds);
        }
        catch (ClassNotFoundException ex) {
            s_logger.error((Object)"failed to find objs:", (Throwable)ex);
            throw new WCMException(1100, I18NMessage.get(CMSBaseObjs.class, "CMSBaseObjs.label11", "\u67e5\u8be2\u6307\u5b9a\u5bf9\u8c61[") + _sObjsClassName + "][" + _sObjIds + I18NMessage.get(CMSBaseObjs.class, "CMSBaseObjs.label12", "]\u96c6\u5408\u5931\u8d25!"), ex);
        }
    }

    @Override
    protected boolean removeElement(BaseObj _aObj, int _index, boolean _bDropObj) throws WCMException {
        try {
            if (_bDropObj) {
                ((CMSObj)_aObj).delete(this.currUser);
                if (!_aObj.isCached() && this.getObjsBuffer().remove(_aObj.getKey()) == null) {
                    return false;
                }
            }
            this.vIdList.removeElementAt(_index);
            this.currIndex = _index >= this.size() ? -3 : _index;
            return true;
        }
        catch (Exception ex) {
            throw new WCMException(1100, I18NMessage.get(CMSBaseObjs.class, "CMSBaseObjs.label13", "\u4ece\u96c6\u5408\u4e2d\u5220\u9664\u5143\u7d20\u65f6\u5931\u8d25\uff08") + this.getClass().getName() + ".removeElement).", ex);
        }
    }
}

