/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice;

import com.trs.DreamFactory;
import com.trs.ajaxservice.JSONHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.domain.PublishServer;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.metadata.MetaDataConstants;
import com.trs.components.metadata.center.IMetaViewEmployerMgr;
import com.trs.components.metadata.center.MetaDataCenterClassInfoHelper;
import com.trs.components.metadata.center.MetaDataCenterHelper;
import com.trs.components.metadata.center.MetaViewData;
import com.trs.components.metadata.definition.MetaView;
import com.trs.components.metadata.definition.MetaViewField;
import com.trs.components.metadata.definition.MetaViewFields;
import com.trs.components.wcm.content.domain.ChannelMgr;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Replace;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyDateTime;
import com.trs.util.CMyString;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.ISelfDefinedServiceProvider;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.codehaus.jackson.map.ObjectMapper;

public class MasServiceProvider
implements ISelfDefinedServiceProvider {
    private static Logger logger = Logger.getLogger(MasServiceProvider.class);
    private User m_currUser = User.getSystem();
    private static String ERROR_SAVE_METADATA = "-1";
    private static String ERROR_CHANNEL_NOTFOUND = "-102";
    private static String ERROR_DATE_NOTFOUND = "-103";
    private static String ERROR_VIEW_NOTFOUND = "-104";

    public String pushMetaViewData(MethodContext _methodContext) throws WCMException {
        String sResultNum = ERROR_SAVE_METADATA;
        String sResultTxt = "";
        HashMap<String, Object> hResult = new HashMap<String, Object>();
        int nParentChannelId = _methodContext.getValue("ChannelId", 0);
        try {
            boolean bCreatChildChannel = _methodContext.getValue("isCreateChannel", false);
            int nMasId = _methodContext.getValue("MasId", 0);
            CMyDateTime dtValue = _methodContext.getValue("CreateTime", CMyDateTime.now());
            Channel parentChannel = Channel.findById(nParentChannelId);
            if (parentChannel == null) {
                sResultNum = ERROR_CHANNEL_NOTFOUND;
                sResultTxt = "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u680f\u76ee[ID=" + nParentChannelId + "]\uff01";
                throw new WCMException(I18NMessage.get(MasServiceProvider.class, "MasServiceProvider.labe1", sResultTxt));
            }
            String sYear = String.valueOf(dtValue.getYear());
            if (CMyString.isEmpty((String)sYear)) {
                sResultNum = ERROR_DATE_NOTFOUND;
                sResultTxt = "\u6587\u6863\u4fdd\u5b58\u65f6\u95f4\u83b7\u53d6\u9519\u8bef\uff0c\u4f20\u5165\u53c2\u6570\uff1a [" + dtValue.toString() + "]\uff01";
                throw new WCMException(I18NMessage.get(MasServiceProvider.class, "MasServiceProvider.labe2", sResultTxt));
            }
            IMetaViewEmployerMgr oMetaViewEmployerMgr = (IMetaViewEmployerMgr)DreamFactory.createObjectById("IMetaViewEmployerMgr");
            MetaView oMetaView = oMetaViewEmployerMgr.getViewOfEmployer(parentChannel);
            if (oMetaView == null) {
                sResultNum = ERROR_VIEW_NOTFOUND;
                sResultTxt = "\u6307\u5b9a\u680f\u76ee\u6ca1\u6709\u914d\u7f6e\u89c6\u56fe,\u680f\u76ee\u7684id\u4e3a[" + nParentChannelId + "]\uff01";
                throw new WCMException(I18NMessage.get(MasServiceProvider.class, "MasServiceProvider.labe3", sResultTxt));
            }
            Channel newChildChannel = null;
            if (bCreatChildChannel) {
                newChildChannel = this.getCreateChildChannel(parentChannel, sYear);
                oMetaViewEmployerMgr.setEmployer(this.m_currUser, newChildChannel, oMetaView);
            } else {
                newChildChannel = parentChannel;
            }
            MetaViewFields oViewFields = oMetaView.getViewFields(null, null);
            HashMap<String, String> hMap = new HashMap<String, String>();
            int nSize = oViewFields.size();
            for (int i = 0; i < nSize; ++i) {
                String sMetaViewField;
                String sDefaultReplaceContent;
                MetaViewField oViewField = (MetaViewField)oViewFields.getAt(i);
                if (oViewField == null || CMyString.isEmpty((String)(sDefaultReplaceContent = Replace.replace(nParentChannelId, sMetaViewField = oViewField.getName())))) continue;
                hMap.put(sMetaViewField, sDefaultReplaceContent);
            }
            MetaViewData oMetaViewData = new MetaViewData(oMetaView);
            Iterator iter = hMap.keySet().iterator();
            if (hMap.isEmpty()) {
                logger.info((Object)("\u680f\u76ee [ " + parentChannel.getName() + " ] \u6ca1\u6709\u8bbe\u7f6e\u66ff\u6362\u5b57\u6bb5\u5185\u5bb9\uff0c\u53ef\u80fd\u5bfc\u81f4\u8bb0\u5f55\u4e2d\u6ca1\u6709\u6570\u636e"));
            }
            while (iter.hasNext()) {
                String sFieldName = (String)iter.next();
                String sValue = (String)hMap.get(sFieldName);
                if (CMyString.isEmpty((String)sFieldName)) continue;
                logger.debug((Object)("\u63a8\u9001\u6570\u636eKey-Value\uff1a [ " + sFieldName + " - " + sValue + " ]"));
                oMetaViewData.setProperty(sFieldName, sValue);
            }
            oMetaViewData.setProperty("ChannelId", newChildChannel.getId());
            oMetaViewData.setProperty("MasId", String.valueOf(nMasId));
            oMetaViewData.setProperty("Reltime", dtValue.toString());
            MetaDataCenterHelper.renderFields(oMetaViewData);
            MetaDataCenterClassInfoHelper.renderClassInfoFields(oMetaViewData);
            try {
                oMetaViewData.save(this.m_currUser);
            }
            catch (Exception e) {
                sResultNum = ERROR_SAVE_METADATA;
                sResultTxt = "\u5fc5\u586b\u5b57\u6bb5\u6ca1\u6709\u8bbe\u7f6e\u66ff\u6362\u89c4\u5219,\u6216\u8005\u540c\u6b65\u89c4\u5219\u540c\u6b65\u7684\u5b57\u6bb5\u503c\u4e3a\u7a7a";
                throw new WCMException(sResultTxt, e);
            }
            int nMetaViewDataId = oMetaViewData.getId();
            hResult.put("DocId", nMetaViewDataId);
            if (nMetaViewDataId <= 0) {
                hResult.put("Result", "Error,WCM\u680f\u76ee[" + nParentChannelId + "]\u4fdd\u5b58\u7531MAS\u63a8\u9001\u7684\u6570\u636e\u65f6\u5931\u8d25\uff01");
            } else {
                hResult.put("Result", "Success,\u521b\u5efa\u8bb0\u5f55\u6210\u529f");
            }
        }
        catch (Exception ex) {
            logger.error((Object)"\u63a8\u9001\u5931\u8d25", (Throwable)ex);
            hResult.put("DocId", sResultNum);
            hResult.put("Result", "Error,Mas\u5411WCM\u680f\u76ee[" + nParentChannelId + "]\u63a8\u9001\u6570\u636e\u51fa\u73b0\u9519\u8bef\uff01\n\u53ef\u80fd\u539f\u56e0\u4e3a: " + sResultTxt);
        }
        _methodContext.setReturnJSON(true);
        return JSONHelper.toSimpleJSON(hResult, 0);
    }

    private Channel getCreateChildChannel(Channel _parentChannel, String _sChannelName) throws WCMException {
        Channel newChildChannel = _parentChannel;
        ChannelMgr oChannelMgr = (ChannelMgr)DreamFactory.createObjectById("ChannelMgr");
        List<Channel> childrenChannelList = _parentChannel.getAllChildren(this.m_currUser);
        boolean bCreateChannel = true;
        for (Channel childChannel : childrenChannelList) {
            if (!_sChannelName.equals(childChannel.getName())) continue;
            bCreateChannel = false;
            newChildChannel = childChannel;
        }
        if (bCreateChannel) {
            Channel newChannel = new Channel();
            newChannel.setPropertyWithString("CHNLNAME", _sChannelName);
            newChannel.setPropertyWithString("CHNLDESC", _sChannelName);
            newChannel.setSite(_parentChannel.getSiteId());
            newChannel.setParent(_parentChannel.getId());
            oChannelMgr.save(newChannel);
            newChildChannel = Channel.findById(newChannel.getId());
        }
        return newChildChannel;
    }

    public void updateMetaViewDataPV(MethodContext _methodContext) throws WCMException {
        String sJsonArray = _methodContext.getValue("JsonArray");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)sJsonArray);
        }
        Map[] pResult = null;
        ObjectMapper oJSONMap = new ObjectMapper();
        try {
            pResult = (Map[])oJSONMap.readValue(sJsonArray, Map[].class);
        }
        catch (Exception e) {
            throw new WCMException("MAS\u63d0\u4f9b\u53c2\u6570\u4e0d\u7b26\u5408\u9884\u671f\uff1f[\u53c2\u6570\u4e3a\uff1aJsonArray=" + sJsonArray + "]", e);
        }
        for (int i = 0; i < pResult.length; ++i) {
            Map masMap = pResult[i];
            String sDocId = String.valueOf(masMap.get("appObjectId"));
            int nDocId = Integer.parseInt(sDocId);
            String sFieldValue = String.valueOf(masMap.get("incPlayCount"));
            int nIncPV = Integer.parseInt(sFieldValue);
            try {
                MetaView metaView = this.getMetaViewQuick(nDocId);
                if (metaView == null) {
                    throw new WCMException("\u6587\u6863ID\u4e0d\u5408\u6cd5\u6216\u8005\u6587\u6863\u4e0d\u662f\u8d44\u6e90\u5e93\u4e2d\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\u4f20\u5165\u7684\u6587\u6863ID");
                }
                String sMetaDataTableName = MetaDataConstants.makeTrueTableName(metaView.getMainTableName());
                this.updataMetaViewData(sMetaDataTableName, "PV", nIncPV, nDocId);
                Document document = Document.findById(nDocId, "DocId,DocTitle,DocChannel,DocStatus,DocKind");
                this.directRefreshPublishData(document);
                continue;
            }
            catch (Exception e) {
                logger.error((Object)("Fail to update the PV of data[id=" + nDocId + "]"), (Throwable)e);
            }
        }
    }

    private void directRefreshPublishData(Document _document) throws WCMException {
        if (_document.getStatusId() != 10) {
            return;
        }
        WCMFilter filter = new WCMFilter("WCMChnlDoc", "DocId=? and DocStatus=?", "", "ChnlId as ChannelId");
        filter.addSearchValues(_document.getId());
        filter.addSearchValues(10);
        Channels channels = Channels.openWCMObjs(this.m_currUser, filter);
        int nSize = channels.size();
        for (int i = 0; i < nSize; ++i) {
            Channel channel = (Channel)channels.getAt(i);
            if (channel == null) continue;
            IPublishFolder folder = (IPublishFolder)PublishElementFactory.makeElementFrom(channel);
            IPublishContent content = PublishElementFactory.makeContentFrom(_document, folder);
            PublishServer.getInstance().publishContent(content, 3);
        }
    }

    private MetaView getMetaViewQuick(int _nDocId) throws Exception {
        DBManager dbMgr = DBManager.getDBManager();
        int nViewId = 0;
        nViewId = dbMgr.sqlExecuteIntQuery("select DOCKIND from WCMDocument where DOCID =?", new int[]{_nDocId});
        if (nViewId <= 0) {
            throw new WCMException("\u6307\u5b9a\u7684\u6570\u636e[ID=" + _nDocId + "]\u6ca1\u6709\u5173\u8054\u89c6\u56fe\uff01");
        }
        return MetaView.findById(nViewId);
    }

    private void updataMetaViewData(String _sTableName, String _sName, int _nIncPV, int _nDocId) {
        DBManager dbMgr = DBManager.getDBManager();
        try {
            StringBuffer sbSetValue = new StringBuffer();
            sbSetValue.append(_sName).append("=");
            int nType = dbMgr.getDBTypeAsInt();
            switch (nType) {
                case 3: 
                case 5: 
                case 6: {
                    sbSetValue.append("coalesce(").append(_sName).append(",0)+?");
                    break;
                }
                case 7: {
                    sbSetValue.append("ifnull(").append(_sName).append(",0)+?");
                    break;
                }
                case 1: {
                    sbSetValue.append("nvl(").append(_sName).append(",0)+?");
                    break;
                }
                case 2: 
                case 4: {
                    sbSetValue.append("isnull(").append(_sName).append(",0)+?");
                    break;
                }
                default: {
                    sbSetValue.append(_sName).append("+?");
                }
            }
            String sUpdateColumnValueSQL = "update " + _sTableName + " set " + sbSetValue + " where MetaDataId=?";
            if (logger.isDebugEnabled()) {
                logger.debug((Object)sUpdateColumnValueSQL);
            }
            dbMgr.sqlExecuteUpdate(new String[]{sUpdateColumnValueSQL}, new int[]{_nIncPV, _nDocId});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

