/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.discover.impl;

import com.trs.infra.discover.impl.ASMUtil;
import com.trs.infra.discover.impl.Container;
import com.trs.infra.discover.impl.NodeDirectory;
import com.trs.infra.discover.impl.NodeResource;
import com.trs.infra.discover.impl.NodeType;
import java.net.URL;
import trs.org.objectweb.asm.tree.ClassNode;

public class ContainerByDir
extends Container {
    private String m_sTrimPrefix;

    public ContainerByDir(URL location, String sTrimPrefix) {
        super(location);
        this.m_sTrimPrefix = sTrimPrefix;
    }

    void trimDirectory(String path) {
        this.addDirectory(this.trimPrefix(path));
    }

    void trimResourceAny(String path, URL url) {
        if (!(path = this.trimPrefix(path)).endsWith(".class")) {
            this.addResource(path, url);
            return;
        }
        ClassNode cn = ASMUtil.getNodeFromURL(url);
        if (cn == null) {
            this.addResource(path, url);
            return;
        }
        this.addType(path, cn, url);
    }

    private void addResource(String path, URL url) {
        String[] names = ContainerByDir.splitPath(path);
        int count = names.length;
        if (count <= 0) {
            return;
        }
        if (count == 1) {
            this.addRootNode(this.newResource(names[0], path, url));
            return;
        }
        NodeDirectory parent = this.getRootDirectory(names[0]);
        int limit = count - 1;
        int i = 1;
        while (i < limit) {
            parent = parent.getDirectoryNode(names[i]);
            ++i;
        }
        parent.addChild(this.newResource(names[limit], path, url));
    }

    private NodeResource newResource(String name, String path, URL url) {
        return new NodeResource(name, url);
    }

    private void addType(String path, ClassNode cn, URL url) {
        String[] names = ContainerByDir.splitPath(path);
        int count = names.length;
        if (count <= 0) {
            return;
        }
        if (count == 1) {
            this.addRootNode(this.newType(names[0], path, cn, url));
            return;
        }
        NodeDirectory parent = this.getRootDirectory(names[0]);
        int limit = count - 1;
        int i = 1;
        while (i < limit) {
            parent = parent.getDirectoryNode(names[i]);
            ++i;
        }
        parent.addChild(this.newType(names[limit], path, cn, url));
    }

    private NodeType newType(String name, String path, ClassNode cn, URL url) {
        return new NodeType(name, url, cn);
    }

    private String trimPrefix(String path) {
        if (this.m_sTrimPrefix == null) {
            return path;
        }
        return path.substring(this.m_sTrimPrefix.length());
    }
}

