/*
 * Decompiled with CFR 0.152.
 */
package de.laures.cewolf.taglib.tags;

import de.laures.cewolf.ChartPostProcessor;
import de.laures.cewolf.taglib.AbstractChartDefinition;
import de.laures.cewolf.taglib.TaglibConstants;
import de.laures.cewolf.taglib.tags.CewolfRootTag;
import de.laures.cewolf.taglib.tags.CewolfTag;
import de.laures.cewolf.taglib.tags.Painted;
import java.awt.Paint;
import java.util.Map;
import javax.servlet.jsp.JspException;

public abstract class AbstractChartTag
extends CewolfTag
implements CewolfRootTag,
TaglibConstants,
Painted {
    protected AbstractChartDefinition chartDefinition = this.createChartDefinition();

    protected abstract AbstractChartDefinition createChartDefinition();

    public int doStartTag() {
        return 1;
    }

    public int doEndTag() throws JspException {
        this.pageContext.setAttribute(this.getId(), (Object)this.chartDefinition, 1);
        return this.doAfterEndTag(6);
    }

    public void reset() {
        this.chartDefinition = this.createChartDefinition();
    }

    public String getChartId() {
        return this.getId();
    }

    public void setTitle(String title) {
        this.chartDefinition.setTitle(title);
    }

    public void setXaxislabel(String xAxisLabel) {
        this.chartDefinition.setXAxisLabel(xAxisLabel);
    }

    public void setYaxislabel(String yAxisLabel) {
        this.chartDefinition.setYAxisLabel(yAxisLabel);
    }

    public void setBackground(String src) {
        String srcFile = this.pageContext.getServletContext().getRealPath(src);
        this.chartDefinition.setBackground(srcFile);
    }

    public void setBackgroundimagealpha(Float alpha) {
        this.chartDefinition.setBackgroundImageAlpha(alpha.floatValue());
    }

    public void setAntialias(boolean anti) {
        this.chartDefinition.setAntialias(anti);
    }

    public void setShowlegend(boolean legend) {
        this.chartDefinition.setShowLegend(legend);
    }

    public void setLegendanchor(String anchor) {
        if ("north".equalsIgnoreCase(anchor)) {
            this.chartDefinition.setLegendAnchor(100);
        } else if ("south".equalsIgnoreCase(anchor)) {
            this.chartDefinition.setLegendAnchor(101);
        } else if ("west".equalsIgnoreCase(anchor)) {
            this.chartDefinition.setLegendAnchor(103);
        } else if ("east".equalsIgnoreCase(anchor)) {
            this.chartDefinition.setLegendAnchor(102);
        }
    }

    public void addChartPostProcessor(ChartPostProcessor pp, Map params) {
        this.chartDefinition.addPostProcessor(pp);
        this.chartDefinition.addPostProcessorParams(params);
    }

    public void setPaint(Paint paint) {
        this.chartDefinition.setPaint(paint);
    }

    public void setType(String type) {
        this.chartDefinition.setType(type);
    }
}

