/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.impl.recovery;

import com.rabbitmq.client.Command;
import com.rabbitmq.client.MetricsCollector;
import com.rabbitmq.client.NoOpMetricsCollector;
import com.rabbitmq.client.impl.AMQConnection;
import com.rabbitmq.client.impl.AMQImpl;
import com.rabbitmq.client.impl.ChannelN;
import com.rabbitmq.client.impl.ConsumerWorkService;
import java.io.IOException;

public class RecoveryAwareChannelN
extends ChannelN {
    private long maxSeenDeliveryTag = 0L;
    private long activeDeliveryTagOffset = 0L;

    public RecoveryAwareChannelN(AMQConnection connection, int channelNumber, ConsumerWorkService workService) {
        this(connection, channelNumber, workService, new NoOpMetricsCollector());
    }

    public RecoveryAwareChannelN(AMQConnection connection, int channelNumber, ConsumerWorkService workService, MetricsCollector metricsCollector) {
        super(connection, channelNumber, workService, metricsCollector);
    }

    @Override
    protected void processDelivery(Command command, AMQImpl.Basic.Deliver method) {
        long tag = method.getDeliveryTag();
        if (tag > this.maxSeenDeliveryTag) {
            this.maxSeenDeliveryTag = tag;
        }
        super.processDelivery(command, this.offsetDeliveryTag(method));
    }

    private AMQImpl.Basic.Deliver offsetDeliveryTag(AMQImpl.Basic.Deliver method) {
        return new AMQImpl.Basic.Deliver(method.getConsumerTag(), method.getDeliveryTag() + this.activeDeliveryTagOffset, method.getRedelivered(), method.getExchange(), method.getRoutingKey());
    }

    @Override
    public void basicAck(long deliveryTag, boolean multiple) throws IOException {
        long realTag = deliveryTag - this.activeDeliveryTagOffset;
        if (realTag >= 0L) {
            super.basicAck(realTag, multiple);
        }
    }

    @Override
    public void basicNack(long deliveryTag, boolean multiple, boolean requeue) throws IOException {
        long realTag = deliveryTag - this.activeDeliveryTagOffset;
        if (realTag >= 0L) {
            super.basicNack(realTag, multiple, requeue);
        }
    }

    @Override
    public void basicReject(long deliveryTag, boolean requeue) throws IOException {
        long realTag = deliveryTag - this.activeDeliveryTagOffset;
        if (realTag > 0L) {
            super.basicReject(realTag, requeue);
        }
    }

    void inheritOffsetFrom(RecoveryAwareChannelN other) {
        this.activeDeliveryTagOffset = other.getActiveDeliveryTagOffset() + other.getMaxSeenDeliveryTag();
        this.maxSeenDeliveryTag = 0L;
    }

    public long getMaxSeenDeliveryTag() {
        return this.maxSeenDeliveryTag;
    }

    public long getActiveDeliveryTagOffset() {
        return this.activeDeliveryTagOffset;
    }
}

