/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.client.filter;

import com.trs.idm.interact.agent.IAgent;
import com.trs.idm.util.StringHelper;
import java.io.IOException;
import javax.servlet.ServletException;
import org.apache.log4j.Logger;

public class IdsAgentAccessHelper {
    private static final Logger LOG = Logger.getLogger(IdsAgentAccessHelper.class);
    private IAgent agent;
    private String[] ignoreUrlPrefixes;
    protected String[] onlyProcessPrefixes;
    protected String[] regUserURIs;
    protected String[] logoutURIs;
    protected String[] loginActionURIs;
    protected String loginActionMethod;
    protected String loginActionURIMode;
    protected String logoutURIMode;
    protected String[] ignoreIDSUrls = new String[]{"/TRSIdSSSOProxyServlet", "/idsAgents/GetLongUrlServlet"};

    public IdsAgentAccessHelper(IAgent agent) {
        this.agent = agent;
        this.init();
    }

    private void init() {
        this.ignoreUrlPrefixes = this.agent.getIgnoreUrlPrefixes();
        this.onlyProcessPrefixes = StringHelper.split((String)this.agent.getProperty("processUrl.prefix", null), (String)",");
        this.regUserURIs = this.agent.getRegUserURIs();
        this.logoutURIs = this.agent.getLogoutURIs();
        this.loginActionURIs = this.agent.getLoginActionURIs();
        this.loginActionMethod = this.agent.getLoginActionMethod();
        this.loginActionURIMode = this.agent.getProperty("loginAction.uri.matchPattern", "startWith");
        this.logoutURIMode = this.agent.getProperty("logout.uri.matchPattern", "startWith");
    }

    protected boolean isRegRequest(String relativePathWithPara) {
        if (this.regUserURIs != null) {
            int i = 0;
            while (i < this.regUserURIs.length) {
                if (relativePathWithPara.startsWith(this.regUserURIs[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    protected boolean needIgnore(String servletPath) throws ServletException, IOException {
        if (servletPath.trim().length() == 0) {
            return true;
        }
        if (servletPath.startsWith("/WEB-INF/")) {
            LOG.info((Object)("ignore /WEB-INF/*. fullPath=" + servletPath));
            return true;
        }
        if (this.ignoreUrlPrefixes != null) {
            int i = 0;
            while (i < this.ignoreUrlPrefixes.length) {
                if (servletPath.startsWith(this.ignoreUrlPrefixes[i])) {
                    LOG.debug((Object)("actualPathWithParamter[" + servletPath + "] matches [" + this.ignoreUrlPrefixes[i] + "]; it will be ignore."));
                    return true;
                }
                ++i;
            }
        }
        LOG.debug((Object)("actualPathWithParamter[" + servletPath + "] should not be ignored"));
        return false;
    }

    public boolean isLogoutRequest(String relativePathWithPara) {
        boolean isSSOlogoutReq = false;
        if (this.logoutURIs != null) {
            int i = 0;
            while (i < this.logoutURIs.length) {
                if ("contains".equals(this.logoutURIMode)) {
                    if (relativePathWithPara.indexOf(this.logoutURIs[i]) >= 0) {
                        isSSOlogoutReq = true;
                        break;
                    }
                } else if ("endWith".equals(this.logoutURIMode)) {
                    if (relativePathWithPara.endsWith(this.logoutURIs[i])) {
                        isSSOlogoutReq = true;
                        break;
                    }
                } else if (relativePathWithPara.startsWith(this.logoutURIs[i])) {
                    isSSOlogoutReq = true;
                    break;
                }
                ++i;
            }
        }
        return isSSOlogoutReq;
    }

    protected boolean isVerifyButNotLoginRequest(String relativePathWithPara) {
        if (relativePathWithPara.trim().length() == 0) {
            return false;
        }
        String[] justVerifyPrefixes = StringHelper.split((String)this.agent.getProperty("verifyButNotLogin.uri", null), (String)",");
        if (justVerifyPrefixes != null) {
            int i = 0;
            while (i < justVerifyPrefixes.length) {
                if (relativePathWithPara.startsWith(justVerifyPrefixes[i])) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("needVerifyButNotLogin(req), servletPath=" + relativePathWithPara));
                    }
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public boolean isSSOLoginReqByLocalPage(String relativePathWithPara, String method) {
        boolean isValid;
        boolean isSSOLoginReq = false;
        boolean bl = isValid = !StringHelper.isEmpty((String)this.loginActionMethod) && ("POST".equalsIgnoreCase(this.loginActionMethod) || "GET".equalsIgnoreCase(this.loginActionMethod));
        if (this.loginActionURIs != null) {
            int i = 0;
            while (i < this.loginActionURIs.length) {
                if ("contains".equals(this.loginActionURIMode)) {
                    if (relativePathWithPara.indexOf(this.loginActionURIs[i]) >= 0) {
                        isSSOLoginReq = true;
                        break;
                    }
                } else if ("endWith".equals(this.loginActionURIMode)) {
                    if (relativePathWithPara.endsWith(this.loginActionURIs[i])) {
                        isSSOLoginReq = true;
                        break;
                    }
                } else if (relativePathWithPara.startsWith(this.loginActionURIs[i])) {
                    isSSOLoginReq = true;
                    break;
                }
                ++i;
            }
        }
        if (isSSOLoginReq && isValid && !StringHelper.isEmpty((String)method)) {
            isSSOLoginReq = this.loginActionMethod.equalsIgnoreCase(method);
        }
        return isSSOLoginReq;
    }

    protected boolean isUrlInProcessUrlPrefix(String relativePathWithPara) {
        if (this.onlyProcessPrefixes != null) {
            int i = 0;
            while (i < this.onlyProcessPrefixes.length) {
                if (relativePathWithPara.startsWith(this.onlyProcessPrefixes[i])) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("matchProcessUrl=true. servletPath=" + relativePathWithPara));
                    }
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public boolean isMustProcessUrls(String relativePathWithPara, String method) {
        if (this.isUrlInProcessUrlPrefix(relativePathWithPara)) {
            return true;
        }
        if (this.isRegRequest(relativePathWithPara)) {
            return true;
        }
        if (this.isSSOLoginReqByLocalPage(relativePathWithPara, method)) {
            return true;
        }
        if (this.isVerifyButNotLoginRequest(relativePathWithPara)) {
            return true;
        }
        if (this.isLogoutRequest(relativePathWithPara)) {
            return true;
        }
        if (this.isAgentDebugJsp(relativePathWithPara)) {
            return true;
        }
        if (this.isCheckAgentPropertiesRequest(relativePathWithPara)) {
            return true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("matchProcessUrl=false. servletPath=" + relativePathWithPara));
        }
        return false;
    }

    protected boolean isAgentDebugJsp(String relativePathWithPara) {
        String servletPath = relativePathWithPara;
        if (relativePathWithPara.contains("?")) {
            servletPath = relativePathWithPara.substring(0, relativePathWithPara.lastIndexOf("?"));
        }
        return servletPath.startsWith("/idsAgents/") && servletPath.endsWith(".jsp");
    }

    protected boolean isCheckAgentPropertiesRequest(String requestUrl) {
        return requestUrl.indexOf("/checkIDSAgentConfig.jsp") > 0;
    }

    protected boolean isIDSRequest(String header) {
        boolean isIDSRequest = "TRS Identity Server".equals(header);
        LOG.debug((Object)("isIDSRequest:" + isIDSRequest + ", req.getHeader(HttpConst.HEADER_USER_AGENT):" + header));
        return isIDSRequest;
    }

    protected boolean isIDSURL(String requestUrl) {
        int i = 0;
        while (i < this.ignoreIDSUrls.length) {
            if (requestUrl.startsWith(this.ignoreIDSUrls[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

