/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.saml.interact.impl.simple.request;

import com.trs.idm.exception.ServiceProviderException;
import com.trs.idm.saml.interact.IResponse;
import com.trs.idm.saml.interact.RequestBase;
import com.trs.idm.saml.sp.core.IServiceProvider;
import com.trs.idm.util.Base64Util;
import com.trs.idm.util.RequestUtil;
import com.trs.idm.util.StringHelper;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class SimpleSelfPageLoginRedirectRequest
extends RequestBase {
    private String userNameField;
    private String passwordField;
    private String selfLoginPageUserName;
    private String selfLoginPagePassword;
    private String relayState;
    private String base64relayState;
    private String queryString;
    private String base64QueryString;
    private String originalPostParameters;
    private String base64OriginalPostParameters;
    private static final Logger LOG = Logger.getLogger(SimpleSelfPageLoginRedirectRequest.class);

    public SimpleSelfPageLoginRedirectRequest(IServiceProvider sp, HttpServletRequest request) {
        this.requestType = "SimpleSelfPageLoginRedirectRequest";
        this.relayState = request.getRequestURL().toString();
        this.base64relayState = Base64Util.encode(this.relayState);
        this.queryString = request.getQueryString();
        if (!StringHelper.isEmpty(this.queryString)) {
            this.base64QueryString = Base64Util.encode(this.queryString);
        }
        this.originalPostParameters = RequestUtil.getPostParametersAsString(request);
        if (!StringHelper.isEmpty(this.originalPostParameters)) {
            this.base64OriginalPostParameters = Base64Util.encode(this.originalPostParameters);
        }
        this.serviceProvider = sp;
        this.userNameField = sp.getConfig().getConfig("sso.selfLoginPage.userName.field", "userName");
        this.passwordField = sp.getConfig().getConfig("sso.selfLoginPage.password.field", "password");
        this.selfLoginPageUserName = request.getParameter(this.userNameField);
        this.selfLoginPagePassword = request.getParameter(this.passwordField);
        String originalPostParametersWithoutPwd = null;
        originalPostParametersWithoutPwd = this.originalPostParameters != null && -1 != this.originalPostParameters.indexOf(this.passwordField) ? String.valueOf(this.originalPostParameters.substring(0, this.originalPostParameters.indexOf(this.passwordField))) + this.originalPostParameters.substring(this.originalPostParameters.indexOf(this.selfLoginPagePassword) + this.selfLoginPagePassword.length()) : this.originalPostParameters;
        LOG.info((Object)("relayState: " + this.relayState + "; queryString: " + this.queryString + "; postParamters: " + originalPostParametersWithoutPwd));
        LOG.info((Object)("userNameField: " + this.userNameField + "; passwordField=" + this.passwordField));
        LOG.debug((Object)("selfLoginPageUserName: " + this.selfLoginPageUserName + "; originalPostParameters: " + originalPostParametersWithoutPwd));
    }

    public IResponse doRequest(HttpServletRequest request, HttpServletResponse response) throws ServiceProviderException {
        LOG.info((Object)("is about to forward to: " + this.serviceProvider.getAutoSubmitPage()));
        LOG.debug((Object)("selfLoginPageUserName: " + this.selfLoginPageUserName));
        request.setAttribute("request_type", (Object)this.requestType);
        request.setAttribute("targetURL", (Object)Base64Util.encode(this.serviceProvider.getIDPUrl()));
        request.setAttribute("coAppName", (Object)this.serviceProvider.getCoAppName());
        request.setAttribute("coSessionId", (Object)request.getSession().getId());
        request.setAttribute("sso.selfLoginPage.userName.field", (Object)this.userNameField);
        request.setAttribute("sp.simple.selfLoginPage.userName.vale", (Object)this.selfLoginPageUserName);
        request.setAttribute("sso.selfLoginPage.password.field", (Object)this.passwordField);
        request.setAttribute("sp.simple.selfLoginPage.password.value", (Object)this.selfLoginPagePassword);
        request.setAttribute("RelayState", (Object)this.base64relayState);
        if (!StringHelper.isEmpty(this.base64QueryString)) {
            request.setAttribute("queryString", (Object)this.base64QueryString);
        }
        if (!StringHelper.isEmpty(this.base64OriginalPostParameters)) {
            request.setAttribute("postParameters", (Object)this.base64OriginalPostParameters);
        }
        String afterLoginOKUrl = this.getAferLoginOkUrl(request);
        String afterLoginFailUrl = this.getAferLoginFailUrl(request);
        request.setAttribute("afterLoginOK.gotoUrl", (Object)afterLoginOKUrl);
        request.setAttribute("afterLoginFail.gotoUrl", (Object)afterLoginFailUrl);
        try {
            request.getRequestDispatcher(this.serviceProvider.getAutoSubmitPage()).forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (ServletException e) {
            LOG.error((Object)"error while redicect to autoSubmit page", (Throwable)e);
            throw new ServiceProviderException("\u91cd\u5b9a\u5411\u5230" + this.serviceProvider.getAutoSubmitPage() + "\u65f6\u53d1\u751f\u5f02\u5e38\uff0c\u8bf7\u786e\u8ba4\u8def\u5f84\u662f\u5426\u6b63\u786e!", e);
        }
        catch (IOException e) {
            LOG.error((Object)"error while redicect to autoSubmit page", (Throwable)e);
            throw new ServiceProviderException("\u91cd\u5b9a\u5411\u5230" + this.serviceProvider.getAutoSubmitPage() + "\u65f6\u53d1\u751f\u5f02\u5e38\uff0c\u8bf7\u786e\u8ba4\u8def\u5f84\u662f\u5426\u6b63\u786e!", e);
        }
        return null;
    }

    public IServiceProvider getServiceProvider() {
        return this.serviceProvider;
    }
}

