/*
 * Decompiled with CFR 0.152.
 */
package com.trs.net.smtp;

import com.trs.net.smtp.Csmtp;
import com.trs.net.smtp.SmtpClientPI;

abstract class Command {
    String m_sName = null;
    String[] m_sAlias = null;
    String m_sUsage;
    String m_sHelpInfo;
    boolean m_zSupported = false;
    protected static SmtpClientPI client = Csmtp.s_oClient;

    public String getName() {
        return this.m_sName;
    }

    void setName(String name) {
        this.setName(name, null);
    }

    void setName(String name, String[] alias) {
        this.m_sName = name;
        if (alias != null && alias.length > 0) {
            this.m_sAlias = alias;
        } else {
            this.m_sAlias = new String[1];
            this.m_sAlias[0] = this.m_sName;
        }
    }

    public String[] getAlias() {
        return this.m_sAlias;
    }

    public boolean getSupported() {
        return this.m_zSupported;
    }

    public void setSupported(boolean zSupported) {
        this.m_zSupported = zSupported;
    }

    public String getHelpInfo() {
        if (this.m_sHelpInfo == null) {
            return "";
        }
        return this.m_sHelpInfo;
    }

    void setHelpInfo(String info) {
        this.m_sHelpInfo = info;
    }

    public String getUsage() {
        return this.m_sUsage;
    }

    void setUsage(String info) {
        this.m_sUsage = info;
    }

    public void outUsage() {
        System.out.println(this.getUsage());
    }

    public void outFtpReply() {
        if (Csmtp.s_zOutReplys) {
            System.out.print(Csmtp.s_oClient.getReplyString());
        }
    }

    Command getCommandByName(String name) {
        return (Command)Csmtp.s_oValidCmds.get(name);
    }

    public void exec(String[] args) {
        try {
            if (this.prepare()) {
                this.execute(args);
                this.cleanup();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean prepare() {
        if (Csmtp.s_oClient.isConnected()) {
            return true;
        }
        System.out.println("Not connected.");
        return false;
    }

    public void execute(String[] args) throws Exception {
        System.out.println(String.valueOf(this.getName()) + " : Unimplemented command.");
    }

    public void cleanup() {
        if (Csmtp.s_oClient.getReplyCode() == 421) {
            Csmtp.s_oClient.close();
        }
    }
}

