/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.support;

import javax.sql.DataSource;
import org.springframework.jdbc.support.SQLErrorCodeSQLExceptionTranslator;
import org.springframework.jdbc.support.SQLExceptionTranslator;
import org.springframework.jdbc.support.SQLStateSQLExceptionTranslator;

public abstract class JdbcAccessor {
    private DataSource dataSource;
    private SQLExceptionTranslator exceptionTranslator;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setExceptionTranslator(SQLExceptionTranslator exceptionTranslator) {
        this.exceptionTranslator = exceptionTranslator;
    }

    public SQLExceptionTranslator getExceptionTranslator() {
        if (this.exceptionTranslator == null) {
            this.exceptionTranslator = this.getDataSource() != null ? new SQLErrorCodeSQLExceptionTranslator(this.getDataSource()) : new SQLStateSQLExceptionTranslator();
        }
        return this.exceptionTranslator;
    }

    public void afterPropertiesSet() {
        if (this.getDataSource() == null) {
            throw new IllegalArgumentException("dataSource is required");
        }
        this.getExceptionTranslator();
    }
}

