/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.tds;

import com.sybase.jdbc2.jdbc.Convert;
import com.sybase.jdbc2.jdbc.DateObject;
import com.sybase.jdbc2.jdbc.ErrorMessage;
import com.sybase.jdbc2.jdbc.JdbcDataObject;
import com.sybase.jdbc2.jdbc.TextPointer;
import com.sybase.jdbc2.tds.TdsDataOutputStream;
import com.sybase.jdbc2.tds.TdsParam;
import com.sybase.jdbc2.utils.CacheManager;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Calendar;

public class TdsUpdateParam
extends TdsParam
implements JdbcDataObject {
    public TdsUpdateParam(TdsDataOutputStream tdsDataOutputStream, CacheManager cacheManager) {
        super(tdsDataOutputStream);
    }

    private void checkStream(boolean bl) throws SQLException {
        if (this._inValue == null) {
            if (bl) {
                ErrorMessage.raiseError("JZ0TC");
            }
        } else if (this._inValue instanceof InputStream) {
            ErrorMessage.raiseError("JZ0IS");
        }
    }

    public InputStream getAsciiStream() throws SQLException {
        this.checkStream(false);
        return Convert.objectToStream(this._inValue);
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        this.checkStream(false);
        BigDecimal bigDecimal = Convert.objectToBigDecimal(this._inValue);
        return Convert.setScale(bigDecimal, n);
    }

    public InputStream getBinaryStream() throws SQLException {
        this.checkStream(false);
        return Convert.objectToStream(this._inValue);
    }

    public boolean getBoolean() throws SQLException {
        this.checkStream(true);
        return Convert.objectToBoolean(this._inValue);
    }

    public byte getByte() throws SQLException {
        this.checkStream(true);
        long l = Convert.objectToLongValue(this._inValue);
        Convert.checkByteOflo(l);
        return (byte)l;
    }

    public byte[] getBytes() throws SQLException {
        this.checkStream(false);
        return Convert.objectToBytes(this._inValue);
    }

    public Reader getCharacterStream() throws SQLException {
        this.checkStream(false);
        return Convert.objectToReader(this._inValue);
    }

    public DateObject getDateObject(int n, Calendar calendar) throws SQLException {
        this.checkStream(false);
        return Convert.objectToDateObject(this._inValue, calendar);
    }

    public double getDouble() throws SQLException {
        this.checkStream(true);
        return Convert.objectToDoubleValue(this._inValue);
    }

    public float getFloat() throws SQLException {
        this.checkStream(true);
        return (float)Convert.objectToDoubleValue(this._inValue);
    }

    public int getInt() throws SQLException {
        this.checkStream(true);
        long l = Convert.objectToLongValue(this._inValue);
        Convert.checkIntOflo(l);
        return (int)l;
    }

    public long getLong() throws SQLException {
        this.checkStream(true);
        return Convert.objectToLongValue(this._inValue);
    }

    public Object getObject() throws SQLException {
        this.checkStream(false);
        return this._inValue;
    }

    public short getShort() throws SQLException {
        this.checkStream(true);
        long l = Convert.objectToLongValue(this._inValue);
        Convert.checkShortOflo(l);
        return (short)l;
    }

    public String getString() throws SQLException {
        this.checkStream(false);
        return Convert.objectToString(this._inValue);
    }

    public TextPointer getTextPtr() throws SQLException {
        ErrorMessage.raiseError("JZ0R4");
        return null;
    }

    public InputStream getUnicodeStream() throws SQLException {
        this.checkStream(false);
        return Convert.objectToStream(this._inValue);
    }

    public boolean isNull() throws SQLException {
        if (this._sqlType == -999 || this._sqlType == -998) {
            ErrorMessage.raiseError("JZ0TC");
        }
        return this._sqlType == 0;
    }
}

