/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.tds;

import com.sybase.jdbc2.tds.DoneToken;
import com.sybase.jdbc2.tds.TdsProtocolContext;
import com.sybase.jdbc2.utils.BufferInterval;
import java.io.IOException;
import java.io.InputStream;

public class PduInputFormatter
extends InputStream {
    private static final int LOW_BYTE = 255;
    private int _nextIn = 0;
    private int _packetEnd = 0;
    private int _status = 1;
    private int _type;
    private BufferInterval _pdu;
    private byte[] _buf = null;
    private TdsProtocolContext _tpc;

    public PduInputFormatter(TdsProtocolContext tdsProtocolContext) {
        this._tpc = tdsProtocolContext;
    }

    public int available() throws IOException {
        int n = this._tpc.available();
        return n += this._packetEnd - this._nextIn;
    }

    public void close() {
        while ((this._status & 1) == 0) {
            try {
                this.readPacket();
            }
            catch (IOException iOException) {
                break;
            }
        }
        this._nextIn = 0;
        this._packetEnd = 0;
        if (this._pdu != null) {
            this._pdu.free();
            this._pdu = null;
        }
    }

    public int read() throws IOException {
        while (this._nextIn >= this._packetEnd) {
            if (this.readPacket()) continue;
            return -1;
        }
        int n = this._buf[this._nextIn++] & 0xFF;
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = n2;
        while (n3 > 0) {
            int n4 = this._packetEnd - this._nextIn;
            while (n4 <= 0) {
                if (!this.readPacket()) {
                    if (n3 == n2) {
                        return -1;
                    }
                    return n2 - n3;
                }
                n4 = this._packetEnd - this._nextIn;
            }
            int n5 = n4 > n3 ? n3 : n4;
            System.arraycopy(this._buf, this._nextIn, byArray, n, n5);
            n3 -= n5;
            n += n5;
            this._nextIn += n5;
        }
        return n2;
    }

    private boolean readPacket() throws IOException {
        if (this._pdu != null) {
            this._pdu.free();
            this._pdu = null;
        }
        this._pdu = this._tpc.getChunk();
        if (this._pdu == null) {
            this._nextIn = 0;
            this._packetEnd = 0;
            return false;
        }
        this._buf = this._pdu._buf;
        this._nextIn = this._pdu._offset;
        this._type = this._buf[this._nextIn++] & 0xFF;
        this._status = this._buf[this._nextIn++] & 0xFF;
        int n = ((this._buf[this._nextIn++] & 0xFF) << 8) + (0xFF & this._buf[this._nextIn++]);
        this._nextIn += 4;
        this._packetEnd = this._nextIn + n - 8;
        if ((this._status & 2) != 0) {
            this._pdu.free();
            this._pdu = null;
            this._nextIn = 0;
            this._packetEnd = 0;
            this._tpc._tdsToken = new DoneToken(32, 0, 0);
            return false;
        }
        return true;
    }

    public long skip(long l) throws IOException {
        int n = this._packetEnd - this._nextIn;
        int n2 = (int)l;
        while (n < n2) {
            n2 -= n;
            this._nextIn += n;
            if (!this.readPacket()) {
                return l;
            }
            n = this._packetEnd - this._nextIn;
        }
        this._nextIn += n2;
        return l;
    }
}

