/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.jdbc;

import com.sybase.jdbc2.jdbc.ErrorMessage;
import com.sybase.jdbc2.jdbc.Protocol;
import com.sybase.jdbc2.jdbc.ProtocolManager;
import com.sybase.jdbc2.jdbc.SybProperty;
import com.sybase.jdbc2.jdbc.SybUrlProvider;
import com.sybase.jdbc2.jdbc.SybUrlProviderImplBase;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.sql.SQLException;
import java.util.Properties;
import java.util.Vector;

public class SybUrlManager
extends SybUrlProviderImplBase {
    public static final String KEYWORD_JDBC = "jdbc";
    public static final String KEYWORD_SYBASE = "sybase";
    public static final String KEYWORD_JNDI = "jndi";
    public static final String PACKAGE_PREFIX = "com.sybase.jdbc2.";
    private static final String JNDI_PROVIDER = "jdbc.SybJndiProvider";
    private Properties _userProps = null;
    private String _url = null;
    private String _providerName = null;
    private String _urlRest = null;

    public SybUrlManager(String string, Properties properties, SybProperty sybProperty) throws SQLException {
        this._url = string;
        this._sybProps = sybProperty;
        this._userProps = properties;
        this._hostportList = new Vector();
        this.validateUrl();
    }

    public SybUrlProvider getUrlProvider() throws SQLException {
        String string = PACKAGE_PREFIX;
        SybUrlProvider sybUrlProvider = null;
        if (this._providerName == null) {
            return null;
        }
        if (this._providerName.equals(KEYWORD_JNDI)) {
            string = String.valueOf(string) + JNDI_PROVIDER;
            try {
                sybUrlProvider = (SybUrlProvider)Class.forName(string).newInstance();
            }
            catch (Exception exception) {
                ErrorMessage.raiseError("JZ0D7", string, exception.toString());
            }
        } else {
            sybUrlProvider = this;
        }
        if (this._userProps == null && this._sybProps == null) {
            if (!this._providerName.equals(KEYWORD_JNDI)) {
                sybUrlProvider.init(this._providerName, this._urlRest, this._userProps, this._sybProps);
            }
        } else {
            sybUrlProvider.init(this._providerName, this._urlRest, this._userProps, this._sybProps);
        }
        return sybUrlProvider;
    }

    public void init(String string, String string2, Properties properties, SybProperty sybProperty) throws SQLException {
        String string3 = null;
        String string4 = null;
        if (string.equals("shm")) {
            if (sybProperty != null) {
                sybProperty.setProperty(31, "com.sybase.shmem.ShmemSocketFactory");
            }
            string = "Tds";
        }
        this._protocol = SybUrlManager.loadProtocol(string);
        if (string2 != null) {
            int n = string2.indexOf(47);
            int n2 = string2.indexOf(63);
            if (n > -1 && n < n2) {
                string4 = string2.substring(0, n);
                this._dbName = string2.substring(n + 1, n2);
                string3 = string2.substring(n2 + 1);
            } else if (n2 > -1 && (n > n2 || n == -1)) {
                string4 = string2.substring(0, n2);
                string3 = string2.substring(n2 + 1);
            } else if (n > -1 && n2 == -1) {
                string4 = string2.substring(0, n);
                this._dbName = string2.substring(n + 1);
            } else {
                string4 = string2;
            }
        }
        if (string3 != null && sybProperty != null) {
            this._sybProps.parsePropertyString(string3);
        }
        this._hostportList.addElement(string4);
    }

    public static Protocol loadProtocol(String string) throws SQLException {
        String string2 = PACKAGE_PREFIX + string.toLowerCase() + "." + string;
        return ProtocolManager.getProtocol(string2);
    }

    private void validateUrl() throws SQLException {
        StreamTokenizer streamTokenizer = new StreamTokenizer(new StringReader(this._url));
        streamTokenizer.wordChars(0, 255);
        streamTokenizer.whitespaceChars(58, 58);
        try {
            if (streamTokenizer.nextToken() != -3) {
                return;
            }
            if (streamTokenizer.sval.compareTo(KEYWORD_JDBC) != 0) {
                return;
            }
            if (streamTokenizer.nextToken() != -3) {
                return;
            }
            if (streamTokenizer.sval.compareTo(KEYWORD_SYBASE) != 0) {
                return;
            }
            if (streamTokenizer.nextToken() != -3) {
                ErrorMessage.raiseError("JZ0D4", this._url);
            }
            this._providerName = streamTokenizer.sval;
            try {
                streamTokenizer.whitespaceChars(0, 0);
                streamTokenizer.resetSyntax();
                streamTokenizer.wordChars(0, 255);
                if (streamTokenizer.nextToken() == -3) {
                    this._urlRest = streamTokenizer.sval.substring(1);
                }
            }
            catch (IOException iOException) {
                this._urlRest = null;
            }
        }
        catch (IOException iOException) {
            SQLException sQLException = new SQLException(iOException.toString());
            throw sQLException;
        }
    }
}

