/*
 * Decompiled with CFR 0.152.
 */
package org.htmlcleaner;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.htmlcleaner.CleanerProperties;
import org.htmlcleaner.DoctypeToken;
import org.htmlcleaner.HtmlCleaner;
import org.htmlcleaner.HtmlCleanerException;
import org.htmlcleaner.TagNode;

public abstract class Serializer {
    protected CleanerProperties props;

    protected Serializer(CleanerProperties props) {
        this.props = props;
    }

    public void writeToStream(TagNode tagNode, OutputStream out, String charset, boolean omitEnvelope) throws IOException {
        this.write(tagNode, new OutputStreamWriter(out, charset), charset, omitEnvelope);
    }

    public void writeToStream(TagNode tagNode, OutputStream out, String charset) throws IOException {
        this.writeToStream(tagNode, out, charset, false);
    }

    public void writeToStream(TagNode tagNode, OutputStream out, boolean omitEnvelope) throws IOException {
        this.writeToStream(tagNode, out, this.props.getCharset(), omitEnvelope);
    }

    public void writeToStream(TagNode tagNode, OutputStream out) throws IOException {
        this.writeToStream(tagNode, out, false);
    }

    public void writeToFile(TagNode tagNode, String fileName, String charset, boolean omitEnvelope) throws IOException {
        this.writeToStream(tagNode, new FileOutputStream(fileName), charset, omitEnvelope);
    }

    public void writeToFile(TagNode tagNode, String fileName, String charset) throws IOException {
        this.writeToFile(tagNode, fileName, charset, false);
    }

    public void writeToFile(TagNode tagNode, String fileName, boolean omitEnvelope) throws IOException {
        this.writeToFile(tagNode, fileName, this.props.getCharset(), omitEnvelope);
    }

    public void writeToFile(TagNode tagNode, String fileName) throws IOException {
        this.writeToFile(tagNode, fileName, false);
    }

    public String getAsString(TagNode tagNode, String charset, boolean omitEnvelope) {
        StringWriter writer = new StringWriter();
        try {
            this.write(tagNode, writer, charset, omitEnvelope);
        }
        catch (IOException e) {
            throw new HtmlCleanerException(e);
        }
        return writer.getBuffer().toString();
    }

    public String getAsString(TagNode tagNode, String charset) {
        return this.getAsString(tagNode, charset, false);
    }

    public String getAsString(TagNode tagNode, boolean omitEnvelope) {
        return this.getAsString(tagNode, this.props.getCharset(), omitEnvelope);
    }

    public String getAsString(TagNode tagNode) {
        return this.getAsString(tagNode, false);
    }

    public String getAsString(String htmlContent) {
        HtmlCleaner htmlCleaner = new HtmlCleaner(this.props);
        TagNode tagNode = htmlCleaner.clean(htmlContent);
        return this.getAsString(tagNode, this.props.getCharset());
    }

    public void write(TagNode tagNode, Writer writer, String charset) throws IOException {
        this.write(tagNode, writer, charset, false);
    }

    public void write(TagNode tagNode, Writer writer, String charset, boolean omitEnvelope) throws IOException {
        DoctypeToken doctypeToken;
        if (omitEnvelope) {
            tagNode = new HeadlessTagNode(tagNode);
        }
        writer = new BufferedWriter(writer);
        if (!this.props.isOmitXmlDeclaration()) {
            String declaration = "<?xml version=\"1.0\"";
            if (charset != null) {
                declaration = declaration + " encoding=\"" + charset + "\"";
            }
            declaration = declaration + "?>";
            writer.write(declaration + "\n");
        }
        if (!this.props.isOmitDoctypeDeclaration() && (doctypeToken = tagNode.getDocType()) != null) {
            doctypeToken.serialize(this, writer);
        }
        this.serialize(tagNode, writer);
        writer.flush();
        writer.close();
    }

    protected boolean isScriptOrStyle(TagNode tagNode) {
        String tagName = tagNode.getName();
        return "script".equalsIgnoreCase(tagName) || "style".equalsIgnoreCase(tagName);
    }

    protected abstract void serialize(TagNode var1, Writer var2) throws IOException;

    private class HeadlessTagNode
    extends TagNode {
        private HeadlessTagNode(TagNode wrappedNode) {
            Map<String, String> wrappedNSDecls;
            super("");
            this.getAttributes().putAll(wrappedNode.getAttributes());
            this.addChildren(wrappedNode.getAllChildren());
            this.setDocType(wrappedNode.getDocType());
            Map<String, String> nsDecls = this.getNamespaceDeclarations();
            if (nsDecls != null && (wrappedNSDecls = wrappedNode.getNamespaceDeclarations()) != null) {
                nsDecls.putAll(wrappedNSDecls);
            }
        }
    }
}

