/*
 * Decompiled with CFR 0.152.
 */
package org.htmlcleaner;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.htmlcleaner.CleanerProperties;
import org.htmlcleaner.Serializer;
import org.htmlcleaner.SpecialEntities;
import org.htmlcleaner.SpecialEntity;
import org.htmlcleaner.TagInfo;
import org.htmlcleaner.TagNode;
import org.htmlcleaner.Utils;

public abstract class HtmlSerializer
extends Serializer {
    private static final Map<Character, String> RESERVED_XML_CHARS = new HashMap<Character, String>();

    @Deprecated
    private boolean isReservedXmlChar(char ch) {
        return RESERVED_XML_CHARS.containsKey(Character.valueOf(ch));
    }

    protected HtmlSerializer(CleanerProperties props) {
        super(props);
    }

    protected boolean isMinimizedTagSyntax(TagNode tagNode) {
        TagInfo tagInfo = this.props.getTagInfoProvider().getTagInfo(tagNode.getName());
        return tagInfo != null && !tagNode.hasChildren() && tagInfo.isEmptyTag();
    }

    protected boolean dontEscape(TagNode tagNode) {
        return this.isScriptOrStyle(tagNode);
    }

    protected String escapeText(String s) {
        boolean recognizeUnicodeChars = this.props.isRecognizeUnicodeChars();
        boolean translateSpecialEntities = this.props.isTranslateSpecialEntities();
        if (s != null) {
            int len = s.length();
            StringBuilder result = new StringBuilder(len);
            for (int i = 0; i < len; ++i) {
                char ch = s.charAt(i);
                if (ch == '&') {
                    String entityKey;
                    SpecialEntity entity;
                    if (i < len - 2 && s.charAt(i + 1) == '#') {
                        char currCh;
                        int charIndex;
                        boolean isHex = Character.toLowerCase(s.charAt(i + 2)) == 'x';
                        int radix = isHex ? 16 : 10;
                        String unicode = "";
                        for (charIndex = i + (isHex ? 3 : 2); charIndex < len && (currCh = s.charAt(charIndex)) != ';'; ++charIndex) {
                            if (Utils.isValidInt(unicode + currCh, radix)) {
                                unicode = unicode + currCh;
                                continue;
                            }
                            --charIndex;
                            break;
                        }
                        if (Utils.isValidInt(unicode, radix)) {
                            char unicodeChar = (char)Integer.parseInt(unicode, radix);
                            if (!Utils.isValidXmlChar(unicodeChar)) {
                                i = charIndex;
                                continue;
                            }
                            if (!this.isReservedXmlChar(unicodeChar)) {
                                result.append(recognizeUnicodeChars ? String.valueOf(unicodeChar) : "&#" + unicode + ";");
                                i = charIndex;
                                continue;
                            }
                            i = charIndex;
                            result.append("&#" + unicode + ";");
                            continue;
                        }
                        result.append(this.props.isTransResCharsToNCR() ? "&#38;" : "&");
                        continue;
                    }
                    String seq = s.substring(i, i + Math.min(SpecialEntities.INSTANCE.getMaxEntityLength() + 2, len - i));
                    int semiIndex = seq.indexOf(59);
                    if (semiIndex > 0 && (entity = SpecialEntities.INSTANCE.getSpecialEntity(entityKey = seq.substring(1, semiIndex))) != null) {
                        if (translateSpecialEntities) {
                            result.append(recognizeUnicodeChars ? Character.valueOf(entity.charValue()) : entity.getDecimalNCR());
                        } else {
                            result.append(entity.getEscapedValue());
                        }
                        i += entityKey.length() + 1;
                        continue;
                    }
                    String sub = s.substring(i);
                    boolean isReservedSeq = false;
                    for (Map.Entry<Character, String> entry : RESERVED_XML_CHARS.entrySet()) {
                        seq = entry.getValue();
                        if (!sub.startsWith(seq)) continue;
                        result.append(this.props.isTransResCharsToNCR() ? "&#" + entry.getKey().charValue() + ";" : seq);
                        i += seq.length() - 1;
                        isReservedSeq = true;
                        break;
                    }
                    if (isReservedSeq) continue;
                    result.append(this.props.isTransResCharsToNCR() ? "&#38;" : "&");
                    continue;
                }
                if (this.isReservedXmlChar(ch)) {
                    result.append(this.props.isTransResCharsToNCR() ? "&#" + ch + ";" : Character.valueOf(ch));
                    continue;
                }
                result.append(ch);
            }
            return result.toString();
        }
        return null;
    }

    protected void serializeOpenTag(TagNode tagNode, Writer writer, boolean newLine) throws IOException {
        Map<String, String> nsDeclarations;
        String tagName = tagNode.getName();
        if (Utils.isEmptyString(tagName)) {
            return;
        }
        boolean nsAware = this.props.isNamespacesAware();
        if (!nsAware && Utils.getXmlNSPrefix(tagName) != null) {
            tagName = Utils.getXmlName(tagName);
        }
        writer.write("<" + tagName);
        for (Map.Entry<String, String> entry : tagNode.getAttributes().entrySet()) {
            String attName = entry.getKey();
            if (!nsAware && Utils.getXmlNSPrefix(attName) != null) {
                attName = Utils.getXmlName(attName);
            }
            writer.write(" " + attName + "=\"" + this.escapeText(entry.getValue()) + "\"");
        }
        if (nsAware && (nsDeclarations = tagNode.getNamespaceDeclarations()) != null) {
            for (Map.Entry<String, String> entry : nsDeclarations.entrySet()) {
                String prefix = entry.getKey();
                String att = "xmlns";
                if (prefix.length() > 0) {
                    att = att + ":" + prefix;
                }
                writer.write(" " + att + "=\"" + this.escapeText(entry.getValue()) + "\"");
            }
        }
        if (this.isMinimizedTagSyntax(tagNode)) {
            writer.write(" />");
            if (newLine) {
                writer.write("\n");
            }
        } else {
            writer.write(">");
        }
    }

    protected void serializeEndTag(TagNode tagNode, Writer writer, boolean newLine) throws IOException {
        String tagName = tagNode.getName();
        if (Utils.isEmptyString(tagName)) {
            return;
        }
        if (Utils.getXmlNSPrefix(tagName) != null && !this.props.isNamespacesAware()) {
            tagName = Utils.getXmlName(tagName);
        }
        writer.write("</" + tagName + ">");
        if (newLine) {
            writer.write("\n");
        }
    }

    static {
        RESERVED_XML_CHARS.put(Character.valueOf('&'), "&amp;");
        RESERVED_XML_CHARS.put(Character.valueOf('<'), "&lt;");
        RESERVED_XML_CHARS.put(Character.valueOf('>'), "&gt;");
        RESERVED_XML_CHARS.put(Character.valueOf('\"'), "&quot;");
        RESERVED_XML_CHARS.put(Character.valueOf('\''), "&apos;");
    }
}

