/*
 * Decompiled with CFR 0.152.
 */
package org.htmlcleaner;

import java.io.IOException;
import java.io.Writer;
import org.htmlcleaner.BaseTokenImpl;
import org.htmlcleaner.Serializer;

public class DoctypeToken
extends BaseTokenImpl {
    private String part1;
    private String part2;
    private String part3;
    private String part4;
    private Integer type = null;
    public static final int UNKNOWN = 0;
    public static final int HTML4_0 = 10;
    public static final int HTML4_01 = 20;
    public static final int HTML4_01_STRICT = 21;
    public static final int HTML4_01_TRANSITIONAL = 22;
    public static final int HTML4_01_FRAMESET = 23;
    public static final int XHTML1_0_STRICT = 31;
    public static final int XHTML1_0_TRANSITIONAL = 32;
    public static final int XHTML1_0_FRAMESET = 33;
    public static final int XHTML1_1 = 40;
    public static final int XHTML1_1_BASIC = 41;
    public static final int HTML5 = 60;
    public static final int HTML5_LEGACY_TOOL_COMPATIBLE = 61;
    private Boolean valid = null;

    public DoctypeToken(String part1, String part2, String part3, String part4) {
        this.part1 = part1;
        this.part2 = part2 != null ? part2.toUpperCase() : part2;
        this.part3 = this.clean(part3);
        this.part4 = this.clean(part4);
        this.validate();
    }

    public DoctypeToken(String part1, String part2, String part3, String part4, String part5) {
        this.part1 = part1;
        this.part2 = part2 != null ? part2.toUpperCase() : part2;
        this.part3 = this.clean(part3);
        this.part4 = this.clean(part5);
        this.validate();
    }

    private String clean(String s) {
        if (s != null) {
            s = s.replace('>', ' ');
            s = s.replace('<', ' ');
            s = s.replace('&', ' ');
            s = s.replace('\'', ' ');
            s = s.replace('\"', ' ');
        }
        return s;
    }

    public boolean isValid() {
        return this.valid;
    }

    private void validate() {
        if (!"public".equalsIgnoreCase(this.part2) && !"system".equalsIgnoreCase(this.part2) && "html".equalsIgnoreCase(this.part1) && this.part2 == null) {
            this.type = 60;
            this.valid = true;
        }
        if ("public".equalsIgnoreCase(this.part2)) {
            if ("-//W3C//DTD HTML 4.0//EN".equals(this.getPublicId())) {
                this.type = 10;
                this.valid = "http://www.w3.org/TR/REC-html40/strict.dtd".equals(this.part4) || "".equals(this.getSystemId()) ? Boolean.valueOf(true) : Boolean.valueOf(false);
            }
            if ("-//W3C//DTD HTML 4.01//EN".equals(this.getPublicId())) {
                this.type = 21;
                this.valid = "http://www.w3.org/TR/html4/strict.dtd".equals(this.part4) || "".equals(this.getSystemId()) ? Boolean.valueOf(true) : Boolean.valueOf(false);
            }
            if ("-//W3C//DTD HTML 4.01 Transitional//EN".equals(this.getPublicId())) {
                this.type = 22;
                this.valid = "http://www.w3.org/TR/html4/loose.dtd".equals(this.getSystemId()) ? Boolean.valueOf(true) : Boolean.valueOf(false);
            }
            if ("-//W3C//DTD HTML 4.01 Frameset//EN".equals(this.getPublicId())) {
                this.type = 23;
                this.valid = "http://www.w3.org/TR/html4/frameset.dtd".equals(this.getSystemId()) ? Boolean.valueOf(true) : Boolean.valueOf(false);
            }
            if ("-//W3C//DTD XHTML 1.0 Strict//EN".equals(this.getPublicId())) {
                this.type = 31;
                this.valid = "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd".equals(this.getSystemId()) ? Boolean.valueOf(true) : Boolean.valueOf(false);
            }
            if ("-//W3C//DTD XHTML 1.0 Transitional//EN".equals(this.getPublicId())) {
                this.type = 32;
                this.valid = "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd".equals(this.getSystemId()) ? Boolean.valueOf(true) : Boolean.valueOf(false);
            }
            if ("-//W3C//DTD XHTML 1.0 Frameset//EN".equals(this.getPublicId())) {
                this.type = 33;
                this.valid = "http://www.w3.org/TR/xhtml1/DTD/xhtml1-frameset.dtd".equals(this.getSystemId()) ? Boolean.valueOf(true) : Boolean.valueOf(false);
            }
            if ("-//W3C//DTD XHTML 1.1//EN".equals(this.getPublicId())) {
                this.type = 40;
                this.valid = "http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd".equals(this.getSystemId()) ? Boolean.valueOf(true) : Boolean.valueOf(false);
            }
            if ("-//W3C//DTD XHTML Basic 1.1//EN".equals(this.getPublicId())) {
                this.type = 41;
                this.valid = "http://www.w3.org/TR/xhtml11/DTD/xhtml-basic11.dtd".equals(this.getSystemId()) ? Boolean.valueOf(true) : Boolean.valueOf(false);
            }
        }
        if ("system".equalsIgnoreCase(this.part2) && "about:legacy-compat".equals(this.getPublicId())) {
            this.type = 61;
            this.valid = true;
        }
        if (this.type == null) {
            this.type = 0;
            this.valid = false;
        }
    }

    public String getContent() {
        String result = "<!DOCTYPE ";
        result = this.type != 0 ? (this.type >= 30 ? result + "html" : result + "HTML") : result + this.part1;
        if (this.part2 != null) {
            result = result + " " + this.part2 + " \"" + this.part3 + "\"";
            if (!"".equals(this.part4)) {
                result = result + " \"" + this.part4 + "\"";
            }
        }
        result = result + ">";
        return result;
    }

    public String toString() {
        return this.getContent();
    }

    public int getType() {
        return this.type;
    }

    public String getName() {
        return "";
    }

    public void serialize(Serializer serializer, Writer writer) throws IOException {
        writer.write(this.getContent() + "\n");
    }

    public String getPublicId() {
        return this.part3;
    }

    public String getSystemId() {
        return this.part4;
    }

    public String getPart1() {
        return this.part1;
    }

    public String getPart2() {
        return this.part2;
    }

    @Deprecated
    public String getPart3() {
        return this.part3;
    }

    @Deprecated
    public String getPart4() {
        return this.part4;
    }
}

