/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset;

import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableIterator;
import org.dbunit.dataset.ITableMetaData;

public class DefaultTableIterator
implements ITableIterator {
    private final ITable[] _tables;
    private int _index = -1;

    public DefaultTableIterator(ITable[] tables) {
        this._tables = tables;
    }

    public DefaultTableIterator(ITable[] tables, boolean reversed) {
        if (reversed) {
            ITable[] reverseTables = new ITable[tables.length];
            for (int i = 0; i < tables.length; ++i) {
                reverseTables[tables.length - 1 - i] = tables[i];
            }
            tables = reverseTables;
        }
        this._tables = tables;
    }

    public boolean next() throws DataSetException {
        ++this._index;
        return this._index < this._tables.length;
    }

    public ITableMetaData getTableMetaData() throws DataSetException {
        return this.getTable().getTableMetaData();
    }

    public ITable getTable() throws DataSetException {
        return this._tables[this._index];
    }
}

