/*
 * Decompiled with CFR 0.152.
 */
package org.xmlmiddleware.xmldbms;

import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xmlmiddleware.conversions.ConvertObject;
import org.xmlmiddleware.conversions.SQLLiterals;
import org.xmlmiddleware.conversions.formatters.StringFormatter;
import org.xmlmiddleware.utils.XMLMiddlewareException;
import org.xmlmiddleware.xmldbms.Row;
import org.xmlmiddleware.xmldbms.TransferInfo;
import org.xmlmiddleware.xmldbms.actions.Action;
import org.xmlmiddleware.xmldbms.actions.Actions;
import org.xmlmiddleware.xmldbms.datahandlers.DataHandler;
import org.xmlmiddleware.xmldbms.filters.FilterConditions;
import org.xmlmiddleware.xmldbms.filters.FilterSet;
import org.xmlmiddleware.xmldbms.filters.RootFilter;
import org.xmlmiddleware.xmldbms.keygenerators.KeyGenerator;
import org.xmlmiddleware.xmldbms.maps.ClassMap;
import org.xmlmiddleware.xmldbms.maps.ClassMapBase;
import org.xmlmiddleware.xmldbms.maps.Column;
import org.xmlmiddleware.xmldbms.maps.InlineClassMap;
import org.xmlmiddleware.xmldbms.maps.Key;
import org.xmlmiddleware.xmldbms.maps.LinkInfo;
import org.xmlmiddleware.xmldbms.maps.OrderInfo;
import org.xmlmiddleware.xmldbms.maps.PropertyMap;
import org.xmlmiddleware.xmldbms.maps.RelatedClassMap;
import org.xmlmiddleware.xmldbms.maps.Table;
import org.xmlmiddleware.xmlutils.DOMNormalizer;

public class DOMToDBMS {
    private TransferInfo m_transInfo;
    private int m_commitMode = 1;
    private boolean m_returnFilterSet = false;
    private boolean m_stopOnException = true;
    private SQLWarning m_sqlWarnings;
    private SQLException m_sqlExceptions;
    private Actions m_actions;
    private Hashtable m_keyGenerators = new Hashtable();
    private Hashtable m_classAllProperties = new Hashtable();
    private static final String DUMMY = "dummy";
    private static final String AND = "AND ";

    public void setCommitMode(int n) {
        if (n != 1 && n != 2 && n != 3 && n != 4) {
            throw new IllegalArgumentException("Invalid commit mode: " + n);
        }
        this.m_commitMode = n;
    }

    public int getCommitMode() {
        return this.m_commitMode;
    }

    public void setFilterSetReturned(boolean bl) {
        this.m_returnFilterSet = bl;
    }

    public boolean isFilterSetReturned() {
        return this.m_returnFilterSet;
    }

    public void addKeyGenerator(String string, KeyGenerator keyGenerator) {
        this.m_keyGenerators.put(string, keyGenerator);
    }

    public void removeKeyGenerator(String string) {
        this.m_keyGenerators.remove(string);
    }

    public void removeAllKeyGenerators() {
        this.m_keyGenerators.clear();
    }

    public void stopOnException(boolean bl) {
        this.m_stopOnException = bl;
    }

    public SQLWarning getWarnings() {
        return this.m_sqlWarnings;
    }

    public SQLException getExceptions() {
        return this.m_sqlExceptions;
    }

    public FilterSet storeDocument(TransferInfo transferInfo, Document document, int n) throws SQLException, XMLMiddlewareException {
        return this.storeDocument(transferInfo, document.getDocumentElement(), n);
    }

    public FilterSet storeDocument(TransferInfo transferInfo, Document document, Actions actions) throws SQLException, XMLMiddlewareException {
        return this.storeDocument(transferInfo, document.getDocumentElement(), actions);
    }

    public FilterSet storeDocument(TransferInfo transferInfo, Element element, int n) throws SQLException, XMLMiddlewareException {
        Action action = new Action();
        action.setAction(n);
        Actions actions = new Actions(transferInfo.getMap());
        actions.setDefaultAction(action);
        return this.storeDocument(transferInfo, element, actions);
    }

    public FilterSet storeDocument(TransferInfo transferInfo, Element element, Actions actions) throws SQLException, XMLMiddlewareException {
        FilterSet filterSet = this.m_returnFilterSet ? new FilterSet(transferInfo.getMap()) : null;
        this.m_transInfo = transferInfo;
        this.m_sqlExceptions = null;
        this.m_sqlWarnings = null;
        this.m_actions = actions;
        Enumeration enumeration = transferInfo.getDataHandlers();
        while (enumeration.hasMoreElements()) {
            ((DataHandler)enumeration.nextElement()).startDocument(this.m_commitMode);
        }
        this.processRoot(filterSet, element, 1L);
        enumeration = transferInfo.getDataHandlers();
        while (enumeration.hasMoreElements()) {
            ((DataHandler)enumeration.nextElement()).endDocument();
        }
        this.m_transInfo = null;
        return filterSet;
    }

    private void processRoot(FilterSet filterSet, Element element, long l) throws SQLException, XMLMiddlewareException {
        ClassMap classMap = this.m_transInfo.getMap().getClassMap(element.getNamespaceURI(), element.getLocalName());
        if (classMap != null) {
            Row row = this.processClassRow(null, classMap, null, element, l);
            if (this.m_returnFilterSet && row != null) {
                Table table = classMap.getTable();
                Key key = table.getPrimaryKey();
                RootFilter rootFilter = filterSet.createRootFilter();
                FilterConditions filterConditions = rootFilter.createRootFilterConditions(table);
                String string = this.buildCondition(key.getColumns(), row.getColumnValues(key.getColumns()));
                filterConditions.addCondition(string);
                return;
            }
        } else {
            NodeList nodeList = element.getChildNodes();
            long l2 = 1L;
            int n = 0;
            while (n < nodeList.getLength()) {
                if (nodeList.item(n).getNodeType() == 1) {
                    this.processRoot(filterSet, (Element)nodeList.item(n), l2);
                    ++l2;
                }
                ++n;
            }
        }
    }

    private Row processClassRow(Row row, ClassMap classMap, RelatedClassMap relatedClassMap, Element element, long l) throws SQLException, XMLMiddlewareException {
        Vector vector = new Vector();
        Action action = this.getActionFor(element);
        Vector vector2 = this.getUseProps(classMap, action);
        Table table = classMap.getTable();
        LinkInfo linkInfo = relatedClassMap == null ? null : relatedClassMap.getLinkInfo();
        Row row2 = this.createRow(table, row, linkInfo);
        try {
            if (relatedClassMap != null) {
                this.generateOrder(row2, relatedClassMap.getOrderInfo(), l);
            }
            this.processChildren(row2, classMap, element, vector, action, vector2);
            this.setMissingFieldsToNull(row2, vector2);
            this.storeRow(table, row2, action.getAction());
            this.deletePropTableRows(row2, vector2, action);
            this.processFKNodes(row2, vector, action);
        }
        catch (SQLException sQLException) {
            if (this.m_stopOnException) {
                throw sQLException;
            }
            this.pushException(sQLException);
        }
        return row2;
    }

    private void processChildren(Row row, ClassMapBase classMapBase, Node node, Vector vector, Action action, Vector vector2) throws SQLException, XMLMiddlewareException {
        Object object;
        long l = 1L;
        Node node2 = DOMNormalizer.getFirstChild(node);
        while (node2 != null) {
            object = null;
            switch (node2.getNodeType()) {
                case 3: {
                    object = classMapBase.getPCDATAMap();
                    break;
                }
                case 1: {
                    object = classMapBase.getChildMap(node2.getNamespaceURI(), node2.getLocalName());
                    break;
                }
            }
            this.processChild(row, object, node2, l, vector, action, vector2);
            ++l;
            node2 = DOMNormalizer.getNextSibling(node2);
        }
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap != null) {
            int n = 0;
            while (n < namedNodeMap.getLength()) {
                node2 = namedNodeMap.item(n);
                object = classMapBase.getAttributeMap(node2.getNamespaceURI(), node2.getLocalName());
                this.processChild(row, object, node2, 0L, vector, action, vector2);
                ++n;
            }
        }
    }

    private void processChild(Row row, Object object, Node node, long l, Vector vector, Action action, Vector vector2) throws SQLException, XMLMiddlewareException {
        if (object == null) {
            return;
        }
        if (object instanceof PropertyMap) {
            if (vector2.contains(object)) {
                this.processProperty(row, (PropertyMap)object, node, l, vector, action);
                return;
            }
        } else {
            if (object instanceof RelatedClassMap) {
                this.processRowChild(row, object, ((RelatedClassMap)object).getLinkInfo(), node, l, vector, action);
                return;
            }
            if (object instanceof InlineClassMap) {
                this.generateOrder(row, ((InlineClassMap)object).getOrderInfo(), l);
                this.processChildren(row, (InlineClassMap)object, node, vector, action, vector2);
            }
        }
    }

    private void processProperty(Row row, PropertyMap propertyMap, Node node, long l, Vector vector, Action action) throws SQLException, XMLMiddlewareException {
        this.generateOrder(row, propertyMap.getOrderInfo(), l);
        if (propertyMap.isTokenList()) {
            StringTokenizer stringTokenizer = new StringTokenizer(this.getNodeValue(node, propertyMap.containsXML()), " \n\r\t", false);
            long l2 = 1L;
            Document document = node.getOwnerDocument();
            PropertyMap propertyMap2 = PropertyMap.create(DUMMY, DUMMY, propertyMap.getType());
            propertyMap2.setTable(propertyMap.getTable(), propertyMap.getLinkInfo());
            propertyMap2.setColumn(propertyMap.getColumn());
            propertyMap2.setIsTokenList(false);
            propertyMap2.setOrderInfo(propertyMap.getTokenListOrderInfo());
            while (stringTokenizer.hasMoreElements()) {
                Node node2 = null;
                switch (node.getNodeType()) {
                    case 1: {
                        node2 = document.createElement(DUMMY);
                        node2.appendChild(document.createTextNode(stringTokenizer.nextToken()));
                        break;
                    }
                    case 3: {
                        node2 = document.createTextNode(stringTokenizer.nextToken());
                        break;
                    }
                    case 2: {
                        node2 = document.createAttribute(DUMMY);
                        node2.setNodeValue(stringTokenizer.nextToken());
                        break;
                    }
                }
                if (node2 == null) continue;
                this.processProperty(row, propertyMap2, node2, l2, vector, action);
                ++l2;
            }
            return;
        }
        if (propertyMap.getTable() == null) {
            this.setPropertyColumn(row, propertyMap, node);
            return;
        }
        this.processRowChild(row, propertyMap, propertyMap.getLinkInfo(), node, l, vector, action);
    }

    private void processRowChild(Row row, Object object, LinkInfo linkInfo, Node node, long l, Vector vector, Action action) throws SQLException, XMLMiddlewareException {
        if (linkInfo.parentKeyIsUnique()) {
            vector.addElement(new FKNode(node, object, l));
            return;
        }
        Row row2 = this.processRow(row, object, node, l, action);
        if (row2 != null) {
            this.setParentKey(row, row2, linkInfo);
        }
    }

    private Row processRow(Row row, Object object, Node node, long l, Action action) throws SQLException, XMLMiddlewareException {
        if (object instanceof PropertyMap) {
            return this.processPropRow(row, (PropertyMap)object, node, l, action);
        }
        RelatedClassMap relatedClassMap = (RelatedClassMap)object;
        return this.processClassRow(row, relatedClassMap.getClassMap(), relatedClassMap, (Element)node, l);
    }

    private Row processPropRow(Row row, PropertyMap propertyMap, Node node, long l, Action action) throws SQLException, XMLMiddlewareException {
        Table table = propertyMap.getTable();
        LinkInfo linkInfo = propertyMap.getLinkInfo();
        Row row2 = this.createRow(table, row, linkInfo);
        this.generateOrder(row2, propertyMap.getOrderInfo(), l);
        this.setPropertyColumn(row2, propertyMap, node);
        int n = action.getAction();
        if (n == 3 || n == 4) {
            n = 1;
        }
        this.storeRow(table, row2, n);
        return row2;
    }

    private void processFKNodes(Row row, Vector vector, Action action) throws SQLException, XMLMiddlewareException {
        int n = 0;
        while (n < vector.size()) {
            FKNode fKNode = (FKNode)vector.elementAt(n);
            this.processRow(row, fKNode.map, fKNode.node, fKNode.orderInParent, action);
            ++n;
        }
    }

    private Row createRow(Table table, Row row, LinkInfo linkInfo) throws XMLMiddlewareException {
        Row row2 = new Row();
        Key key = table.getPrimaryKey();
        if (key != null && key.getKeyGeneration() == 2) {
            this.generateKey(row2, key);
        }
        if (row != null && linkInfo != null && linkInfo.parentKeyIsUnique()) {
            this.setChildKey(row, row2, linkInfo);
        }
        return row2;
    }

    private void setMissingFieldsToNull(Row row, Vector vector) throws XMLMiddlewareException {
        int n = 0;
        while (n < vector.size()) {
            PropertyMap propertyMap = (PropertyMap)vector.elementAt(n);
            if (propertyMap.getTable() == null && !row.haveColumn(propertyMap.getColumn())) {
                row.setColumnValue(propertyMap.getColumn(), null);
            }
            ++n;
        }
    }

    private String getNodeValue(Node node, boolean bl) {
        String string = node.getNodeType() == 1 ? DOMNormalizer.serialize(node, true, bl) : node.getNodeValue();
        if (this.m_transInfo.getMap().emptyStringIsNull() && string.length() == 0) {
            string = null;
        }
        return string;
    }

    private void setPropertyColumn(Row row, PropertyMap propertyMap, Node node) throws XMLMiddlewareException {
        Column column = propertyMap.getColumn();
        StringFormatter stringFormatter = column.getFormatter();
        Object object = stringFormatter.parse(this.getNodeValue(node, propertyMap.containsXML()), column.getType());
        row.setColumnValue(column, object);
    }

    private void generateOrder(Row row, OrderInfo orderInfo, long l) throws XMLMiddlewareException {
        if (orderInfo != null && !orderInfo.orderValueIsFixed() && orderInfo.generateOrder()) {
            Column column = orderInfo.getOrderColumn();
            Object object = ConvertObject.convertObject(new Long(l), column.getType(), column.getFormatter());
            row.setColumnValue(column, object);
        }
    }

    private Vector getUseProps(ClassMap classMap, Action action) {
        Vector vector = null;
        if (action.getAction() == 3) {
            vector = action.getUpdatePropertyMaps();
        }
        if (vector == null) {
            vector = this.getAllPropertyMaps(classMap);
        }
        return vector;
    }

    private Vector getAllPropertyMaps(ClassMapBase classMapBase) {
        if (this.m_classAllProperties.contains(classMapBase)) {
            return (Vector)this.m_classAllProperties.get(classMapBase);
        }
        Vector<PropertyMap> vector = new Vector<PropertyMap>();
        PropertyMap propertyMap = classMapBase.getPCDATAMap();
        if (propertyMap != null) {
            vector.addElement(propertyMap);
        }
        Enumeration enumeration = classMapBase.getAttributeMaps();
        while (enumeration.hasMoreElements()) {
            vector.addElement((PropertyMap)enumeration.nextElement());
        }
        enumeration = classMapBase.getChildMaps();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (e instanceof PropertyMap) {
                vector.addElement((PropertyMap)e);
                continue;
            }
            if (!(e instanceof InlineClassMap)) continue;
            Vector vector2 = this.getAllPropertyMaps((InlineClassMap)e);
            int n = 0;
            while (n < vector2.size()) {
                vector.addElement((PropertyMap)vector2.elementAt(n));
                ++n;
            }
        }
        this.m_classAllProperties.put(classMapBase, vector);
        return vector;
    }

    private Action getActionFor(Element element) throws XMLMiddlewareException {
        Action action = this.m_actions.getAction(element.getNamespaceURI(), element.getLocalName());
        if (action == null) {
            action = this.m_actions.getDefaultAction();
        }
        if (action == null) {
            throw new XMLMiddlewareException("No default action specified.");
        }
        return action;
    }

    private String buildCondition(Column[] columnArray, Object[] objectArray) throws XMLMiddlewareException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < columnArray.length) {
            if (n != 0) {
                stringBuffer.append(AND);
            }
            stringBuffer.append(columnArray[n].getName());
            stringBuffer.append('=');
            String string = SQLLiterals.buildLiteral(columnArray[n].getType(), objectArray[n], columnArray[n].getFormatter());
            stringBuffer.append(string);
            stringBuffer.append(' ');
            ++n;
        }
        return stringBuffer.toString();
    }

    private void setParentKey(Row row, Row row2, LinkInfo linkInfo) throws XMLMiddlewareException {
        Column[] columnArray = linkInfo.getChildKey().getColumns();
        if (!row2.haveColumns(columnArray)) {
            throw new XMLMiddlewareException("Internal error. The child key is not set yet.");
        }
        row.setColumnValues(linkInfo.getParentKey().getColumns(), row2.getColumnValues(columnArray));
    }

    private void setChildKey(Row row, Row row2, LinkInfo linkInfo) throws XMLMiddlewareException {
        Column[] columnArray = linkInfo.getParentKey().getColumns();
        if (!row.haveColumns(columnArray)) {
            throw new XMLMiddlewareException("Internal error. The parent key is not set yet.");
        }
        row2.setColumnValues(linkInfo.getChildKey().getColumns(), row.getColumnValues(columnArray));
    }

    private void generateKey(Row row, Key key) throws XMLMiddlewareException {
        Object[] objectArray;
        KeyGenerator keyGenerator = (KeyGenerator)this.m_keyGenerators.get(key.getKeyGeneratorName());
        if (keyGenerator == null) {
            throw new XMLMiddlewareException("No KeyGenerator added for the key generator named " + key.getKeyGeneratorName());
        }
        Column[] columnArray = key.getColumns();
        if (columnArray.length != (objectArray = keyGenerator.generateKey()).length) {
            throw new XMLMiddlewareException("Invalid number of columns generated by key generator: " + key.getKeyGeneratorName());
        }
        int n = 0;
        while (n < columnArray.length) {
            Object object = ConvertObject.convertObject(objectArray[n], columnArray[n].getType(), columnArray[n].getFormatter());
            row.setColumnValue(columnArray[n], object);
            ++n;
        }
    }

    private void storeRow(Table table, Row row, int n) throws SQLException, XMLMiddlewareException {
        boolean bl = false;
        DataHandler dataHandler = this.m_transInfo.getDataHandler(table.getDatabaseName());
        if (dataHandler == null) {
            throw new XMLMiddlewareException("DataHandler not set for the database named " + table.getDatabaseName());
        }
        try {
            switch (n) {
                case 2: {
                    bl = true;
                }
                case 1: {
                    dataHandler.insert(table, row);
                    return;
                }
                case 4: {
                    dataHandler.updateOrInsert(table, row);
                    return;
                }
                case 3: {
                    dataHandler.update(table, row, null);
                    return;
                }
                case 5: 
                case 6: {
                    throw new XMLMiddlewareException("DELETE and SOFTDELETE actions cannot be used with DOMToDBMS.");
                }
                default: {
                    throw new XMLMiddlewareException("Internal error. Invalid action in storeRow.");
                }
                case 0: {
                    return;
                }
            }
        }
        catch (SQLException sQLException) {
            if (bl) {
                this.pushWarning(new SQLWarning(sQLException.getMessage(), sQLException.getSQLState()));
                return;
            }
            throw sQLException;
        }
    }

    private void deletePropTableRows(Row row, Vector vector, Action action) throws SQLException, XMLMiddlewareException {
        if (action.getAction() == 3 || action.getAction() == 4) {
            int n = 0;
            while (n < vector.size()) {
                PropertyMap propertyMap = (PropertyMap)vector.elementAt(n);
                Table table = propertyMap.getTable();
                if (table != null) {
                    LinkInfo linkInfo = propertyMap.getLinkInfo();
                    Row row2 = this.createRow(table, row, linkInfo);
                    this.deleteRow(table, row2, linkInfo.getChildKey(), true);
                }
                ++n;
            }
        }
    }

    private void deleteRow(Table table, Row row, Key key, boolean bl) throws SQLException, XMLMiddlewareException {
        DataHandler dataHandler = this.m_transInfo.getDataHandler(table.getDatabaseName());
        if (dataHandler == null) {
            throw new XMLMiddlewareException("Database '" + table.getDatabaseName() + "' not set.");
        }
        try {
            dataHandler.delete(table, row, key);
            return;
        }
        catch (SQLException sQLException) {
            if (bl) {
                this.pushWarning(new SQLWarning(sQLException.getMessage(), sQLException.getSQLState()));
                return;
            }
            throw sQLException;
        }
    }

    private void pushException(SQLException sQLException) {
        if (this.m_sqlExceptions == null) {
            this.m_sqlExceptions = sQLException;
            return;
        }
        this.m_sqlExceptions.setNextException(sQLException);
    }

    private void pushWarning(SQLWarning sQLWarning) {
        if (this.m_sqlWarnings == null) {
            this.m_sqlWarnings = sQLWarning;
            return;
        }
        this.m_sqlWarnings.setNextWarning(sQLWarning);
    }

    class FKNode {
        Node node;
        Object map;
        long orderInParent;

        FKNode(Node node, Object object, long l) {
            DOMToDBMS.this = DOMToDBMS.this;
            this.node = node;
            this.map = object;
            this.orderInParent = l;
        }
    }
}

