/*
 * Decompiled with CFR 0.152.
 */
package org.xmlmiddleware.conversions.formatters;

import java.math.BigDecimal;
import java.text.NumberFormat;
import java.text.ParseException;
import org.xmlmiddleware.conversions.ConvertBigDecimal;
import org.xmlmiddleware.conversions.ConvertDouble;
import org.xmlmiddleware.conversions.ConvertLong;
import org.xmlmiddleware.conversions.formatters.StringFormatter;
import org.xmlmiddleware.utils.XMLMiddlewareException;

public class NumberFormatter
implements StringFormatter {
    private NumberFormat formatter;

    public NumberFormatter(NumberFormat numberFormat) {
        if (numberFormat == null) {
            throw new IllegalArgumentException("formatter argument must be non-null");
        }
        this.formatter = numberFormat;
    }

    public Object parse(String string, int n) throws XMLMiddlewareException {
        Number number;
        try {
            number = this.formatter.parse(string);
        }
        catch (ParseException parseException) {
            throw new XMLMiddlewareException(parseException);
        }
        if (number instanceof Double) {
            Double d = (Double)number;
            switch (n) {
                case -4: 
                case -3: 
                case -2: {
                    throw new XMLMiddlewareException("Conversion to binary types not supported.");
                }
                case -1: 
                case 1: 
                case 12: {
                    throw new XMLMiddlewareException("Conversion to string types not supported.");
                }
                case 6: 
                case 8: {
                    return ConvertDouble.toDoubleObject(d);
                }
                case 7: {
                    return ConvertDouble.toFloatObject(d);
                }
                case 2: 
                case 3: {
                    return ConvertDouble.toBigDecimal(d);
                }
                case -5: {
                    return ConvertDouble.toLongObject(d);
                }
                case 4: {
                    return ConvertDouble.toIntegerObject(d);
                }
                case 5: {
                    return ConvertDouble.toShortObject(d);
                }
                case -6: {
                    return ConvertDouble.toByteObject(d);
                }
                case -7: {
                    return ConvertDouble.toBooleanObject(d);
                }
                case 91: 
                case 92: 
                case 93: {
                    throw new XMLMiddlewareException("Conversion to date/time types not supported.");
                }
            }
            throw new XMLMiddlewareException("Conversion to specified JDBC type not supported.");
        }
        if (number instanceof Long) {
            Long l = (Long)number;
            switch (n) {
                case -4: 
                case -3: 
                case -2: {
                    throw new XMLMiddlewareException("Conversion to binary types not supported.");
                }
                case -1: 
                case 1: 
                case 12: {
                    throw new XMLMiddlewareException("Conversion to string types not supported.");
                }
                case 6: 
                case 8: {
                    return ConvertLong.toDoubleObject(l);
                }
                case 7: {
                    return ConvertLong.toFloatObject(l);
                }
                case 2: 
                case 3: {
                    return ConvertLong.toBigDecimal(l);
                }
                case -5: {
                    return ConvertLong.toLongObject(l);
                }
                case 4: {
                    return ConvertLong.toIntegerObject(l);
                }
                case 5: {
                    return ConvertLong.toShortObject(l);
                }
                case -6: {
                    return ConvertLong.toByteObject(l);
                }
                case -7: {
                    return ConvertLong.toBooleanObject(l);
                }
                case 91: 
                case 92: 
                case 93: {
                    throw new XMLMiddlewareException("Conversion to date/time types not supported.");
                }
            }
            throw new XMLMiddlewareException("Conversion to specified JDBC type not supported.");
        }
        throw new XMLMiddlewareException("Java does not behave as advertised. NumberFormat returned an Object other than a Long or a Double.");
    }

    public String format(Object object) throws XMLMiddlewareException {
        if (object instanceof Long || object instanceof Integer || object instanceof Short || object instanceof Byte) {
            return this.formatter.format(((Number)object).longValue());
        }
        if (object instanceof BigDecimal) {
            try {
                return this.formatter.format(ConvertBigDecimal.toLong((BigDecimal)object));
            }
            catch (XMLMiddlewareException xMLMiddlewareException) {
                return this.formatter.format(ConvertBigDecimal.toDouble((BigDecimal)object));
            }
        }
        if (object instanceof Double || object instanceof Float) {
            return this.formatter.format(((Number)object).doubleValue());
        }
        throw new XMLMiddlewareException("Object must be a BigDecimal, Long, Integer, Short, Byte, Double, or Float.");
    }

    public boolean canConvert(int n) {
        return n == 8 || n == 6 || n == 7 || n == 3 || n == 2 || n == -5 || n == 4 || n == 5 || n == -6 || n == -7;
    }

    public NumberFormat getNumberFormat() {
        return this.formatter;
    }
}

