/*
 * Decompiled with CFR 0.152.
 */
package com.trsupdate;

import com.trs.DreamFactory;
import com.trs.cms.auth.config.OperationConfig;
import com.trs.cms.auth.config.OperationRelatedConfig;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.Right;
import com.trs.cms.auth.persistent.RightValue;
import com.trs.cms.auth.persistent.Rights;
import com.trs.cms.auth.persistent.Role;
import com.trs.cms.auth.persistent.Roles;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.cms.content.CMSObjDefaultImpl;
import com.trs.components.wcm.content.domain.SiteMemberMgr;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.content.persistent.WebSites;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.config.ConfigConstants;
import com.trs.infra.config.XMLConfigServer;
import com.trs.infra.persistent.CMyResultSet;
import com.trs.infra.persistent.CMyResultSets;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyBitsValue;
import com.trs.infra.util.WCMDiscoveryFactory;
import com.trs.infra.util.store.FileService;
import com.trs.infra.util.store.FileStore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class RightUpdaterForUser {
    private static Logger logger = Logger.getLogger(RightUpdaterForUser.class);
    private static boolean IS_DEBUG = false;
    private static final long IGNORE_RIGHTVALUE_OF_SITE = -68170725458047L;
    private User m_oCurrUser = null;
    private Map m_mapChannelDefineRightCache = null;
    private String m_sTableNameOfWCM52Right = null;
    private Groups m_oGroupsOfUser = null;
    private Roles m_oRolesOfUser = null;
    private HashMap m_oSiteRightValueCache = new HashMap(70);
    private static HashMap m_hsDependIndexs = null;
    private static HashMap m_hsV6Mapping52Indexs = null;
    private static HashMap m_hsChnlValues;

    public RightUpdaterForUser(User _currUser, String _sTableNameOfWCM52Right) {
        this.m_oCurrUser = _currUser;
        this.m_sTableNameOfWCM52Right = _sTableNameOfWCM52Right;
    }

    private static void initMappingIndexs() {
        m_hsV6Mapping52Indexs = new HashMap();
        ArrayList<Integer> lst = null;
        lst = new ArrayList<Integer>();
        m_hsV6Mapping52Indexs.put(new Integer(24), lst);
        lst.add(new Integer(21));
        lst.add(new Integer(25));
        lst = new ArrayList();
        m_hsV6Mapping52Indexs.put(new Integer(25), lst);
        lst.add(new Integer(24));
        lst = new ArrayList();
        m_hsV6Mapping52Indexs.put(new Integer(29), lst);
        lst.add(new Integer(24));
    }

    private static void initSomeDependIndexs() {
        ArrayList<Integer> lst = null;
        lst = new ArrayList<Integer>();
        m_hsDependIndexs.put(new Integer(23), lst);
        lst.add(new Integer(24));
        lst = new ArrayList();
        m_hsDependIndexs.put(new Integer(15), lst);
        lst.add(new Integer(28));
        lst = new ArrayList();
        m_hsDependIndexs.put(new Integer(17), lst);
        lst.add(new Integer(28));
        lst = new ArrayList();
        m_hsDependIndexs.put(new Integer(40), lst);
        lst.add(new Integer(54));
        lst = new ArrayList();
        m_hsDependIndexs.put(new Integer(1), lst);
        lst.add(new Integer(7));
        lst = new ArrayList();
        m_hsDependIndexs.put(new Integer(13), lst);
        lst.add(new Integer(8));
        lst.add(new Integer(55));
        lst = new ArrayList();
        m_hsDependIndexs.put(new Integer(33), lst);
        lst.add(new Integer(56));
        lst = new ArrayList();
        m_hsDependIndexs.put(new Integer(24), lst);
        lst.add(new Integer(14));
        lst = new ArrayList();
        m_hsDependIndexs.put(new Integer(14), lst);
        lst.add(new Integer(53));
    }

    private static RightValue renderDiffIdxRight(RightValue _rightValue) {
        ArrayList<RightValue> mergeValues = new ArrayList<RightValue>();
        for (int i = 0; i < 64; ++i) {
            List lstMapping = (List)m_hsV6Mapping52Indexs.get(new Integer(i));
            if (lstMapping == null || !_rightValue.getBit(i)) continue;
            RightValue oRightValue = new RightValue();
            oRightValue.setValue(0L);
            Iterator iter = lstMapping.iterator();
            while (iter.hasNext()) {
                int nIndex = (Integer)iter.next();
                oRightValue.setBit(nIndex, true);
            }
            mergeValues.add(oRightValue);
        }
        if (mergeValues != null && mergeValues.size() > 0) {
            RightValue oRightValue = new RightValue();
            oRightValue.setValue(_rightValue.getValue());
            Iterator<Object> iter = m_hsV6Mapping52Indexs.keySet().iterator();
            while (iter.hasNext()) {
                int nIndex = (Integer)iter.next();
                oRightValue.setBit(nIndex, false);
            }
            for (RightValue rightValue : mergeValues) {
                oRightValue.or(rightValue);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("_rightValue:" + _rightValue));
                logger.debug((Object)("mergeValues:" + mergeValues));
                logger.debug((Object)("oRightValue:" + oRightValue));
            }
            return oRightValue;
        }
        return _rightValue;
    }

    private static void initDependIndexs() {
        m_hsDependIndexs = new HashMap();
        RightUpdaterForUser.initSomeDependIndexs();
        XMLConfigServer oXMLConfigServer = XMLConfigServer.getInstance();
        List listOperation = oXMLConfigServer.getConfigObjects(OperationConfig.class);
        int nSize = listOperation.size();
        for (int i = 0; i < nSize; ++i) {
            OperationConfig operationConfig = (OperationConfig)listOperation.get(i);
            if (operationConfig == null) continue;
            Integer oKey = new Integer(operationConfig.getIndex());
            ArrayList lstIndexs = (ArrayList)m_hsDependIndexs.get(oKey);
            List newList = RightUpdaterForUser.getDependIndexs(operationConfig);
            if (lstIndexs != null) {
                newList.addAll(lstIndexs);
            }
            m_hsDependIndexs.put(oKey, newList);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("m_hsDependIndexs:" + m_hsDependIndexs));
        }
    }

    private static List getDependIndexs(OperationConfig operationConfig) {
        ArrayList<Integer> lstResult = new ArrayList<Integer>();
        OperationRelatedConfig includes = operationConfig.getDepends();
        if (includes == null) {
            return lstResult;
        }
        ArrayList elements = includes.getOperations();
        int nSize = elements.size();
        for (int i = 0; i < nSize; ++i) {
            OperationConfig includeOperation = (OperationConfig)elements.get(i);
            if (includeOperation == null) continue;
            lstResult.add(new Integer(includeOperation.getIndex()));
        }
        return lstResult;
    }

    private static CMyBitsValue renderRelatedRight(CMyBitsValue _chnlValue) {
        logger.debug((Object)("before:" + _chnlValue.toString()));
        Long key = new Long(_chnlValue.getValue());
        Object obj = m_hsChnlValues.get(key);
        if (obj != null) {
            _chnlValue = (CMyBitsValue)obj;
        } else {
            _chnlValue = RightUpdaterForUser.renderRelatedRight(_chnlValue, 0);
            m_hsChnlValues.put(key, _chnlValue);
        }
        logger.debug((Object)("after:" + _chnlValue.toString()));
        return _chnlValue;
    }

    private static CMyBitsValue renderRelatedRight(CMyBitsValue _chnlValue, int _i) {
        if (_i >= 64 || _i < 0) {
            return _chnlValue;
        }
        if (!_chnlValue.getBit(_i)) {
            return RightUpdaterForUser.renderRelatedRight(_chnlValue, _i + 1);
        }
        List lstDepends = (List)m_hsDependIndexs.get(new Integer(_i));
        if (lstDepends == null || lstDepends.size() == 0) {
            return RightUpdaterForUser.renderRelatedRight(_chnlValue, _i + 1);
        }
        for (int i = 0; i < lstDepends.size(); ++i) {
            int tmpIndex = (Integer)lstDepends.get(i);
            if (_chnlValue.getBit(tmpIndex)) continue;
            _chnlValue.setBit(tmpIndex, true);
            _chnlValue = RightUpdaterForUser.renderRelatedRight(_chnlValue, tmpIndex);
        }
        return RightUpdaterForUser.renderRelatedRight(_chnlValue, _i + 1);
    }

    public int doResetRight() throws WCMException {
        if (this.m_oCurrUser.isAdministrator()) {
            return 0;
        }
        if (IS_DEBUG) {
            logger.fatal((Object)(I18NMessage.get(RightUpdaterForUser.class, "RightUpdaterForUser.label1", "\u5f53\u524d\u5904\u7406\u7684\u7528\u6237\u662f\uff1a") + this.m_oCurrUser));
        }
        this.m_oGroupsOfUser = this.m_oCurrUser.getGroups();
        this.m_oRolesOfUser = this.m_oCurrUser.getRoles();
        this.m_oRolesOfUser.addElement(Role.findById(2));
        SiteMemberMgr siteMemberMgr = (SiteMemberMgr)DreamFactory.createObjectById("SiteMemberMgr");
        WebSites sites = WebSites.openWCMObjs(null, null);
        for (int i = sites.size() - 1; i >= 0; --i) {
            WebSite site = (WebSite)sites.getAt(i);
            if (site == null || siteMemberMgr.isVisible(this.m_oCurrUser, site)) continue;
            sites.removeAt(i, false);
        }
        HashMap<Integer, Long> mapChannelExtends = new HashMap<Integer, Long>();
        WCMFilter filter = new WCMFilter("WCMCHANNEL", "SiteId in(" + sites.getIdListAsString() + ")", "ChannelId");
        Channels oNeedDowithChannels = Channels.openWCMObjs(null, filter);
        int nChannelCount = 0;
        int nSize = oNeedDowithChannels.size();
        for (int i = 0; i < nSize; ++i) {
            Channel channel;
            int nCurrChannelId = oNeedDowithChannels.getIdAt(i);
            if (this.getChannelRightValue(nCurrChannelId) != null || (channel = (Channel)oNeedDowithChannels.getAt(i)) == null) continue;
            CMyBitsValue parentValue = null;
            for (Channel parent = channel.getParent(); parent != null && (parentValue = this.getRightValueHasDefine(parent)) == null; parent = parent.getParent()) {
            }
            if (parentValue == null) {
                parentValue = this.getSiteRightValue(channel.getSiteId());
            }
            if (parentValue == null || parentValue.getValue() == 0L) continue;
            ++nChannelCount;
            if (IS_DEBUG) {
                logger.fatal((Object)(I18NMessage.get(RightUpdaterForUser.class, "RightUpdaterForUser.label2", "\u5f53\u524d\u680f\u76ee[") + channel + I18NMessage.get(RightUpdaterForUser.class, "RightUpdaterForUser.label3", "]\u7684\u6743\u9650\u662f[") + parentValue.getValue() + "]"));
                continue;
            }
            this.saveCurrRightValue(this.m_oCurrUser, 101, channel.getId(), parentValue.getValue());
            mapChannelExtends.put(new Integer(channel.getId()), new Long(parentValue.getValue()));
        }
        HashMap<Integer, String> mapSiteAddBrowses = new HashMap<Integer, String>();
        HashMap<Integer, String> mapChnlAddBrowses = new HashMap<Integer, String>();
        CMyBitsValue oTmpBitsValue = new CMyBitsValue(0L);
        oTmpBitsValue.setBit(14, true);
        long lOnlyBrowseChnlRightValue = oTmpBitsValue.getValue();
        int nSize2 = oNeedDowithChannels.size();
        for (int i = 0; i < nSize2; ++i) {
            Channel channel;
            int nCurrChannelId = oNeedDowithChannels.getIdAt(i);
            Integer oAddBrowseKey = new Integer(nCurrChannelId);
            if (mapChnlAddBrowses.containsKey(oAddBrowseKey) || this.getChannelRightValue(nCurrChannelId) == null || (channel = (Channel)oNeedDowithChannels.getAt(i)) == null) continue;
            CMyBitsValue parentValue = null;
            Channel parent = channel.getParent();
            while (parent != null && ((parentValue = this.getRightValueHasDefine(parent)) == null || parentValue.getValue() == 0L)) {
                oAddBrowseKey = new Integer(parent.getId());
                if (mapChnlAddBrowses.containsKey(oAddBrowseKey)) {
                    parent = parent.getParent();
                    continue;
                }
                mapChnlAddBrowses.put(oAddBrowseKey, "");
                if (mapChannelExtends.containsKey(oAddBrowseKey)) {
                    CMyBitsValue oTmpRV = new CMyBitsValue((Long)mapChannelExtends.get(oAddBrowseKey));
                    oTmpRV.setBit(14, true);
                    if (IS_DEBUG) {
                        logger.fatal((Object)(I18NMessage.get(RightUpdaterForUser.class, "RightUpdaterForUser.label2", "\u5f53\u524d\u680f\u76ee[") + parent + I18NMessage.get(RightUpdaterForUser.class, "RightUpdaterForUser.label3", "]\u7684\u6743\u9650\u662f[") + oTmpRV.getValue() + "]"));
                        continue;
                    }
                    this.onlyUpdateCurrRightValue(this.m_oCurrUser, 101, parent.getId(), oTmpRV.getValue());
                    continue;
                }
                ++nChannelCount;
                if (IS_DEBUG) {
                    logger.fatal((Object)(I18NMessage.get(RightUpdaterForUser.class, "RightUpdaterForUser.label2", "\u5f53\u524d\u680f\u76ee[") + parent + I18NMessage.get(RightUpdaterForUser.class, "RightUpdaterForUser.label3", "]\u7684\u6743\u9650\u662f[") + lOnlyBrowseChnlRightValue + "]"));
                } else {
                    this.saveCurrRightValue(this.m_oCurrUser, 101, parent.getId(), lOnlyBrowseChnlRightValue);
                }
                parent = parent.getParent();
            }
            WebSite oWebSite = channel.getSite();
            parentValue = this.getRightValueHasDefine(oWebSite);
            if (parentValue != null && parentValue.getValue() != 0L || !mapSiteAddBrowses.containsKey(oAddBrowseKey = new Integer(oWebSite.getId()))) continue;
            mapSiteAddBrowses.put(oAddBrowseKey, "");
            ++nChannelCount;
            if (IS_DEBUG) {
                logger.fatal((Object)(I18NMessage.get(RightUpdaterForUser.class, "RightUpdaterForUser.label2", "\u5f53\u524d\u680f\u76ee[") + oWebSite + I18NMessage.get(RightUpdaterForUser.class, "RightUpdaterForUser.label3", "]\u7684\u6743\u9650\u662f[") + lOnlyBrowseChnlRightValue + "]"));
                continue;
            }
            this.saveCurrRightValue(this.m_oCurrUser, 103, oWebSite.getId(), lOnlyBrowseChnlRightValue);
        }
        logger.fatal((Object)(I18NMessage.get(RightUpdaterForUser.class, "RightUpdaterForUser.label4", "\u7528\u6237[") + this.m_oCurrUser + I18NMessage.get(RightUpdaterForUser.class, "RightUpdaterForUser.label5", "]\u9700\u8981\u65b0\u589e\u3010") + nChannelCount + I18NMessage.get(RightUpdaterForUser.class, "RightUpdaterForUser.label6", "\u3011\u6761\u6743\u9650\uff01")));
        return nChannelCount;
    }

    private static void renderOldRights() throws WCMException {
        Rights oRights = Rights.openWCMObjs(null, null);
        int nSize = oRights.size();
        for (int i = 0; i < nSize; ++i) {
            Right oRight = (Right)oRights.getAt(i);
            RightValue oRightValue = oRight.getValue();
            if (oRight == null || oRight.getObjType() != 605 && oRight.getObjType() != 101 && oRight.getObjType() != 103) continue;
            long oldValue = oRight.getValueAsLong();
            long newValue = 0L;
            oRightValue = RightUpdaterForUser.renderDiffIdxRight(oRightValue);
            newValue = (oRightValue = (RightValue)RightUpdaterForUser.renderRelatedRight(oRightValue)).getValue();
            if (newValue == oldValue) continue;
            oRight.canEdit(User.getSystem());
            oRight.setValue(newValue);
            oRight.save();
        }
    }

    private void saveCurrRightValue(User _operator, int _objType, int _objId, long _newValue) throws WCMException {
        CMSObjDefaultImpl oSaveObj = new CMSObjDefaultImpl("WCMRIGHT", "RIGHTID");
        try {
            oSaveObj.setProperty("ObjType", _objType);
            oSaveObj.setProperty("ObjId", _objId);
            oSaveObj.setProperty("OprType", 204L);
            oSaveObj.setProperty("OprId", _operator.getId());
            oSaveObj.setProperty("RightValue", _newValue);
            oSaveObj.save(this.m_oCurrUser);
        }
        catch (WCMException ex) {
            throw new WCMException(1100, I18NMessage.get(RightUpdaterForUser.class, "RightUpdaterForUser.label7", "\u4fdd\u5b58\u7528\u6237\u6743\u9650\u503c\u65f6\u5931\u8d25"), ex);
        }
        catch (Exception ex) {
            throw new WCMException(0, I18NMessage.get(RightUpdaterForUser.class, "RightUpdaterForUser.label7", "\u4fdd\u5b58\u7528\u6237\u6743\u9650\u503c\u65f6\u5931\u8d25"), ex);
        }
    }

    private void onlyUpdateCurrRightValue(User _operator, int _objType, int _objId, long _newValue) throws WCMException {
        try {
            Right right = Right.findBy(_objType, _objId, 204, _operator.getId());
            if (right == null) {
                return;
            }
            right.setProperty("RightValue", _newValue);
            right.save(this.m_oCurrUser);
        }
        catch (WCMException ex) {
            throw new WCMException(1100, I18NMessage.get(RightUpdaterForUser.class, "RightUpdaterForUser.label7", "\u4fdd\u5b58\u7528\u6237\u6743\u9650\u503c\u65f6\u5931\u8d25"), ex);
        }
        catch (Exception ex) {
            throw new WCMException(0, I18NMessage.get(RightUpdaterForUser.class, "RightUpdaterForUser.label7", "\u4fdd\u5b58\u7528\u6237\u6743\u9650\u503c\u65f6\u5931\u8d25"), ex);
        }
    }

    private CMyBitsValue getChannelRightValue(int _nChannelId) throws WCMException {
        if (this.m_mapChannelDefineRightCache == null) {
            this.initChannelRightCache();
        }
        return (CMyBitsValue)this.m_mapChannelDefineRightCache.get(new Integer(_nChannelId));
    }

    private CMyBitsValue getSiteRightValue(int _nSiteId) throws WCMException {
        Integer iKey = new Integer(_nSiteId);
        CMyBitsValue value = (CMyBitsValue)this.m_oSiteRightValueCache.get(iKey);
        if (value == null) {
            value = this.makeSiteRightValue(_nSiteId);
            if (value == null) {
                value = new CMyBitsValue(0L);
            }
            this.m_oSiteRightValueCache.put(iKey, value);
        }
        return value;
    }

    private CMyBitsValue getRightValueHasDefine(BaseChannel _oSiteOrChannel) throws WCMException {
        if (_oSiteOrChannel.isSite()) {
            return this.getSiteRightValue(_oSiteOrChannel.getId());
        }
        return this.getChannelRightValue(_oSiteOrChannel.getId());
    }

    private CMyBitsValue makeSiteRightValue(int _nSiteId) throws WCMException {
        CMyResultSets oResultSets = new CMyResultSets();
        ArrayList<Integer> listParameters = new ArrayList<Integer>(4);
        listParameters.add(new Integer(204));
        listParameters.add(new Integer(this.m_oCurrUser.getId()));
        listParameters.add(new Integer(103));
        listParameters.add(new Integer(_nSiteId));
        String sObjWhere = "ObjType=? and ObjId=?";
        oResultSets.open("select RightId,RightValue from " + this.m_sTableNameOfWCM52Right + " where OprType=? and OprId=? and " + sObjWhere, listParameters, "RightId");
        if (!oResultSets.isEmpty()) {
            CMyResultSet resultSet = (CMyResultSet)oResultSets.getAt(0);
            return new CMyBitsValue(resultSet.getPropertyAsLong("RightValue", 0L));
        }
        listParameters = new ArrayList(4 + this.m_oGroupsOfUser.size() + this.m_oRolesOfUser.size());
        String sOprWhere = this.makeOprWhereContainsGroupRole(listParameters);
        listParameters.add(new Integer(103));
        listParameters.add(new Integer(_nSiteId));
        String sWhere = "(" + sOprWhere + ") and (" + sObjWhere + ")";
        oResultSets.open("select RightId,RightValue from " + this.m_sTableNameOfWCM52Right + " where " + sWhere, listParameters, "RightId");
        if (oResultSets.isEmpty()) {
            return null;
        }
        return this.mergeRightValue(oResultSets);
    }

    private synchronized void initChannelRightCache() throws WCMException {
        if (this.m_mapChannelDefineRightCache != null) {
            return;
        }
        HashMap<Integer, CMyBitsValue> mapChannelRightCacheTemp = new HashMap<Integer, CMyBitsValue>();
        CMyResultSets oResultSets = new CMyResultSets();
        ArrayList<Integer> listParameters = null;
        listParameters = new ArrayList<Integer>(7);
        String sOprWhere = "OprType=? and OprId=? ";
        listParameters.add(new Integer(204));
        listParameters.add(new Integer(this.m_oCurrUser.getId()));
        String sObjWhere = "ObjType=?";
        listParameters.add(new Integer(101));
        String sWhere = "(" + sOprWhere + ") and (" + sObjWhere + ")";
        oResultSets = new CMyResultSets();
        oResultSets.open("select RightId,RightValue,ObjId from " + this.m_sTableNameOfWCM52Right + " where " + sWhere + " order by ObjId", listParameters, "RightId");
        int nSize = oResultSets.size();
        for (int i = 0; i < nSize; ++i) {
            CMyResultSet oResultSet = (CMyResultSet)oResultSets.getAt(i);
            if (oResultSet == null) continue;
            Integer iKey = new Integer(oResultSet.getPropertyAsInt("ObjId", 0));
            CMyBitsValue value = new CMyBitsValue(oResultSet.getPropertyAsLong("RightValue", 0L));
            mapChannelRightCacheTemp.put(iKey, value);
        }
        listParameters = new ArrayList(7 + this.m_oGroupsOfUser.size() + this.m_oRolesOfUser.size());
        sOprWhere = this.makeOprWhereContainsGroupRole(listParameters);
        sObjWhere = "ObjType=?";
        listParameters.add(new Integer(101));
        sWhere = "(" + sOprWhere + ") and (" + sObjWhere + ")";
        oResultSets = new CMyResultSets();
        String sSQL = "select RightId,RightValue,ObjId from " + this.m_sTableNameOfWCM52Right + " where " + sWhere + " order by ObjId";
        oResultSets.open(sSQL, listParameters, "RightId");
        int nSize2 = oResultSets.size();
        for (int i = 0; i < nSize2; ++i) {
            int nObjId;
            Integer iKey;
            CMyResultSet oResultSet = (CMyResultSet)oResultSets.getAt(i);
            if (oResultSet == null || mapChannelRightCacheTemp.containsKey(iKey = new Integer(nObjId = oResultSet.getPropertyAsInt("ObjId", 0)))) continue;
            CMyBitsValue value = new CMyBitsValue(0L);
            while (i < nSize2) {
                oResultSet = (CMyResultSet)oResultSets.getAt(i);
                if (oResultSet != null) {
                    if (oResultSet.getPropertyAsInt("ObjId", 0) != nObjId) break;
                    value.or(new CMyBitsValue(oResultSet.getPropertyAsLong("RightValue", 0L)));
                }
                ++i;
            }
            mapChannelRightCacheTemp.put(iKey, value);
            --i;
        }
        this.m_mapChannelDefineRightCache = mapChannelRightCacheTemp;
    }

    private CMyBitsValue mergeRightValue(CMyResultSets _oResultSets) {
        CMyBitsValue value = new CMyBitsValue(0L);
        int nSize = _oResultSets.size();
        for (int i = 0; i < nSize; ++i) {
            CMyResultSet oResultSet = (CMyResultSet)_oResultSets.getAt(i);
            if (oResultSet == null) continue;
            value.or(new CMyBitsValue(oResultSet.getPropertyAsLong("RightValue", 0L)));
        }
        return value;
    }

    private String makeOprWhereContainsGroupRole(ArrayList _listParameters) {
        _listParameters.add(new Integer(203));
        StringBuffer sbTemp = new StringBuffer(this.m_oRolesOfUser.size() * 2);
        int nSize = this.m_oRolesOfUser.size();
        for (int i = 0; i < nSize; ++i) {
            sbTemp.append("?,");
            _listParameters.add(new Integer(this.m_oRolesOfUser.getIdAt(i)));
        }
        sbTemp.setLength(sbTemp.length() - 1);
        String sOperWhere = "(OprType=? and OprId in(" + sbTemp + "))";
        if (!this.m_oGroupsOfUser.isEmpty()) {
            _listParameters.add(new Integer(201));
            sbTemp = new StringBuffer(this.m_oGroupsOfUser.size() * 2);
            int nSize2 = this.m_oGroupsOfUser.size();
            for (int i = 0; i < nSize2; ++i) {
                sbTemp.append("?,");
                _listParameters.add(new Integer(this.m_oGroupsOfUser.getIdAt(i)));
            }
            sbTemp.setLength(sbTemp.length() - 1);
            sOperWhere = sOperWhere + " or (OprType=? and OprId in(" + sbTemp + "))";
        }
        return sOperWhere;
    }

    public void clear() {
        if (this.m_mapChannelDefineRightCache != null) {
            this.m_mapChannelDefineRightCache.clear();
            this.m_mapChannelDefineRightCache = null;
        }
        if (this.m_oSiteRightValueCache != null) {
            this.m_oSiteRightValueCache.clear();
            this.m_oSiteRightValueCache = null;
        }
    }

    public static void main(String[] args) {
        String sUserName = "wfj";
        String sFromUserId = "0";
        int nToUserId = 0;
        if (args != null && args.length > 0) {
            sFromUserId = args[0];
            if (args.length > 1) {
                nToUserId = Integer.parseInt(args[1]);
            }
            if (args.length > 2) {
                IS_DEBUG = "DEBUG".equalsIgnoreCase(args[2].trim());
            }
        }
        try {
            logger.debug((Object)ConfigConstants.DIR_APPROOT);
            logger.debug((Object)ConfigConstants.DIR_CLASSROOT);
            FileStore[] _pLibDirs = new FileStore[]{new FileService(ConfigConstants.DIR_APPROOT + "\\..\\lib\\wcm\\")};
            WCMDiscoveryFactory.initDiscovery(_pLibDirs, null);
            DBManager.getDBManager();
            int nChannelCount = 0;
            String sUserWhere = "UserId>=" + sFromUserId;
            if (nToUserId > 0) {
                sUserWhere = sUserWhere + " and UserId<=" + nToUserId;
            }
            Users users = Users.openWCMObjs(null, new WCMFilter("", sUserWhere, "UserId"));
            int nSize = users.size();
            for (int i = 0; i < nSize; ++i) {
                User user = (User)users.getAt(i);
                if (user == null) continue;
                RightUpdaterForUser calculatorForWCM52 = new RightUpdaterForUser(user, "WCMRightBak01");
                nChannelCount += calculatorForWCM52.doResetRight();
            }
            RightUpdaterForUser.renderOldRights();
            logger.fatal((Object)(I18NMessage.get(RightUpdaterForUser.class, "RightUpdaterForUser.label8", "\u6743\u9650\u5347\u7ea7\u5b8c\u6210:\u5171\u65b0\u589e\u4e86\u3010") + nChannelCount + I18NMessage.get(RightUpdaterForUser.class, "RightUpdaterForUser.label6", "\u3011\u6761\u6743\u9650\uff01")));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        RightUpdaterForUser.initDependIndexs();
        RightUpdaterForUser.initMappingIndexs();
        m_hsChnlValues = new HashMap();
    }
}

