/*
 * Decompiled with CFR 0.152.
 */
package com.trs.webframework.controler;

import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import java.io.CharArrayWriter;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class PostDataParser
extends DefaultHandler {
    private static Logger logger = Logger.getLogger(PostDataParser.class);
    private CharArrayWriter m_oCharWriterTemp = new CharArrayWriter();
    private String m_sCurrServiceName = null;
    private String[] m_pServiceNames = new String[0];
    private HashMap[] m_pParameters = new HashMap[0];
    private int m_nCurrStatusId = 0;
    private static final int STATUS_START = 0;
    private static final int STATUS_METHOD_FIND = 1;
    private static final int STATUS_METHOD_RECORD = 2;
    private static final int STATUS_PARAMETERS_FIND = 3;
    private static final int STATUS_PARAMETER_FIND = 4;
    private static final int STATUS_PARAMETER_RECORD = 5;
    private static final int STATUS_END = 10;

    public void parse(String _sXMLFile) throws WCMException {
        try {
            XMLReader reader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            reader.setContentHandler(this);
            reader.parse(new InputSource(new FileReader(_sXMLFile)));
        }
        catch (Exception e) {
            throw new WCMException(I18NMessage.get(PostDataParser.class, "PostDataParser.label1", "\u89e3\u6790\u6587\u4ef6\u5931\u8d25!"), e);
        }
    }

    public void parse(InputSource _ins) throws WCMException {
        try {
            XMLReader reader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            reader.setContentHandler(this);
            reader.parse(_ins);
        }
        catch (Exception e) {
            throw new WCMException(I18NMessage.get(PostDataParser.class, "PostDataParser.label2", "\u89e3\u6790\u8f93\u5165\u6d41\u5931\u8d25!"), e);
        }
    }

    public HashMap findParameters(String _sServiceId, String _sMethodName) {
        for (int i = 0; i < this.m_pServiceNames.length; ++i) {
            String sServiceName = this.m_pServiceNames[i];
            if (!sServiceName.equalsIgnoreCase(_sServiceId + "." + _sMethodName)) continue;
            return this.m_pParameters[i];
        }
        return null;
    }

    public HashMap[] findArrayParameters(String _sServiceId, String _sMethodName) {
        ArrayList<HashMap> listResult = new ArrayList<HashMap>();
        for (int i = 0; i < this.m_pServiceNames.length; ++i) {
            String sServiceName = this.m_pServiceNames[i];
            if (!sServiceName.equalsIgnoreCase(_sServiceId + "." + _sMethodName)) continue;
            listResult.add(this.m_pParameters[i]);
        }
        HashMap[] result = new HashMap[listResult.size()];
        listResult.toArray(result);
        return result;
    }

    public HashMap findParameters(int _nServiceIndex) {
        if (_nServiceIndex >= this.m_pParameters.length) {
            return null;
        }
        return this.m_pParameters[_nServiceIndex];
    }

    public String findServiceId(int _nServiceIndex) {
        if (_nServiceIndex >= this.m_pServiceNames.length) {
            return null;
        }
        int nPos = this.m_pServiceNames[_nServiceIndex].indexOf(".");
        return this.m_pServiceNames[_nServiceIndex].substring(0, nPos);
    }

    public String findMethodName(int _nServiceIndex) {
        if (_nServiceIndex >= this.m_pServiceNames.length) {
            return null;
        }
        int nPos = this.m_pServiceNames[_nServiceIndex].indexOf(".");
        return this.m_pServiceNames[_nServiceIndex].substring(nPos + 1);
    }

    @Override
    public void characters(char[] _ch, int _start, int _length) throws SAXException {
        if (this.m_nCurrStatusId != 2 && this.m_nCurrStatusId != 5) {
            return;
        }
        this.m_oCharWriterTemp.write(_ch, _start, _length);
    }

    @Override
    public void startElement(String _uri, String _localName, String _name, Attributes _attributes) throws SAXException {
        if (_localName.equalsIgnoreCase("post-data") && this.m_nCurrStatusId == 0) {
            this.m_nCurrStatusId = 1;
        } else if (_localName.equalsIgnoreCase("METHOD") && this.m_nCurrStatusId == 1) {
            this.m_sCurrServiceName = _attributes.getValue("type");
            this.m_nCurrStatusId = 2;
        } else if (_localName.equalsIgnoreCase("parameters") && this.m_nCurrStatusId == 3) {
            this.m_nCurrStatusId = 4;
        } else if (this.m_nCurrStatusId == 4) {
            this.m_nCurrStatusId = 5;
        } else {
            logger.error((Object)I18NMessage.get(PostDataParser.class, "PostDataParser.label3", "\u4e0d\u7b26\u5408\u89c4\u5219\u7684\u6570\u636e\u7ed3\u6784\uff0c\u6682\u65f6\u4e0d\u76f4\u63a5\u629b\u51fa\u5f02\u5e38\u7ee7\u7eed\u64cd\u4f5c!\u4e0a\u4e0b\u6587\u4fe1\u606f\u5982\u4e0b\uff1a"));
            logger.error((Object)("TagName:" + _localName));
            logger.error((Object)("_attributes:" + _attributes));
        }
        if (this.m_nCurrStatusId == 2 || this.m_nCurrStatusId == 5) {
            this.m_oCharWriterTemp.reset();
        }
    }

    @Override
    public void endElement(String _uri, String _localName, String _name) throws SAXException {
        switch (this.m_nCurrStatusId) {
            case 2: {
                this.m_sCurrServiceName = this.m_oCharWriterTemp.toString() + "." + this.m_sCurrServiceName;
                this.m_nCurrStatusId = 3;
                this.addServiceName();
                break;
            }
            case 5: {
                this.m_pParameters[this.m_pParameters.length - 1].put(_localName, this.m_oCharWriterTemp.toString());
                this.m_nCurrStatusId = 4;
                break;
            }
            default: {
                if (_localName.equalsIgnoreCase("post-data")) {
                    this.m_nCurrStatusId = 10;
                    break;
                }
                if (!_localName.equalsIgnoreCase("parameters")) break;
                this.m_nCurrStatusId = 1;
            }
        }
    }

    private void addServiceName() {
        int nOldLen = this.m_pServiceNames.length;
        String[] pTemp = new String[nOldLen + 1];
        if (nOldLen > 0) {
            System.arraycopy(this.m_pServiceNames, 0, pTemp, 0, nOldLen);
        }
        pTemp[nOldLen] = this.m_sCurrServiceName;
        this.m_pServiceNames = pTemp;
        HashMap[] pParameterTemp = new HashMap[nOldLen + 1];
        if (nOldLen > 0) {
            System.arraycopy(this.m_pParameters, 0, pParameterTemp, 0, nOldLen);
        }
        pParameterTemp[nOldLen] = new HashMap(3);
        this.m_pParameters = pParameterTemp;
    }

    public static void main(String[] args) {
        try {
            PostDataParser handler = new PostDataParser();
            handler.parse("c:/data.xml");
            for (int i = 0; i < handler.m_pServiceNames.length; ++i) {
                String sServiceName = handler.m_pServiceNames[i];
                System.out.println(sServiceName);
                System.out.println(handler.m_pParameters[i]);
            }
            System.out.println(handler.findServiceId(1));
            System.out.println(handler.findMethodName(1));
            System.out.println(handler.findParameters(1));
            System.out.println(handler.findParameters("wcm6_channel", "changeorder2"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

