/*
 * Decompiled with CFR 0.152.
 */
package com.trs.wcm.photo.impl;

import com.trs.DreamFactory;
import com.trs.components.wcm.content.domain.DocumentMgr;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyUnZipFile;
import com.trs.infra.util.XmlDocWithDom4j;
import com.trs.infra.util.store.FileService;
import com.trs.wcm.photo.IImageLibConfig;
import com.trs.wcm.photo.impl.MagicImageImpl;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;

public class PhotoImporter {
    private static final String PROP_PICFILE = "_PICFILE_";
    private static final Logger logger = Logger.getLogger(PhotoImporter.class);
    private static DocumentMgr m_oDocumentMgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
    private static IImageLibConfig m_oImageLibConfig = (IImageLibConfig)DreamFactory.createObjectById("IImageLibConfig");
    private FilesMan m_oFileMan = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importViaZipFile(String fn, Channel channel) throws WCMException {
        block14: {
            FileService f = new FileService(fn);
            if (!f.exists()) {
                throw new WCMException(55, I18NMessage.get(PhotoImporter.class, "PhotoImporter.label1", "\u6587\u4ef6[") + fn + I18NMessage.get(PhotoImporter.class, "PhotoImporter.label2", "]\u4e0d\u5b58\u5728\uff01"));
            }
            StringBuffer buff = new StringBuffer(64);
            buff.append(f.getParent());
            buff.append(File.separator);
            buff.append("temp").append(System.currentTimeMillis());
            buff.append(File.separator);
            String sUnZipFile = buff.toString();
            CMyUnZipFile uzf = new CMyUnZipFile(fn, sUnZipFile);
            try {
                uzf.addFileExtFilters("xml");
                uzf.doUnZipAnd();
                if (!logger.isDebugEnabled()) {
                    f.delete();
                }
            }
            catch (CMyException e) {
                throw new WCMException(200, I18NMessage.get(PhotoImporter.class, "PhotoImporter.label3", "Zip\u6587\u4ef6\u89e3\u538b\u5931\u8d25!"), e);
            }
            ArrayList allXmlFiles = uzf.getFilteredFiles();
            String sXmlFile = null;
            Document xmlDoc = null;
            List docs = null;
            Iterator itrDoc = null;
            Iterator itrProps = null;
            Element doc2 = null;
            com.trs.components.wcm.content.persistent.Document document = null;
            String propKey = null;
            String propValue = null;
            Element prop = null;
            try {
                this.m_oFileMan = FilesMan.getFilesMan();
                if (allXmlFiles == null || allXmlFiles.size() <= 0) break block14;
                for (int i = allXmlFiles.size() - 1; i >= 0; --i) {
                    sXmlFile = (String)allXmlFiles.get(i);
                    try {
                        xmlDoc = XmlDocWithDom4j.parse(sXmlFile);
                    }
                    catch (DocumentException ex) {
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug((Object)"parse fail!", (Throwable)ex);
                        continue;
                    }
                    docs = xmlDoc.selectNodes("//WCMDOCUMENTS/WCMDOCUMENT");
                    if (docs == null || docs.isEmpty()) continue;
                    for (Element doc2 : docs) {
                        document = new com.trs.components.wcm.content.persistent.Document();
                        itrProps = doc2.elementIterator();
                        while (itrProps.hasNext()) {
                            prop = (Element)itrProps.next();
                            propKey = prop.getName();
                            propValue = prop.getText();
                            if (PROP_PICFILE.equals(propKey)) {
                                propKey = "DOCRELWORDS";
                                propValue = this.processPic(sUnZipFile + propValue);
                            }
                            document.setPropertyWithString(propKey, propValue);
                        }
                        if (channel != null) {
                            document.setChannel(channel);
                        }
                        m_oDocumentMgr.save(document);
                    }
                }
            }
            finally {
                CMyFile.deleteDir(sUnZipFile);
            }
        }
    }

    private String processPic(String pic) throws WCMException {
        FileService picFile = new FileService(pic);
        if (!picFile.exists()) {
            throw new WCMException(55, I18NMessage.get(PhotoImporter.class, "PhotoImporter.label4", "\u56fe\u7247[") + pic + I18NMessage.get(PhotoImporter.class, "PhotoImporter.label2", "]\u4e0d\u5b58\u5728\uff01"));
        }
        String sExt = pic.substring(pic.lastIndexOf(46) + 1);
        String sSrcImage = this.m_oFileMan.getNextFilePathName("P0", sExt);
        picFile.renameTo(new FileService(sSrcImage));
        int[] pScaleSizes = m_oImageLibConfig.getScaleSizes();
        MagicImageImpl magicImage = new MagicImageImpl();
        try {
            magicImage.initMagicImage(sSrcImage);
        }
        catch (Exception e) {
            throw new WCMException(I18NMessage.get(PhotoImporter.class, "PhotoImporter.label5", "\u521d\u59cb\u5316\u539f\u59cb\u56fe\u7247\u5931\u8d25\uff01[File=") + sSrcImage + "]", e);
        }
        if ("bmp".equalsIgnoreCase(sExt)) {
            String bmp2type = "gif";
            try {
                magicImage.initMagicImage(sSrcImage);
                magicImage.convertImageFormat(bmp2type);
                sSrcImage = magicImage.writeImageToWCMData("W0");
            }
            catch (Exception e) {
                throw new WCMException(I18NMessage.get(PhotoImporter.class, "PhotoImporter.label6", "\u8f6c\u6362\u56fe\u7247[") + sSrcImage + I18NMessage.get(PhotoImporter.class, "PhotoImporter.label7", "]\u4e3a[") + bmp2type + I18NMessage.get(PhotoImporter.class, "PhotoImporter.label8", "]\u5931\u8d25"), e);
            }
        }
        StringBuffer result = new StringBuffer(24 * (pScaleSizes.length + 1));
        try {
            magicImage.scaleImage(75, 75);
            String fn = magicImage.writeImageToWCMData("W0");
            result.append(fn);
            int nWidth = (int)magicImage.getWidth();
            int nHeight = (int)magicImage.getHeight();
            boolean bScaleWidth = nWidth > nHeight;
            int nCurrScale = bScaleWidth ? nWidth : nHeight;
            int nScaleSize = 0;
            int len = pScaleSizes.length;
            for (int i = 1; i < len && (nScaleSize = pScaleSizes[i]) <= nCurrScale; ++i) {
                if (bScaleWidth) {
                    magicImage.scaleImage(nScaleSize, 0);
                } else {
                    magicImage.scaleImage(0, nScaleSize);
                }
                fn = magicImage.writeImageToWCMData("W0");
                result.append(",").append(fn);
            }
        }
        catch (Exception e) {
            throw new WCMException(I18NMessage.get(PhotoImporter.class, "PhotoImporter.label9", "\u7f29\u653e\u56fe\u7247\u5931\u8d25\uff01"), e);
        }
        return result.toString();
    }
}

