/*
 * Decompiled with CFR 0.152.
 */
package com.trs.wcm.photo.impl;

import com.trs.infra.I18NMessage;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.store.FileService;
import com.trs.infra.util.store.FileStore;
import com.trs.infra.util.store.FileWrapper;
import com.trs.wcm.photo.ImageLibConstants;
import java.awt.Dimension;
import java.io.RandomAccessFile;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import magick.CompositeOperator;
import magick.ImageInfo;
import magick.MagickApiException;
import magick.MagickException;
import magick.MagickImage;
import org.apache.log4j.Logger;

public class JImageMarkUtil {
    private static final Logger LOG = Logger.getLogger(JImageMarkUtil.class);
    private static int COMPOSITEOPERATOR_TYPE = 3;

    public static void setCompositeOp(int _nCompositeOp) {
        COMPOSITEOPERATOR_TYPE = _nCompositeOp;
    }

    private static MagickImage addWaterMarkS(ImageInfo src, ImageInfo head_foot, ImageInfo belt, int[] _pPosition) throws MagickApiException, MagickException {
        int opY;
        int opX;
        MagickImage image = new MagickImage(src);
        Dimension imageDim = image.getDimension();
        MagickImage comp_image = new MagickImage(head_foot);
        Dimension dimen = comp_image.getDimension();
        if (JImageMarkUtil.isSelfDefinePosition(_pPosition, ImageLibConstants.MARKPOS_SELF_DEFIND)) {
            Float temp = new Float((float)_pPosition[2] / (float)_pPosition[3] * (float)imageDim.width);
            int opX2 = temp.intValue();
            temp = new Float((float)_pPosition[1] / (float)_pPosition[4] * (float)imageDim.height);
            int opY2 = temp.intValue();
            image.compositeImage(COMPOSITEOPERATOR_TYPE, comp_image, opX2, opY2);
            return image;
        }
        if (JImageMarkUtil.isPostion(_pPosition, ImageLibConstants.MARKPOS_LEFT_TOP)) {
            opX = 0;
            opY = 0;
            image.compositeImage(COMPOSITEOPERATOR_TYPE, comp_image, opX, opY);
        }
        if (JImageMarkUtil.isPostion(_pPosition, ImageLibConstants.MARKPOS_RIGHT_BOTTOM)) {
            opY = imageDim.height - dimen.height;
            opX = imageDim.width - dimen.width;
            image.compositeImage(COMPOSITEOPERATOR_TYPE, comp_image, opX, opY);
        }
        if (JImageMarkUtil.isPostion(_pPosition, ImageLibConstants.MARKPOS_CENTER_MIDDLE)) {
            comp_image = new MagickImage(belt);
            dimen = comp_image.getDimension();
            opX = (imageDim.width - dimen.width) / 2;
            opY = (imageDim.height - dimen.height) / 2;
            image.compositeImage(COMPOSITEOPERATOR_TYPE, comp_image, opX, opY);
        }
        return image;
    }

    private static boolean isSelfDefinePosition(int[] _pPosition, int _nPosition) {
        if (_pPosition == null || _pPosition.length < 5) {
            return false;
        }
        return _pPosition[0] == _nPosition;
    }

    private static boolean isPostion(int[] _pPosition, int _nPosition) {
        if (_pPosition == null) {
            return true;
        }
        for (int i = 0; i < _pPosition.length; ++i) {
            if (_pPosition[i] != _nPosition) continue;
            return true;
        }
        return false;
    }

    private static String createRandomFile(String _sFileExt) throws Exception {
        String sFileName = FilesMan.getFilesMan().getNextFileName("ST", _sFileExt);
        return FilesMan.getFilesMan().mapFilePath(sFileName, 0) + sFileName;
    }

    private static FileStore EmbedVisibleWaterMark(String srcimgfile, String watermark, int[] _pPosition) throws Exception {
        ImageInfo srcinfo = new ImageInfo(srcimgfile);
        ImageInfo imgmark = new ImageInfo(watermark);
        MagickImage m_image = new MagickImage();
        m_image = JImageMarkUtil.addWaterMarkS(srcinfo, imgmark, imgmark, _pPosition);
        String temp = JImageMarkUtil.createRandomFile(CMyFile.extractFileExt(srcimgfile));
        m_image.setFileName(temp);
        m_image.writeImage(srcinfo);
        return new FileService(temp);
    }

    public static synchronized byte[] addImageMark(String _sSrcImageFile, String _sWaterMarkFile) throws Exception {
        return JImageMarkUtil.addImageMark(_sSrcImageFile, _sWaterMarkFile, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized byte[] addImageMark(String _sSrcImageFile, String _sWaterMarkFile, int[] _pPosition) throws Exception {
        if (!CMyFile.fileExists(_sSrcImageFile)) {
            throw new Exception(I18NMessage.get(JImageMarkUtil.class, "JImageMarkUtil.label1", "\u6e90\u56fe\u7247\u4e0d\u5b58\u5728\uff01") + _sSrcImageFile);
        }
        if (!CMyFile.fileExists(_sWaterMarkFile)) {
            throw new Exception(I18NMessage.get(JImageMarkUtil.class, "JImageMarkUtil.label2", "\u6c34\u5370\u56fe\u7247\u4e0d\u5b58\u5728\uff01") + _sWaterMarkFile);
        }
        FileStore src = JImageMarkUtil.EmbedVisibleWaterMark(_sSrcImageFile, _sWaterMarkFile, _pPosition);
        RandomAccessFile readFile = null;
        AbstractInterruptibleChannel fileChannel = null;
        ByteBuffer byteBuffer = null;
        readFile = new RandomAccessFile(new FileWrapper(src), "rw");
        byteBuffer = ByteBuffer.allocate((int)readFile.length());
        fileChannel = readFile.getChannel();
        ((FileChannel)fileChannel).read(byteBuffer);
        if (byteBuffer.hasArray()) {
            byte[] byArray = byteBuffer.array();
            return byArray;
        }
        byte[] byArray = new byte[]{};
        return byArray;
        finally {
            if (src != null) {
                src.delete();
            }
            if (readFile != null) {
                try {
                    readFile.close();
                }
                catch (Exception exception) {}
            }
            if (fileChannel != null) {
                try {
                    fileChannel.close();
                }
                catch (Exception exception) {}
            }
            if (byteBuffer != null) {
                try {
                    byteBuffer.clear();
                }
                catch (Exception exception) {}
            }
        }
    }

    static {
        try {
            Field field;
            String fieldName = ConfigServer.getServer().getInitProperty("PHOTOWATERMARK_COMPOSITEOPERATOR");
            if (fieldName != null && fieldName.trim().length() != 0 && (field = CompositeOperator.class.getField(fieldName)) != null) {
                COMPOSITEOPERATOR_TYPE = field.getInt(null);
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"init COMPOSITEOPERATOR with exception!", (Throwable)e);
        }
    }
}

