/*
 * Decompiled with CFR 0.152.
 */
package com.trs.wcag2.validator;

import com.trs.infra.I18NMessage;
import com.trs.infra.util.CMyString;
import com.trs.wcag2.HTMLUtil;
import com.trs.wcag2.validator.AbstractValidator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class HtmlCharsetValidator
extends AbstractValidator {
    protected String m_sType = I18NMessage.get(HtmlCharsetValidator.class, "HtmlCharsetValidator.label1", "W3C\u89c4\u8303");
    protected Object m_oWarning = I18NMessage.get(HtmlCharsetValidator.class, "HtmlCharsetValidator.label2", "\u9875\u9762\u7684Charset\u5c5e\u6027\u6ca1\u6709\u6307\u5b9a");
    protected String m_oExample = I18NMessage.get(HtmlCharsetValidator.class, "HtmlCharsetValidator.label3", "\u5728Head\u8282\u70b9\u4e2d\u6dfb\u52a0\u63cf\u8ff0charset\u7684meta\u8282\u70b9\uff0c\u4f8b\u5982\uff1a<br>") + "<br>&nbsp;&nbsp;&lt;META content=\"text/html; charset=utf-8\" http-equiv=Content-Type&gt;";

    @Override
    public Object doValid(String content, HashMap known) {
        ArrayList<String[]> rst = new ArrayList<String[]>();
        String eleName = "META";
        int count = 1;
        List tags = HTMLUtil.findTagStartHTML(content, eleName);
        if (tags.size() == 0) {
            return Boolean.FALSE;
        }
        for (int[] pos : tags) {
            String sTagOuterHTML = content.substring(pos[0], pos[1]);
            String sAttrs = HTMLUtil.getEleAttrs(sTagOuterHTML, eleName);
            HashMap hs = HTMLUtil.makeHsAttrs(sAttrs);
            if (!hs.containsKey("http-equiv")) continue;
            String sContentType = CMyString.showNull((String)hs.get("content"));
            if (sContentType.toLowerCase().indexOf("charset") == -1 && count != tags.size()) {
                ++count;
                continue;
            }
            if (sContentType.toLowerCase().indexOf("charset") != -1) continue;
            int[] lenPos = HTMLUtil.getPosition(content.substring(0, pos[0]));
            rst.add(new String[]{String.valueOf(lenPos[0]), String.valueOf(lenPos[1]), sTagOuterHTML});
        }
        if (rst.size() > 0) {
            return rst;
        }
        return Boolean.TRUE;
    }

    @Override
    public Object getWarnObj() {
        return this.m_oWarning;
    }

    @Override
    public String getType() {
        return this.m_sType;
    }

    @Override
    public Object getExampleObj() {
        return this.m_oExample;
    }
}

