/*
 * Decompiled with CFR 0.152.
 */
package com.trs.service.impl;

import com.trs.DreamFactory;
import com.trs.components.infoview.InfoViewConfig;
import com.trs.components.infoview.InfoViewMgr;
import com.trs.components.infoview.config.EnumCreator;
import com.trs.components.infoview.config.EnumsConfig;
import com.trs.components.infoview.config.InfoViewEnumHelper;
import com.trs.components.infoview.config.LinkedEnumCreator;
import com.trs.components.infoview.helper.InfoViewTemplateHelper;
import com.trs.infra.common.WCMException;
import com.trs.service.IInfoViewEnumCreator;
import com.trs.service.InfoViewContext;
import org.apache.log4j.Logger;

public class InfoViewEnumCreatorImpl
implements IInfoViewEnumCreator {
    private static Logger s_logger = Logger.getLogger(InfoViewEnumCreatorImpl.class);
    private InfoViewMgr m_oInfoViewMgr = (InfoViewMgr)DreamFactory.createObjectById("InfoViewMgr");
    private InfoViewConfig m_oInfoViewConfig = this.m_oInfoViewMgr.getInfoViewConfig();

    @Override
    public Object enumScript(InfoViewContext _oContext) throws WCMException {
        LinkedEnumCreator oLinkedCreator;
        int nInfoViewId = _oContext.getInfoViewId();
        StringBuffer sbResult = new StringBuffer();
        EnumsConfig oEnumsConfig = this.m_oInfoViewConfig.getEnumsConfig();
        EnumCreator[] arrCreators = oEnumsConfig.getEnumCreators(nInfoViewId);
        if (arrCreators != null) {
            for (EnumCreator creator : arrCreators) {
                try {
                    String sTemplateContent = InfoViewTemplateHelper.getContent(_oContext.getChannelId(), creator.getTemplateContent(), creator.getCacheKey());
                    String sScript = InfoViewEnumHelper.split2Options(creator.getKey(), sTemplateContent, creator.getSplitBy(), creator.getValueSplitBy());
                    if (sScript == null) continue;
                    sbResult.append(sScript);
                }
                catch (WCMException ex) {
                    s_logger.error((Object)ex);
                }
            }
        }
        if ((oLinkedCreator = oEnumsConfig.getLinkedEnums(nInfoViewId)) != null) {
            try {
                String sTemplateContent = InfoViewTemplateHelper.getContent(_oContext.getChannelId(), oLinkedCreator.getTemplateContent(), oLinkedCreator.getCacheKey());
                String sScript = InfoViewEnumHelper.parseChains2Script(sTemplateContent);
                if (sScript != null) {
                    sbResult.append(sScript);
                }
            }
            catch (WCMException ex) {
                s_logger.error((Object)ex);
            }
        }
        return sbResult.toString();
    }
}

