/*
 * Decompiled with CFR 0.152.
 */
package com.trs.scm.sdk.util;

import com.trs.DreamFactory;
import com.trs.cms.process.ProcessConstants;
import com.trs.cms.process.engine.FlowDoc;
import com.trs.cms.process.engine.FlowDocs;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;
import com.trs.scm.domain.ISCMMicroContentMgr;
import com.trs.scm.persistent.Account;
import com.trs.scm.persistent.SCMGroup;
import com.trs.scm.persistent.SCMMicroContent;
import com.trs.scm.sdk.model.MicroContent;
import com.trs.scm.sdk.model.Platform;
import com.trs.scm.sdk.model.SCMMicroContentAndFlowDoc;
import com.trs.scm.sdk.model.SCMMicroContentAndFlowDocs;
import com.trs.scm.sdk.util.CMyContentTranslate;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.xmlserver.ConvertException;
import com.trs.webframework.xmlserver.IXMLConvertor;
import org.dom4j.CDATA;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class SCMMCAndFlowDocsConvertor
implements IXMLConvertor {
    @Override
    public String toXmlString(MethodContext _methodContext, Object _result) throws ConvertException {
        SCMMicroContentAndFlowDocs tempMicorContents = (SCMMicroContentAndFlowDocs)_result;
        String sObjectsTagName = this.makeTagName(_result.getClass());
        Element rootElement = DocumentHelper.createElement((String)sObjectsTagName);
        if (tempMicorContents == null) {
            return rootElement.asXML();
        }
        for (int i = 0; i < tempMicorContents.getsList().size(); ++i) {
            SCMMicroContentAndFlowDoc tMicrocontent = tempMicorContents.getsList().get(i);
            rootElement = this.parseXML(rootElement, tMicrocontent);
        }
        return rootElement.asXML();
    }

    @Override
    public String[] registerTargetClassName() {
        return new String[]{SCMMicroContentAndFlowDocs.class.getName()};
    }

    private String makeTagName(Class _objectClass) {
        String sObjectsTagName = _objectClass.getName();
        int nPos = sObjectsTagName.lastIndexOf(46);
        if (nPos >= 0) {
            sObjectsTagName = sObjectsTagName.substring(nPos + 1);
        }
        return sObjectsTagName;
    }

    private Element parseXML(Element rootElement, SCMMicroContentAndFlowDoc oMicrocontent) {
        try {
            SCMMicroContent tMicrocontent = oMicrocontent.getoSCMMicroContent();
            if (rootElement == null) {
                return null;
            }
            Element eSCMCheckedMicroContent = rootElement.addElement("SCMCheckedMicroContent");
            Element eSId = eSCMCheckedMicroContent.addElement("MicroContentId");
            CDATA oId = DocumentHelper.createCDATA((String)String.valueOf(tMicrocontent.getId()));
            eSId.add(oId);
            Element eCrTime = eSCMCheckedMicroContent.addElement("MicroCrTime");
            if (!CMyString.isEmpty(CMyDateTime.getStr(tMicrocontent.getCrTime(), "yyyy-MM-dd HH:mm:ss"))) {
                CDATA oAuditTime = DocumentHelper.createCDATA((String)CMyDateTime.getStr(tMicrocontent.getCrTime(), "yyyy-MM-dd HH:mm:ss"));
                eCrTime.add(oAuditTime);
            }
            Element ePubAccounts = eSCMCheckedMicroContent.addElement("PubAccounts");
            String[] sIds = tMicrocontent.getPublishAccountIds().split(",");
            Account oPlatAccount = null;
            for (int i = 0; i < sIds.length; ++i) {
                Element ePubAccount = ePubAccounts.addElement("Account");
                if (CMyString.isEmpty(sIds[i])) continue;
                Account oPubAccount = null;
                try {
                    oPubAccount = Account.findById(Integer.parseInt(sIds[i]));
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
                catch (WCMException e) {
                    e.printStackTrace();
                }
                if (oPubAccount == null || oPubAccount.getStatus() <= 0) continue;
                if (oPlatAccount == null) {
                    oPlatAccount = oPubAccount;
                }
                Element eAccount = ePubAccount.addElement("AccountId");
                CDATA cAccount = DocumentHelper.createCDATA((String)String.valueOf(oPubAccount.getId()));
                eAccount.add(cAccount);
                Element ePubAccountName = ePubAccount.addElement("AccountName");
                CDATA oPubAccountName = DocumentHelper.createCDATA((String)oPubAccount.getAccountName());
                ePubAccountName.add(oPubAccountName);
                Element ePubAccountPlat = ePubAccount.addElement("AccountPlat");
                CDATA oPubAccountPlat = DocumentHelper.createCDATA((String)oPubAccount.getPlatform());
                ePubAccountPlat.add(oPubAccountPlat);
            }
            Element ePubGroupId = eSCMCheckedMicroContent.addElement("PubGroupId");
            ePubGroupId.setText("" + tMicrocontent.getGroupId());
            Element ePubGroupName = eSCMCheckedMicroContent.addElement("PubGroup");
            CDATA oParentPath = null;
            try {
                oParentPath = DocumentHelper.createCDATA((String)SCMGroup.findById(tMicrocontent.getGroupId()).getGroupName());
            }
            catch (WCMException e2) {
                e2.printStackTrace();
            }
            if (oParentPath == null) {
                return rootElement;
            }
            ePubGroupName.add(oParentPath);
            Element eHasReMC = eSCMCheckedMicroContent.addElement("HasReMC");
            CDATA oHasReMC = DocumentHelper.createCDATA((String)String.valueOf(tMicrocontent.isRetweeted()));
            eHasReMC.add(oHasReMC);
            Element eAuditStatus = eSCMCheckedMicroContent.addElement("AuditStatus");
            CDATA oAuditStatus = DocumentHelper.createCDATA((String)("" + tMicrocontent.getStatusId()));
            eAuditStatus.add(oAuditStatus);
            Element eAuthor = eSCMCheckedMicroContent.addElement("MicroAuthor");
            CDATA oAuthor = DocumentHelper.createCDATA((String)tMicrocontent.getCrUserName());
            eAuthor.add(oAuthor);
            Element eSCMMicroContent = eSCMCheckedMicroContent.addElement("SCMMicroContent");
            Element eContent = eSCMMicroContent.addElement("Content");
            CDATA oContent = DocumentHelper.createCDATA((String)tMicrocontent.getContent());
            eContent.add(oContent);
            Element eIMG = eSCMMicroContent.addElement("IMG");
            CDATA oIMG = DocumentHelper.createCDATA((String)tMicrocontent.getPicture());
            eIMG.add(oIMG);
            if (tMicrocontent.isRetweeted()) {
                String sMicroContentId = tMicrocontent.getRetweetedID();
                ISCMMicroContentMgr m_oSCMMicroContentMgr = (ISCMMicroContentMgr)DreamFactory.createObjectById("ISCMMicroContentMgr");
                MicroContent oMicroResult = null;
                try {
                    oMicroResult = m_oSCMMicroContentMgr.findById(oPlatAccount, sMicroContentId);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
                if (oMicroResult == null) {
                    return rootElement;
                }
                MicroContent tempMicor = oMicroResult;
                Element microContentElement = eSCMMicroContent.addElement("ReMicroContent");
                Element eId = microContentElement.addElement("MicroContentId");
                eId.setText(tempMicor.getId());
                Element eCon = microContentElement.addElement("CONTENT");
                CDATA oCdata = null;
                String sContent = "";
                try {
                    int nStartIndex;
                    String _plat = Platform.SinaPlatFormName;
                    if (oPlatAccount != null) {
                        _plat = oPlatAccount.getPlatform();
                    }
                    sContent = CMyContentTranslate.microContentTranslate(tempMicor.getContent(), _plat, true);
                    if (_plat.equals(Platform.T163PlatFormName) && (nStartIndex = sContent.indexOf("!#T163#!")) > 0) {
                        String sContentParams = sContent.substring(nStartIndex + 8, sContent.length() - 1);
                        sContent = sContent.substring(0, nStartIndex);
                        String[] pParams = sContentParams.split("!#T163#!");
                        tempMicor.setThumbnailPic(pParams[0]);
                        tempMicor.setBmiddlePic(pParams[1]);
                        tempMicor.setOriginalPic(pParams[1]);
                    }
                    oCdata = DocumentHelper.createCDATA((String)sContent);
                }
                catch (WCMException e) {
                    e.printStackTrace();
                }
                eCon.add(oCdata);
                Element eThumPic = microContentElement.addElement("ThumbnailPic");
                if (!CMyString.isEmpty(tempMicor.getThumbnailPic())) {
                    CDATA oThumCdata = DocumentHelper.createCDATA((String)tempMicor.getThumbnailPic());
                    eThumPic.add(oThumCdata);
                }
                Element eMiPic = microContentElement.addElement("BmiddlePic");
                if (!CMyString.isEmpty(tempMicor.getBmiddlePic())) {
                    CDATA oBmiCdata = DocumentHelper.createCDATA((String)tempMicor.getBmiddlePic());
                    eMiPic.add(oBmiCdata);
                }
                Element eOrigPic = microContentElement.addElement("OriginalPic");
                if (!CMyString.isEmpty(tempMicor.getOriginalPic())) {
                    CDATA oOrigCdata = DocumentHelper.createCDATA((String)tempMicor.getOriginalPic());
                    eOrigPic.add(oOrigCdata);
                }
                Element eCommentCount = microContentElement.addElement("CommentCount");
                eCommentCount.setText(Integer.valueOf(tempMicor.getCommentCount()).toString());
                Element eRepostCount = microContentElement.addElement("RepostCount");
                eRepostCount.setText(Integer.valueOf(tempMicor.getRepostCount()).toString());
                Element eSOURCE = microContentElement.addElement("Source");
                String sSour = tempMicor.getSource();
                sSour = sSour.replaceAll("<a.*href[^>]*>", "");
                sSour = sSour.replaceAll("</a>", "");
                CDATA oSourceData = DocumentHelper.createCDATA((String)sSour);
                eSOURCE.add(oSourceData);
                Element eMicroUser = microContentElement.addElement("MicroUser");
                Element eUserName = eMicroUser.addElement("UserName");
                CDATA oUserNameData = DocumentHelper.createCDATA((String)tempMicor.getUser().getName());
                eUserName.add(oUserNameData);
                Element eUserHeadPic = eMicroUser.addElement("UserHeadPic");
                CDATA oUserPicData = DocumentHelper.createCDATA((String)tempMicor.getUser().getHead());
                eUserHeadPic.add(oUserPicData);
                Element eISRETWEETED = microContentElement.addElement("IsRetweeted");
                eISRETWEETED.setText(Boolean.valueOf(tempMicor.isRetweeted()).toString());
                Element eFavorited = microContentElement.addElement("IsFavorited");
                eFavorited.setText(Boolean.valueOf(tempMicor.isFavorited()).toString());
                Element eTruncated = microContentElement.addElement("IsTruncated");
                eTruncated.setText(Boolean.valueOf(tempMicor.isTruncated()).toString());
                Element eCreateDate = microContentElement.addElement("IsCreateDate");
                try {
                    eCreateDate.setText(CMyDateTime.getStr(tempMicor.getCreateDate(), "yyyy-MM-dd HH:mm:ss"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            Element eFlowdocs = eSCMCheckedMicroContent.addElement("FlowDocs");
            FlowDocs Flowdocs = oMicrocontent.getoFlowDocs();
            if (Flowdocs != null) {
                for (int i = 0; i < Flowdocs.size(); ++i) {
                    Element eFlowdoc = eFlowdocs.addElement("Flowdoc");
                    FlowDoc oFlowdoc = (FlowDoc)Flowdocs.getAt(i);
                    Element ePostTime = eFlowdoc.addElement("PostTime");
                    CDATA ePostTimeC = DocumentHelper.createCDATA((String)oFlowdoc.getPostTime().toString());
                    ePostTime.add(ePostTimeC);
                    Element eFlowdocId = eFlowdoc.addElement("FlowdocId");
                    CDATA eFlowdocC = DocumentHelper.createCDATA((String)String.valueOf(oFlowdoc.getId()));
                    eFlowdocId.add(eFlowdocC);
                    Element ePostUser = eFlowdoc.addElement("PostUserName");
                    CDATA ePostUserC = DocumentHelper.createCDATA((String)oFlowdoc.getPostUserName());
                    ePostUser.add(ePostUserC);
                    Element ePostUserID = eFlowdoc.addElement("PostUserId");
                    if (oFlowdoc.getPostUser() != null) {
                        CDATA cPostUserID = DocumentHelper.createCDATA((String)("" + oFlowdoc.getPostUser().getId()));
                        ePostUserID.add(cPostUserID);
                    }
                    Element ePostDesc = eFlowdoc.addElement("PostDesc");
                    if (i != Flowdocs.size() - 1) {
                        CDATA oPostUserC = DocumentHelper.createCDATA((String)oFlowdoc.getPostDesc());
                        ePostDesc.add(oPostUserC);
                    }
                    Element eOperateDesc = eFlowdoc.addElement("OperateDesc");
                    String sOperateDesc = null;
                    sOperateDesc = i == Flowdocs.size() - 1 ? oFlowdoc.getPostDesc() : ProcessConstants.getFlagDesc(oFlowdoc.getFlag());
                    CDATA oOperateDesc = DocumentHelper.createCDATA((String)sOperateDesc);
                    eOperateDesc.add(oOperateDesc);
                }
            }
            return rootElement;
        }
        catch (Exception e) {
            e.printStackTrace();
            return rootElement;
        }
    }
}

