/*
 * Decompiled with CFR 0.152.
 */
package com.trs.scm.sdk.util;

import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.store.FileService;
import com.trs.scm.sdk.util.SynchronousHTMLEditorKit;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JEditorPane;
import org.apache.log4j.Logger;

public class ImageGenerator {
    private static Logger m_logger = Logger.getLogger(ImageGenerator.class);
    private int nWidth = 500;
    private int nHeight = 4000;
    private String sExtendSuffix = "png";
    private String sImageDir = "./image";
    private String sImageName = "htmltoimage";
    private BufferedImage image;
    private String sHtml;

    public int getWidth() {
        return this.nWidth;
    }

    public void setWidth(int width) {
        this.nWidth = width;
    }

    public void setHeight(int height) {
        this.nHeight = height;
    }

    public String getExtendSuffix() {
        return this.sExtendSuffix;
    }

    public void setExtendSuffix(String extendSuffix) {
        this.sExtendSuffix = extendSuffix;
    }

    public String getImageDir() {
        return this.sImageDir;
    }

    public void setImageDir(String desImageDir) {
        this.sImageDir = desImageDir;
    }

    public String getImageName() {
        return this.sImageName;
    }

    public void setImageName(String imageName) {
        this.sImageName = imageName;
    }

    public void setImageNameAndSuffix(String _sImageName) {
        String[] strs = _sImageName.split("\\.");
        this.sImageName = strs[0];
        this.sExtendSuffix = strs[1];
    }

    public BufferedImage getImage() {
        if (this.image == null) {
            m_logger.error((Object)"\u56fe\u7247\u8fd8\u6ca1\u6709\u751f\u6210\uff0c\u8bf7\u5148\u4f7f\u7528CreateImage\uff08\uff09\u51fd\u6570\u751f\u6210\u56fe\u7247");
        }
        return this.image;
    }

    public String getHtml() {
        return this.sHtml;
    }

    public void setHtml(String html) throws Exception {
        try {
            this.sHtml = html;
        }
        catch (Exception e) {
            m_logger.error((Object)"\u683c\u5f0f\u5316html\u65f6\u51fa\u73b0\u4e86\u9519\u8bef", (Throwable)e);
            throw e;
        }
    }

    public void setHtmlByPath(String htmlFilePath) throws Exception {
        this.setHtmlByPath(htmlFilePath, "utf-8");
    }

    public void setHtmlByPath(String htmlFilePath, String encode) throws Exception {
        String sHtml = CMyFile.readFile(htmlFilePath, encode);
        this.setHtml(sHtml);
    }

    public void cutImage() {
        int oldWidth = this.image.getWidth();
        int oldHeight = this.image.getHeight();
        int newHeight = 0;
        int defaultColor = this.image.getRGB(oldWidth - 1, oldHeight - 1);
        for (int heightindex = this.image.getHeight() - 1; heightindex >= 0; --heightindex) {
            for (int widthindex = this.image.getWidth() - 1; widthindex >= 0; --widthindex) {
                if (this.image.getRGB(widthindex, heightindex) == defaultColor) continue;
                newHeight = heightindex;
                break;
            }
            if (newHeight != 0) break;
        }
        newHeight = newHeight + 20 > oldHeight ? oldHeight : newHeight + 20;
        this.image = this.image.getSubimage(0, 0, this.image.getWidth() - 1, newHeight);
    }

    public void SaveImage() throws IOException {
        FileService iMageDir = new FileService(this.sImageDir);
        if (!iMageDir.exists()) {
            iMageDir.mkdirs();
        }
        FileService desFile = new FileService(this.sImageDir, this.sImageName + "." + this.sExtendSuffix);
        ImageIO.write((RenderedImage)this.image, this.sExtendSuffix, desFile.getOutputStream());
    }

    public void CreateImage() throws Exception {
        try {
            this.image = new BufferedImage(this.nWidth, this.nHeight, 1);
            JEditorPane editorPane = new JEditorPane();
            editorPane.setEditable(false);
            SynchronousHTMLEditorKit kit = new SynchronousHTMLEditorKit();
            editorPane.setEditorKitForContentType("text/html", kit);
            editorPane.setContentType("text/html");
            editorPane.setText(this.sHtml);
            Graphics2D graphics = this.image.createGraphics();
            editorPane.setSize(this.nWidth, this.nHeight);
            editorPane.print(graphics);
        }
        catch (Exception e) {
            throw new WCMException("\u751f\u6210\u56fe\u7247\u51fa\u9519", e);
        }
    }
}

