/*
 * Decompiled with CFR 0.152.
 */
package com.trs.scm.sdk.impl;

import com.trs.infra.util.CMyException;
import com.trs.infra.util.store.FileService;
import com.trs.scm.sdk.impl.AbstractMicroContentMgr;
import com.trs.scm.sdk.model.Count;
import com.trs.scm.sdk.model.ExtraParams;
import com.trs.scm.sdk.model.MicroContent;
import com.trs.scm.sdk.model.MicroContentWrapper;
import com.trs.scm.sdk.model.OAuth;
import com.trs.scm.sdk.model.SinaErrorMessage;
import com.trs.scm.sdk.util.CMyContentTranslate;
import com.trs.scm.sdk.util.SinaObjectUtil;
import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import weibo4j.Timeline;
import weibo4j.Weibo;
import weibo4j.http.HttpClient;
import weibo4j.http.ImageItem;
import weibo4j.http.Response;
import weibo4j.model.Paging;
import weibo4j.model.PostParameter;
import weibo4j.model.Status;
import weibo4j.model.StatusWapper;
import weibo4j.model.WeiboException;
import weibo4j.org.json.JSONArray;
import weibo4j.org.json.JSONException;
import weibo4j.org.json.JSONObject;
import weibo4j.util.WeiboConfig;

public class SinaMicroContentMgr
extends AbstractMicroContentMgr {
    private static Logger logger = Logger.getLogger(SinaMicroContentMgr.class);
    private Weibo m_oWeibo = new Weibo();
    private Timeline m_oTimeline;
    private static final int MAX_UPLOAD_PICS_COUNTS_SINA = 9;

    public SinaMicroContentMgr(OAuth auth) {
        super(auth);
        this.m_oWeibo.setToken(this.m_oOAuth.getOAuth_token());
        this.m_oTimeline = new Timeline();
        this.m_oTimeline.setToken(this.m_oOAuth.getOAuth_token());
    }

    @Override
    public MicroContent createMicroContent(String content, ExtraParams extraParams) throws Exception {
        String sTempContent = CMyContentTranslate.microContentUrlShortLength(content);
        this.checkContentLength(sTempContent);
        Status oSinaStatus = null;
        try {
            oSinaStatus = this.m_oTimeline.UpdateStatus(content);
        }
        catch (Exception e) {
            CMyException oCMyException = SinaErrorMessage.getCMyException(e);
            throw oCMyException;
        }
        MicroContent oResult = null;
        try {
            oResult = SinaObjectUtil.constructMicroContent(oSinaStatus);
        }
        catch (Exception _oException) {
            logger.error((Object)"\u6784\u9020MicroContent\u629b\u51fa\u5f02\u5e38\uff01");
            throw new Exception("\u6784\u9020MicroContent\u629b\u51fa\u5f02\u5e38\uff01", _oException);
        }
        return oResult;
    }

    @Override
    public MicroContent createMicroContent(String content, String picPaths, ExtraParams extraParams) throws Exception {
        String sTempContent = CMyContentTranslate.microContentUrlShortLength(content);
        this.checkContentLength(sTempContent);
        String[] sPicPathArray = picPaths.split(",");
        int len = sPicPathArray.length;
        for (int i = 0; i < len && i < 9; ++i) {
            this.isPicLegal(sPicPathArray[i]);
        }
        StringBuffer sbPicIds = new StringBuffer();
        int sPicPathArrayLenth = sPicPathArray.length;
        for (int j = 0; j < sPicPathArrayLenth && j < 9; ++j) {
            String picPath = sPicPathArray[j];
            BufferedInputStream oBufferedInputStream = null;
            int len2 = 0;
            int nReadLen = 0;
            byte[] PicFileContentBytes = null;
            try {
                oBufferedInputStream = new BufferedInputStream(new FileService(picPath).getInputStream());
                len2 = oBufferedInputStream.available();
                PicFileContentBytes = new byte[len2];
                nReadLen = oBufferedInputStream.read(PicFileContentBytes);
                if (len2 != nReadLen) {
                    PicFileContentBytes = null;
                    logger.error((Object)("\u8bfb\u53d6\u56fe\u7247\u6587\u4ef6\u4e0d\u6b63\u786e\uff01 " + picPath));
                    throw new IOException("\u8bfb\u53d6\u56fe\u7247\u6587\u4ef6\u4e0d\u6b63\u786e\uff01");
                }
            }
            catch (FileNotFoundException _oFileException) {
                logger.error((Object)("\u56fe\u7247\u6587\u4ef6\u6ca1\u6709\u627e\u5230\uff01" + picPath));
                throw _oFileException;
            }
            catch (IOException _oIOException) {
                logger.error((Object)_oIOException.getStackTrace());
                throw new IOException("\u56fe\u7247\u6587\u4ef6\u64cd\u4f5c\u5f02\u5e38\uff01" + picPath);
            }
            finally {
                if (oBufferedInputStream != null) {
                    try {
                        oBufferedInputStream.close();
                    }
                    catch (IOException ioe) {
                        logger.error((Object)ioe.getStackTrace());
                    }
                }
            }
            ImageItem oImageItem = null;
            try {
                oImageItem = new ImageItem("pic", PicFileContentBytes);
                JSONObject oJsonbject = this.uploadPic(oImageItem);
                String sPicId = oJsonbject.getString("pic_id");
                sbPicIds.append(sPicId);
                if (j == sPicPathArrayLenth - 1) continue;
                sbPicIds.append(",");
                continue;
            }
            catch (Exception _oWeiboException) {
                CMyException oCMyException = SinaErrorMessage.getCMyException(_oWeiboException);
                logger.error((Object)oCMyException.getMyMessage());
                throw oCMyException;
            }
        }
        float fLatitude = extraParams.getParamAsFloat("lat", 0.0f);
        float fLongitude = extraParams.getParamAsFloat("long", 0.0f);
        Status oSinaStatus = null;
        StringBuffer sbPicId = new StringBuffer();
        try {
            oSinaStatus = this.uploadStatusContainPics(content, sbPicIds.toString(), Float.valueOf(fLatitude), Float.valueOf(fLongitude));
        }
        catch (Exception e) {
            CMyException oCMyException = SinaErrorMessage.getCMyException(e);
            throw oCMyException;
        }
        MicroContent oResult = null;
        try {
            oResult = SinaObjectUtil.constructMicroContent(oSinaStatus);
        }
        catch (Exception _oException) {
            logger.error((Object)"\u521b\u5efaMicroContent\u9519\u8bef\uff01");
            throw new Exception("\u521b\u5efaMicroContent\u9519\u8bef\uff01", _oException);
        }
        return oResult;
    }

    @Override
    public boolean destroyMicroContent(String id) throws Exception {
        if (id == null || id.length() < 1) {
            throw new NullPointerException("\u8f93\u5165\u5fae\u535aID\u4e3a\u7a7a\uff01");
        }
        Status oSinaStatus = null;
        try {
            oSinaStatus = this.m_oTimeline.Destroy(id);
        }
        catch (Exception _oWeiboException) {
            CMyException oCMyException = SinaErrorMessage.getCMyException(_oWeiboException);
            logger.error((Object)oCMyException.getMyMessage());
            throw oCMyException;
        }
        return oSinaStatus != null;
    }

    @Override
    public MicroContentWrapper getHomeTimeline(int pageIndex, int pageSize, ExtraParams extraParams) throws Exception {
        Paging page = SinaObjectUtil.constructSinaPaging(pageIndex, pageSize, extraParams);
        int base_app = extraParams.getParamAsInt("base_app", 0);
        int feature = extraParams.getParamAsInt("feature", 0);
        StatusWapper oSinaStatusWapper = null;
        try {
            oSinaStatusWapper = this.m_oTimeline.getHomeTimeline(Integer.valueOf(base_app), Integer.valueOf(feature), page);
        }
        catch (WeiboException _oWeiboException) {
            int nTimeOut;
            if (_oWeiboException.getErrorCode() == -1 && (nTimeOut = extraParams.getParamAsInt("TimeOut", 0)) < 3) {
                extraParams.setParam("TimeOut", nTimeOut + 1);
                Thread.currentThread();
                Thread.sleep(300L);
                return this.getHomeTimeline(pageIndex, pageSize, extraParams);
            }
            CMyException oCMyException = SinaErrorMessage.getCMyException((Exception)((Object)_oWeiboException));
            logger.error((Object)oCMyException.getMyMessage());
            throw oCMyException;
        }
        catch (Exception e) {
            CMyException oCMyException = SinaErrorMessage.getCMyException(e);
            logger.error((Object)oCMyException.getMyMessage());
            throw oCMyException;
        }
        MicroContentWrapper oResult = null;
        try {
            oResult = SinaObjectUtil.constructMicroContentWrapper(oSinaStatusWapper);
        }
        catch (Exception _oException) {
            logger.error((Object)"\u521b\u5efaMicroContentWrapper\u9519\u8bef\uff01");
            throw new Exception("\u521b\u5efaMicroContentWrapper\u9519\u8bef\uff01", _oException);
        }
        return oResult;
    }

    @Override
    public MicroContentWrapper getUserTimeline(int pageIndex, int pageSize, ExtraParams extraParams) throws Exception {
        String sUID = extraParams.getParamAsString("UserId");
        Paging page = null;
        if (pageSize < 1 || pageSize > 200) {
            throw new Exception("\u8f93\u5165\u7684\u9875\u9762\u5927\u5c0f\u4e0d\u7b26\u5408\u8981\u6c42\uff01\u9875\u9762\u5927\u5c0f\u8303\u56f4\u4e3a\uff1a1-200\u3002");
        }
        int nPageIndex = pageIndex;
        int nPageSize = pageSize;
        if (pageIndex < 1) {
            nPageIndex = 1;
        }
        page = new Paging(nPageIndex, nPageSize);
        int base_app = extraParams.getParamAsInt("base_app", 0);
        int feature = extraParams.getParamAsInt("feature", 0);
        StatusWapper oSinaStatusWapper = null;
        try {
            oSinaStatusWapper = this.m_oTimeline.getUserTimelineByUid(sUID, page, Integer.valueOf(base_app), Integer.valueOf(feature));
        }
        catch (WeiboException _oWeiboException) {
            int nTimeOut;
            if (_oWeiboException.getErrorCode() == -1 && (nTimeOut = extraParams.getParamAsInt("TimeOut", 0)) < 3) {
                extraParams.setParam("TimeOut", nTimeOut + 1);
                Thread.currentThread();
                Thread.sleep(300L);
                return this.getUserTimeline(nPageIndex, nPageSize, extraParams);
            }
            CMyException oCMyException = SinaErrorMessage.getCMyException((Exception)((Object)_oWeiboException));
            logger.error((Object)oCMyException.getMyMessage());
            throw oCMyException;
        }
        catch (Exception e) {
            CMyException oCMyException = SinaErrorMessage.getCMyException(e);
            logger.error((Object)oCMyException.getMyMessage());
            throw oCMyException;
        }
        MicroContentWrapper oResult = null;
        try {
            oResult = SinaObjectUtil.constructMicroContentWrapper(oSinaStatusWapper);
        }
        catch (Exception _oException) {
            logger.error((Object)"\u521b\u5efaMicroContentWrapper\u9519\u8bef\uff01", (Throwable)_oException);
            throw new Exception("\u521b\u5efaMicroContentWrapper\u9519\u8bef\uff01", _oException);
        }
        return oResult;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public MicroContentWrapper getUserTimelineByType(int type, int pageIndex, int pageSize, ExtraParams extraParams) throws Exception {
        if (type != 0) {
            if (type != 1) {
                if (type != 2) {
                    throw new Exception("\u8f93\u5165\u7684\u67e5\u8be2\u7c7b\u578b\u9519\u8bef\uff01\u8bf7\u91cd\u65b0\u8f93\u5165\uff1a\uff08\u5168\u90e8 0\u3001\u539f\u521b 1 \u3001\u8f6c\u53d1 2\uff09\u3002");
                }
            }
        }
        sUID = extraParams.getParamAsString("UserId");
        page = null;
        if (pageSize < 1 || pageSize > 200) {
            throw new Exception("\u8f93\u5165\u7684\u9875\u9762\u5927\u5c0f\u4e0d\u7b26\u5408\u8981\u6c42\uff01\u9875\u9762\u5927\u5c0f\u8303\u56f4\u4e3a\uff1a1-200\u3002");
        }
        nPageIndex = pageIndex;
        nPageSize = pageSize;
        if (pageIndex < 1) {
            nPageIndex = 1;
        }
        page = new Paging(nPageIndex, nPageSize);
        base_app = extraParams.getParamAsInt("base_app", 0);
        feature = extraParams.getParamAsInt("feature", 0);
        oSinaStatusWapper = null;
        try {
            if (type == 0) ** GOTO lbl-1000
            if (type == 1) lbl-1000:
            // 2 sources

            {
                oSinaStatusWapper = this.m_oTimeline.getUserTimelineByUid(sUID, page, Integer.valueOf(base_app), Integer.valueOf(type));
            } else {
                oSinaStatusWapper = this.m_oTimeline.getRepostByMe(page);
            }
        }
        catch (WeiboException _oWeiboException) {
            if (_oWeiboException.getErrorCode() == -1 && (nTimeOut = extraParams.getParamAsInt("TimeOut", 0)) < 3) {
                extraParams.setParam("TimeOut", nTimeOut + 1);
                Thread.currentThread();
                Thread.sleep(300L);
                return this.getUserTimelineByType(type, nPageIndex, nPageSize, extraParams);
            }
            oCMyException = SinaErrorMessage.getCMyException((Exception)_oWeiboException);
            SinaMicroContentMgr.logger.error((Object)oCMyException.getMyMessage());
            throw oCMyException;
        }
        catch (Exception e) {
            oCMyException = SinaErrorMessage.getCMyException(e);
            SinaMicroContentMgr.logger.error((Object)oCMyException.getMyMessage());
            throw oCMyException;
        }
        oResult = null;
        try {
            oResult = SinaObjectUtil.constructMicroContentWrapper(oSinaStatusWapper);
        }
        catch (Exception _oException) {
            SinaMicroContentMgr.logger.error((Object)"\u521b\u5efaMicroContentWrapper\u9519\u8bef\uff01");
            throw new Exception("\u521b\u5efaMicroContentWrapper\u9519\u8bef\uff01", _oException);
        }
        return oResult;
    }

    @Override
    public MicroContent repostMicroContent(String content, String id, ExtraParams extraParams) throws Exception {
        if (content.length() > 280) {
            throw new Exception("\u8f93\u5165\u7684\u5fae\u535a\u5185\u5bb9\u8fc7\u957f\uff01\u5fae\u535a\u5185\u5bb9\u4e0d\u80fd\u8d85\u8fc7140\u4e2a\u5b57\uff01");
        }
        if (id == null || id.length() < 1) {
            throw new Exception("\u8f93\u5165\u5fae\u535aID\u4e3a\u7a7a\uff01");
        }
        int is_comment = extraParams.getParamAsInt("is_comment", 0);
        Status oSinaStatus = null;
        try {
            oSinaStatus = this.m_oTimeline.Repost(id, content, Integer.valueOf(is_comment));
        }
        catch (Exception e) {
            CMyException oCMyException = SinaErrorMessage.getCMyException(e);
            if (20032 != oCMyException.getErrNo()) {
                throw oCMyException;
            }
            logger.info((Object)"\u3010\u63d0\u793a\u3011\uff1a\u53d1\u5e03\u6210\u529f\uff0c\u76ee\u524d\u65b0\u6d6a\u670d\u52a1\u5668\u53ef\u80fd\u4f1a\u6709\u5ef6\u8fdf\uff0c\u8bf7\u8010\u5fc3\u7b49\u5f851-2\u5206\u949f");
        }
        MicroContent oResult = null;
        try {
            oResult = SinaObjectUtil.constructMicroContent(oSinaStatus);
        }
        catch (Exception _oException) {
            logger.error((Object)"\u6784\u9020MicroContent\u629b\u51fa\u5f02\u5e38\uff01");
            throw new Exception("\u6784\u9020MicroContent\u629b\u51fa\u5f02\u5e38\uff01", _oException);
        }
        return oResult;
    }

    @Override
    public MicroContent findById(String id) throws Exception {
        if (id == null || id.length() < 1) {
            throw new Exception("\u8f93\u5165\u5fae\u535aID\u4e3a\u7a7a\uff01");
        }
        Status oSinaStatus = null;
        try {
            oSinaStatus = this.m_oTimeline.showStatus(id);
        }
        catch (Exception _oWeiboException) {
            CMyException oCMyException = SinaErrorMessage.getCMyException(_oWeiboException);
            logger.error((Object)oCMyException.getMyMessage());
            throw oCMyException;
        }
        MicroContent oResult = null;
        try {
            oResult = SinaObjectUtil.constructMicroContent(oSinaStatus);
        }
        catch (Exception _oException) {
            logger.error((Object)"\u6784\u9020MicroContent\u629b\u51fa\u5f02\u5e38\uff01");
            throw new Exception("\u6784\u9020MicroContent\u629b\u51fa\u5f02\u5e38\uff01", _oException);
        }
        return oResult;
    }

    @Override
    public MicroContentWrapper getMentions(int pageIndex, int pageSize, ExtraParams extraParams) throws Exception {
        Paging page = SinaObjectUtil.constructSinaPaging(pageIndex, pageSize, extraParams);
        int filter_by_author = extraParams.getParamAsInt("filter_by_author", 0);
        int filter_by_source = extraParams.getParamAsInt("filter_by_source", 0);
        int filter_by_type = extraParams.getParamAsInt("filter_by_type", 0);
        StatusWapper oSinaStatusWapper = null;
        try {
            oSinaStatusWapper = this.m_oTimeline.getMentions(page, Integer.valueOf(filter_by_author), Integer.valueOf(filter_by_source), Integer.valueOf(filter_by_type));
        }
        catch (WeiboException _oWeiboException) {
            int nTimeOut;
            if (_oWeiboException.getErrorCode() == -1 && (nTimeOut = extraParams.getParamAsInt("TimeOut", 0)) < 3) {
                extraParams.setParam("TimeOut", nTimeOut + 1);
                Thread.currentThread();
                Thread.sleep(300L);
                return this.getMentions(pageIndex, pageSize, extraParams);
            }
            CMyException oCMyException = SinaErrorMessage.getCMyException((Exception)((Object)_oWeiboException));
            logger.error((Object)oCMyException.getMyMessage());
            throw oCMyException;
        }
        catch (Exception e) {
            CMyException oCMyException = SinaErrorMessage.getCMyException(e);
            logger.error((Object)oCMyException.getMyMessage());
            throw oCMyException;
        }
        MicroContentWrapper oResult = null;
        try {
            oResult = SinaObjectUtil.constructMicroContentWrapper(oSinaStatusWapper);
        }
        catch (Exception _oException) {
            logger.error((Object)"\u521b\u5efaMicroContentWrapper\u9519\u8bef\uff01");
            throw new Exception("\u521b\u5efaMicroContentWrapper\u9519\u8bef\uff01", _oException);
        }
        return oResult;
    }

    @Override
    public Map<String, Count> getCount(String ids) throws Exception {
        int nIDListLen = ids.split(",").length;
        if (ids == null || ids.length() < 1) {
            throw new NullPointerException("\u8f93\u5165\u7684\u5fae\u535aID\u5217\u8868\u4e3a\u7a7a\uff01");
        }
        if (nIDListLen > 50) {
            throw new ArrayIndexOutOfBoundsException("\u8f93\u5165\u7684\u5fae\u535aID\u5217\u8868\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc750\uff01");
        }
        Response oSinaRespons = null;
        try {
            oSinaRespons = this.m_oWeibo.client.get(WeiboConfig.getValue((String)"baseURL") + "statuses/count.json", new PostParameter[]{new PostParameter("ids", ids)});
        }
        catch (Exception _oWeiboException) {
            CMyException oCMyException = SinaErrorMessage.getCMyException(_oWeiboException);
            logger.error((Object)oCMyException.getMyMessage());
            throw oCMyException;
        }
        JSONArray oJSONArray = null;
        try {
            oJSONArray = oSinaRespons.asJSONArray();
        }
        catch (Exception _oWeiboException) {
            CMyException oCMyException = SinaErrorMessage.getCMyException(_oWeiboException);
            logger.error((Object)oCMyException.getMyMessage());
            throw oCMyException;
        }
        int nJSONArrayLen = oJSONArray.length();
        if (nJSONArrayLen != nIDListLen) {
            logger.debug((Object)"\u83b7\u53d6\u5230\u7684JSONArray\u7a0b\u5ea6\u4e0e\u8f93\u5165\u7684weiboID\u5217\u8868\u957f\u5ea6\u4e0d\u4e00\u81f4\uff0c\u53ef\u80fd\u5b58\u5728\u975e\u6cd5\u5fae\u535aID");
        }
        HashMap<String, Count> oResultsMap = new HashMap<String, Count>();
        JSONObject oJSONObject = null;
        Count oMicroCount = null;
        String sID = "";
        long lComments = 0L;
        long lReposts = 0L;
        for (int i = 0; i < nJSONArrayLen; ++i) {
            try {
                oJSONObject = (JSONObject)oJSONArray.get(i);
                sID = oJSONObject.getString("id");
                lComments = oJSONObject.getLong("comments");
                lReposts = oJSONObject.getLong("reposts");
            }
            catch (JSONException _oJsonException) {
                logger.error((Object)_oJsonException.getMessage());
                throw _oJsonException;
            }
            oMicroCount = new Count(sID, lComments, lReposts);
            oResultsMap.put(sID, oMicroCount);
        }
        return oResultsMap;
    }

    private String toUTF8(String sContent) {
        Pattern p = Pattern.compile("[^\\x00-\\xff]+");
        Matcher m = p.matcher(sContent);
        ArrayList<String> result = new ArrayList<String>();
        while (m.find()) {
            result.add(m.group());
        }
        if (result.size() > 0) {
            for (int i = 0; i < result.size(); ++i) {
                if (result.get(i) == null) continue;
                try {
                    sContent = sContent.replaceFirst((String)result.get(i), URLEncoder.encode((String)result.get(i), "utf-8"));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    break;
                }
            }
        }
        return sContent;
    }

    public JSONObject uploadPic(ImageItem imageItem) {
        if (imageItem == null) {
            logger.error((Object)("\u56fe\u7247\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a,imageItem=" + imageItem));
            return null;
        }
        String sUploadPicUrl = WeiboConfig.getValue((String)"baseURL") + "statuses/upload_pic.json";
        HttpClient httpClient = new HttpClient();
        httpClient.setToken(this.m_oOAuth.getOAuth_token());
        PostParameter[] postParameters = new PostParameter[]{};
        Response response = null;
        try {
            response = httpClient.multPartURL(sUploadPicUrl, postParameters, imageItem);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("\u65b0\u6d6a\u8fd4\u56de\u7684\u539f\u59cb\u6570\u636e\u662f\uff1a" + response));
            }
        }
        catch (WeiboException e) {
            logger.error((Object)e);
        }
        if (response != null) {
            try {
                return response.asJSONObject();
            }
            catch (WeiboException e) {
                logger.error((Object)e);
            }
        }
        return null;
    }

    public Status uploadStatusContainPics(String status, String pic_ids, Float lat, Float longs) {
        String sUploadStatusContainPicsUrl = WeiboConfig.getValue((String)"baseURL") + "statuses/upload_url_text.json ";
        HttpClient httpClient = new HttpClient();
        httpClient.setToken(this.m_oOAuth.getOAuth_token());
        PostParameter[] postParameters = new PostParameter[]{new PostParameter("lat", lat.toString()), new PostParameter("long", longs.toString()), new PostParameter("pic_id", pic_ids), new PostParameter("status", status)};
        Response response = null;
        try {
            response = httpClient.post(sUploadStatusContainPicsUrl, postParameters);
        }
        catch (WeiboException e) {
            e.printStackTrace();
        }
        if (response != null) {
            try {
                return new Status(response);
            }
            catch (WeiboException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

