/*
 * Decompiled with CFR 0.152.
 */
package com.trs.scm.domain.impl;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMy3WLib;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.scm.domain.ISCMAccountMgr;
import com.trs.scm.domain.ISCMGroupMgr;
import com.trs.scm.domain.OAuthObjUtil;
import com.trs.scm.domain.SCMGroupAccountCacheMgr;
import com.trs.scm.persistent.Account;
import com.trs.scm.persistent.Accounts;
import com.trs.scm.persistent.GroupAccounts;
import com.trs.scm.persistent.SCMGroup;
import com.trs.scm.persistent.SCMGroups;
import com.trs.scm.sdk.IMicroUserMgr;
import com.trs.scm.sdk.factory.PlatformFactory;
import com.trs.scm.sdk.model.MicroUser;
import com.trs.scm.sdk.model.OAuth;

public class SCMAccountMgr
implements ISCMAccountMgr {
    private SCMGroupAccountCacheMgr m_oSCMGroupAccountCacheMgr = (SCMGroupAccountCacheMgr)DreamFactory.createObjectById("SCMGroupAccountCacheMgr");

    @Override
    public boolean delete(Account _oAccount) throws Exception {
        if (_oAccount == null) {
            throw new Exception("\u8981\u5220\u9664\u7684\u8d26\u53f7\u4e3a\u7a7a\uff01");
        }
        int nAccountId = _oAccount.getId();
        User oUser = ContextHelper.getLoginUser();
        _oAccount.setStatus(-1);
        _oAccount.save(oUser);
        WCMFilter oFilter = new WCMFilter("XWCMGROUPACCOUNT", "ACCOUNTID = ?", "", "");
        oFilter.addSearchValues(nAccountId);
        GroupAccounts oGroupAccounts = GroupAccounts.openWCMObjs(oUser, oFilter);
        oGroupAccounts.removeAll(true);
        return true;
    }

    @Override
    public Accounts findAccountsByGroup(SCMGroup _oGroup) throws Exception {
        if (_oGroup == null) {
            throw new Exception("\u6307\u5b9a\u7684\u5206\u7ec4\u4e3a\u7a7a\uff01");
        }
        int nGroupId = _oGroup.getId();
        return this.m_oSCMGroupAccountCacheMgr.queryAccountsOfSCMGroup(nGroupId);
    }

    @Override
    public Accounts findAccountsByGroupAndPlatform(SCMGroup _oGroup, String _sPlatformName) throws Exception {
        if (_oGroup == null) {
            throw new Exception("\u6307\u5b9a\u7684\u5206\u7ec4\u4e3a\u7a7a\uff01");
        }
        if (_sPlatformName == null) {
            throw new Exception("\u6307\u5b9a\u7684\u5e73\u53f0\u540d\u79f0\u4e3a\u7a7a\uff01");
        }
        int nGroupId = _oGroup.getId();
        Accounts oAccounts = this.m_oSCMGroupAccountCacheMgr.queryAccountsOfSCMGroup(nGroupId);
        int nSize = oAccounts.size();
        for (int i = nSize - 1; i >= 0; --i) {
            Account oAccount = (Account)oAccounts.getAt(i);
            if (oAccount == null || _sPlatformName.equalsIgnoreCase(oAccount.getPlatform())) continue;
            oAccounts.remove(oAccount, false);
        }
        return oAccounts;
    }

    @Override
    public Accounts findAccountsByGroupId(int _nGroupId) throws Exception {
        return this.m_oSCMGroupAccountCacheMgr.queryAccountsOfSCMGroup(_nGroupId);
    }

    @Override
    public Accounts findAccountsByPlatform(User _oUser, String _sPlatformName) throws Exception {
        if (_sPlatformName == null) {
            throw new Exception("\u6307\u5b9a\u7684\u5e73\u53f0\u540d\u79f0\u4e3a\u7a7a\uff01");
        }
        WCMFilter oFilter = new WCMFilter("", "STATUS = ? AND PLATFORM = ?", "");
        oFilter.addSearchValues(1);
        oFilter.addSearchValues(_sPlatformName);
        return Accounts.openWCMObjs(_oUser, oFilter);
    }

    @Override
    public Accounts findAccountsForUser(User _oUser) throws Exception {
        if (_oUser == null) {
            throw new Exception("\u6307\u5b9a\u7684\u7528\u6237\u4e3a\u7a7a\uff01");
        }
        ISCMGroupMgr oSCMGroupMgr = (ISCMGroupMgr)DreamFactory.createObjectById("ISCMGroupMgr");
        SCMGroups oSCMGroups = oSCMGroupMgr.getAllUserCanMgrGroups(_oUser);
        Accounts oAccounts = Accounts.createNewInstance(null);
        if (oSCMGroups == null || oSCMGroups.size() == 0) {
            return oAccounts;
        }
        int nSize = oSCMGroups.size();
        for (int i = 0; i < nSize; ++i) {
            int nSCMGroupId;
            Accounts tempAccounts;
            SCMGroup oSCMGroup = (SCMGroup)oSCMGroups.getAt(i);
            if (oSCMGroup == null || (tempAccounts = this.m_oSCMGroupAccountCacheMgr.queryAccountsOfSCMGroup(nSCMGroupId = oSCMGroup.getId())) == null || tempAccounts.size() == 0) continue;
            oAccounts.addElements(tempAccounts);
        }
        return oAccounts;
    }

    @Override
    public Account findById(int _nAccountId) throws Exception {
        return Account.findById(_nAccountId);
    }

    @Override
    public Accounts findByIds(String _sAccountIds) throws Exception {
        Accounts oAccounts = Accounts.findByIds(ContextHelper.getLoginUser(), _sAccountIds);
        for (int i = oAccounts.size() - 1; i >= 0; --i) {
            Account oAccount = (Account)oAccounts.getAt(i);
            if (oAccount.getStatus() == 1) continue;
            oAccounts.remove(oAccount, false);
        }
        return oAccounts;
    }

    @Override
    public Account findByUIdAndPlatform(String _sUId, String _sPlatformName) throws Exception {
        if (_sUId == null || _sPlatformName == null) {
            throw new Exception("\u6307\u5b9a\u7684\u7b2c\u4e09\u65b9\u7684\u7528\u6237Id\u6216\u5e73\u53f0\u540d\u79f0\u4e3a\u7a7a\uff01");
        }
        String sWhere = "MICROUID = ? and PLATFORM = ?";
        WCMFilter oFilter = new WCMFilter("", sWhere, "");
        oFilter.addSearchValues(_sUId);
        oFilter.addSearchValues(_sPlatformName);
        Accounts oAccounts = Accounts.openWCMObjs(ContextHelper.getLoginUser(), oFilter);
        if (oAccounts == null || oAccounts.size() == 0) {
            return null;
        }
        return (Account)oAccounts.getAt(0);
    }

    @Override
    public Accounts query(WCMFilter _filter) throws Exception {
        return Accounts.openWCMObjs(ContextHelper.getLoginUser(), _filter);
    }

    @Override
    public Account save(Account _oAccount) throws Exception {
        Account oExistAccount;
        if (_oAccount == null) {
            throw new Exception("\u8981\u4fdd\u5b58\u7684\u8d26\u53f7\u5bf9\u8c61\u4e3a\u7a7a\uff01");
        }
        User oUser = ContextHelper.getLoginUser();
        if (_oAccount.getId() > 0) {
            _oAccount.save(oUser);
            return _oAccount;
        }
        IMicroUserMgr oMicroUserMgr = this.getMicroUserMgrByAccount(_oAccount);
        MicroUser oMicroUser = oMicroUserMgr.showUser();
        _oAccount.setUId(oMicroUser.getId());
        _oAccount.setAccountName(oMicroUser.getName());
        String sHead = this.getHead(oMicroUser);
        if (!CMyString.isEmpty(sHead)) {
            _oAccount.setHeadPic(sHead);
        }
        if ((oExistAccount = this.findByUIdAndPlatform(oMicroUser.getId(), _oAccount.getPlatform())) != null) {
            oExistAccount.validCanEditAndLock(oUser);
            oExistAccount.setNewProperties(_oAccount.getProperties());
            oExistAccount.setStatus(1);
            oExistAccount.save(oUser);
            return oExistAccount;
        }
        _oAccount.save(oUser);
        return _oAccount;
    }

    private String getHead(MicroUser _oMicroUser) {
        String sHead = _oMicroUser.getHead();
        if (CMyString.isEmpty(sHead)) {
            return null;
        }
        try {
            String sNewFileName;
            boolean bResult;
            String sExt = CMyFile.extractFileExt(sHead);
            if (CMyString.isEmpty(sExt)) {
                sExt = "png";
            }
            if (bResult = CMy3WLib.getFile(sHead, sNewFileName = FilesMan.getFilesMan().getNextFileName("W0", "png", null, true))) {
                return CMyFile.extractFileName(sNewFileName);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sHead;
    }

    private IMicroUserMgr getMicroUserMgrByAccount(Account _oAccount) throws Exception {
        if (_oAccount == null) {
            throw new Exception("\u6307\u5b9a\u7684\u8d26\u53f7\u4e3a\u7a7a\uff01");
        }
        OAuth oOAuth = OAuthObjUtil.constructOAuth(_oAccount);
        String sPlatform = _oAccount.getPlatform();
        IMicroUserMgr oMicroUserMgr = PlatformFactory.createMicroUserMgr(sPlatform, oOAuth);
        return oMicroUserMgr;
    }

    @Override
    public MicroUser getMicroUser(Account _oAccount) throws Exception {
        IMicroUserMgr oMicroUserMgr = this.getMicroUserMgrByAccount(_oAccount);
        MicroUser oMicroUser = oMicroUserMgr.findUserById(_oAccount.getUId());
        return oMicroUser;
    }
}

