/*
 * Decompiled with CFR 0.152.
 */
package com.trs.presentation.util;

import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyDOM4jHelper;
import com.trs.infra.util.CMyFile;
import com.trs.presentation.util.Parameter;
import java.util.ArrayList;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;

public class Parameters {
    private ArrayList m_oParameterList;

    public Parameters() {
        this.m_oParameterList = new ArrayList();
    }

    public Parameters(int _nParameterSize) {
        this.m_oParameterList = new ArrayList(_nParameterSize);
    }

    public int size() {
        return this.m_oParameterList.size();
    }

    public Parameter get(int _nIndex) {
        return (Parameter)this.m_oParameterList.get(_nIndex);
    }

    public boolean add(Parameter _oPageParameter) {
        return this.m_oParameterList.add(_oPageParameter);
    }

    public Parameter remove(int _nIndex) {
        return (Parameter)this.m_oParameterList.remove(_nIndex);
    }

    public boolean remove(Parameter _oPageParameter) {
        return this.m_oParameterList.remove(_oPageParameter);
    }

    public String toString() {
        String sResult = "Load [" + this.size() + "] Parameters\uff01\n";
        for (int i = 0; i < this.size(); ++i) {
            sResult = sResult + "The [" + (i + 1) + "] Parameter:\n";
            sResult = sResult + this.get(i).toString();
        }
        return sResult;
    }

    public Parameter createParameterInstance() {
        return new Parameter();
    }

    public void loadParametersFromXML(String _sXMLFileName) throws WCMException {
        if (_sXMLFileName == null || !CMyFile.fileExists(_sXMLFileName)) {
            throw new WCMException(10, I18NMessage.get(Parameters.class, "Parameters.label1", "\u6307\u5b9a\u53c2\u6570\u914d\u7f6e\u6587\u4ef6[") + _sXMLFileName + I18NMessage.get(Parameters.class, "Parameters.label2", "]\u4e0d\u5b58\u5728\uff01"));
        }
        Element elRoot = CMyDOM4jHelper.buildXmlFile(_sXMLFileName, null);
        if (elRoot == null) {
            throw new WCMException(150, I18NMessage.get(Parameters.class, "Parameters.label3", "\u53c2\u6570\u914d\u7f6e\u6587\u4ef6[") + _sXMLFileName + I18NMessage.get(Parameters.class, "Parameters.label4", "]\u6ca1\u6709\u5b9a\u4e49\u6839\u5143\u7d20!"));
        }
        Element elParameter = null;
        int nNodeCount = elRoot.nodeCount();
        for (int i = 0; i < nNodeCount; ++i) {
            Node node = elRoot.node(i);
            if (!(node instanceof Element)) continue;
            elParameter = (Element)elRoot.node(i);
            Parameter newParameter = this.createParameterInstance();
            newParameter.fromXML(elParameter);
            this.add(newParameter);
        }
    }

    public Element toXMLElement(String _sTagName) throws WCMException {
        if (_sTagName == null || _sTagName.trim().length() == 0) {
            throw new WCMException(10, I18NMessage.get(Parameters.class, "Parameters.label5", "\u6ca1\u6709\u6307\u5b9a\u7684TagName\uff01"));
        }
        Element newElement = DocumentHelper.createElement((String)(_sTagName.toLowerCase() + "s"));
        for (int i = 0; i < this.size(); ++i) {
            newElement.add(this.get(i).toXMLElment(_sTagName));
        }
        return newElement;
    }

    public Element toXMLElement() throws WCMException {
        return this.toXMLElement("parameter");
    }

    public boolean toXMLFile(String _XMLFileName, String _sTagName, String _XSLFileName) throws WCMException {
        Element element = this.toXMLElement(_sTagName);
        CMyDOM4jHelper.toXMLFile(element, "GBK", _XMLFileName, _XSLFileName);
        return true;
    }

    public static void main(String[] args) {
        try {
            String sInfoFileName = "c:\\document_list_of_channel.xml";
            if (!CMyFile.fileExists(sInfoFileName)) {
                throw new WCMException(10, I18NMessage.get(Parameters.class, "Parameters.label6", "\u914d\u7f6e\u6587\u4ef6[") + sInfoFileName + I18NMessage.get(Parameters.class, "Parameters.label7", "]\u4e0d\u5b58\u5728!"));
            }
            Parameters aParameters = new Parameters();
            aParameters.loadParametersFromXML(sInfoFileName);
            System.out.println(aParameters.toString());
        }
        catch (Exception ex) {
            System.out.println(I18NMessage.get(Parameters.class, "Parameters.label8", "\u6d4b\u8bd5XML\u5bfc\u5165\u5931\u8d25\uff01"));
            ex.printStackTrace();
        }
    }
}

