/*
 * Decompiled with CFR 0.152.
 */
package com.trs.license;

public class LicenseUtil {
    private static final char[] encode_array;
    private static final byte[] decode_array;

    private static byte[] decodeRadix64(byte[] inbuf) {
        int size = inbuf.length / 4 * 3;
        if (size == 0) {
            return inbuf;
        }
        if (inbuf[inbuf.length - 1] == 46) {
            --size;
            if (inbuf[inbuf.length - 2] == 46) {
                --size;
            }
        }
        byte[] outbuf = new byte[size];
        int inpos = 0;
        int outpos = 0;
        for (size = inbuf.length; size > 0; size -= 4) {
            byte a = decode_array[inbuf[inpos++] & 0xFF];
            byte b = decode_array[inbuf[inpos++] & 0xFF];
            outbuf[outpos++] = (byte)(a << 2 & 0xFC | b >>> 4 & 3);
            if (inbuf[inpos] == 46) {
                return outbuf;
            }
            a = b;
            b = decode_array[inbuf[inpos++] & 0xFF];
            outbuf[outpos++] = (byte)(a << 4 & 0xF0 | b >>> 2 & 0xF);
            if (inbuf[inpos] == 46) {
                return outbuf;
            }
            a = b;
            b = decode_array[inbuf[inpos++] & 0xFF];
            outbuf[outpos++] = (byte)(a << 6 & 0xC0 | b & 0x3F);
        }
        return outbuf;
    }

    public static String decodeRadix64(String _srcStr) {
        LicenseUtil.assertNotNull(_srcStr);
        try {
            _srcStr = _srcStr.trim();
            return new String(LicenseUtil.decodeRadix64(_srcStr.getBytes()));
        }
        catch (ArrayIndexOutOfBoundsException e) {
            _srcStr = _srcStr.charAt(_srcStr.length() - 1) == '.' ? _srcStr + '.' : _srcStr + "..";
            return new String(LicenseUtil.decodeRadix64(_srcStr.getBytes()));
        }
    }

    private static void assertNotNull(String _srcStr) {
        if (_srcStr == null) {
            throw new NullPointerException();
        }
    }

    static {
        int i;
        encode_array = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '-', '_'};
        decode_array = new byte[256];
        for (i = 0; i < 255; ++i) {
            LicenseUtil.decode_array[i] = -1;
        }
        for (i = 0; i < encode_array.length; ++i) {
            LicenseUtil.decode_array[LicenseUtil.encode_array[i]] = (byte)i;
        }
    }
}

