/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.upgrade.dbcompare;

import com.trs.infra.util.upgrade.dbcompare.TypeInfo;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;

public class TypeInfoMap {
    private static final Map TYPEINFOS = new HashMap(40);
    private static final String TYPE_CONF = "/typeinfo";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void load(String dbtype) {
        InputStream ins = null;
        InputStreamReader insr = null;
        BufferedReader reader = null;
        Class<TypeInfoMap> clazz = TypeInfoMap.class;
        try {
            String fn = "/typeinfo." + dbtype;
            ins = clazz.getResourceAsStream(fn);
            if (ins == null) {
                ins = clazz.getResourceAsStream(fn.substring(1));
            }
            insr = new InputStreamReader(ins);
            reader = new BufferedReader(insr);
            String line = reader.readLine();
            while (line != null) {
                if (line.charAt(0) == '#') {
                    line = reader.readLine();
                    continue;
                }
                String[] parts = line.trim().split(",");
                TypeInfo typeInfo = new TypeInfo();
                typeInfo.setTypeName(parts[0]);
                typeInfo.setCrtParamsCount(Integer.parseInt(parts[1]));
                TYPEINFOS.put(parts[0], typeInfo);
                line = reader.readLine();
            }
        }
        catch (Exception ex) {
            System.out.println("load type info failed.");
            ex.printStackTrace(System.out);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
            if (insr != null) {
                try {
                    insr.close();
                }
                catch (Exception exception) {}
            }
            if (ins != null) {
                try {
                    ins.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void put(String typeName, TypeInfo typeInfo) {
        TYPEINFOS.put(typeName, typeInfo);
    }

    public static TypeInfo get(String typeName) {
        return (TypeInfo)TYPEINFOS.get(typeName);
    }

    public static String display() {
        return TYPEINFOS.toString();
    }
}

