/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.store.impl;

import com.aliyun.oss.common.utils.IOUtils;
import com.trs.infra.util.store.RandomAccessFileStore;
import com.trs.infra.util.store.RandomAccessFileStoreException;
import com.trs.infra.util.store.impl.OSSFileStore;
import java.io.EOFException;
import java.io.InputStream;

public class OSSRandomAccessFileStore
implements RandomAccessFileStore {
    private OSSFileStore file;
    private long fp;
    private boolean ischange = false;
    private String mode;
    protected InputStream in = null;

    public OSSRandomAccessFileStore(String name, String mode) {
        this.file = new OSSFileStore(name);
        this.mode = mode;
    }

    @Override
    public void readFully(byte[] b) {
        this.readFully(b, 0, b.length);
    }

    @Override
    public void readFully(byte[] b, int off, int len) {
        int j;
        int i = 0;
        do {
            if ((j = this.read(b, off + i, len - i)) >= 0) continue;
            throw new RandomAccessFileStoreException();
        } while ((i += j) < len);
    }

    @Override
    public int skipBytes(int n) {
        if (n > 0) {
            this.fp += (long)n;
            this.ischange = true;
            return n;
        }
        return 0;
    }

    @Override
    public void seek(long pos) {
        this.fp = pos;
        this.ischange = true;
    }

    @Override
    public long length() {
        return this.file.length();
    }

    @Override
    public void close() {
        IOUtils.safeClose((InputStream)this.in);
    }

    @Override
    public int readUnsignedByte() {
        return this.read();
    }

    @Override
    public int read() {
        try {
            this.reloadInputStream();
            int i = this.in.read();
            if (i < 0) {
                throw new EOFException();
            }
            ++this.fp;
            return i;
        }
        catch (Exception e) {
            throw new RandomAccessFileStoreException(e);
        }
    }

    @Override
    public int read(byte[] b) {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) {
        try {
            this.reloadInputStream();
            int read_num = this.in.read(b, off, len);
            if (read_num > 0) {
                this.fp += (long)read_num;
            }
            return read_num;
        }
        catch (Exception e) {
            throw new RandomAccessFileStoreException(e);
        }
    }

    private void reloadInputStream() throws EOFException {
        if (this.in == null || this.ischange) {
            this.close();
            long length = this.length();
            if (length == 0L || this.fp >= length - 1L) {
                throw new EOFException();
            }
            this.in = this.file.getInputStream(this.fp, length - 1L);
            this.ischange = false;
        }
    }
}

