/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.store.impl;

import com.trs.infra.util.store.FileStore;
import com.trs.infra.util.store.FileStoreException;
import com.trs.infra.util.store.FileStoreFactory;
import com.trs.infra.util.store.FileStoreFilter;
import com.trs.infra.util.store.FileStoreNameFilter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;

public class LocalFileStore
implements FileStore {
    private File file;

    public LocalFileStore(String pathname) {
        this.file = new File(pathname);
    }

    public LocalFileStore(File file) {
        this.file = file;
    }

    public LocalFileStore(String parent, String child) {
        this.file = new File(parent, child);
    }

    public LocalFileStore(LocalFileStore parent, String child) {
        this.file = new File(parent.file, child);
    }

    @Override
    public boolean exists() {
        return this.file.exists();
    }

    @Override
    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    @Override
    public boolean isFile() {
        return this.file.isFile();
    }

    @Override
    public boolean delete() {
        return this.file.delete();
    }

    @Override
    public String[] list() {
        return this.file.list();
    }

    @Override
    public String[] list(FileStoreNameFilter filter) {
        final FileStoreNameFilter finalFilter = filter;
        return this.file.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return finalFilter.accept(new LocalFileStore(dir), name);
            }
        });
    }

    @Override
    public FileStore[] listFiles() {
        File[] files = this.file.listFiles();
        int fileLength = 0;
        if (files != null) {
            fileLength = files.length;
        }
        FileStore[] fileStores = new FileStore[fileLength];
        for (int i = 0; i < fileStores.length; ++i) {
            fileStores[i] = new LocalFileStore(files[i]);
        }
        return fileStores;
    }

    @Override
    public FileStore[] listFiles(FileStoreNameFilter filter) {
        final FileStoreNameFilter finalFilter = filter;
        File[] files = this.file.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return finalFilter.accept(new LocalFileStore(dir), name);
            }
        });
        FileStore[] fileStores = new FileStore[files.length];
        for (int i = 0; i < fileStores.length; ++i) {
            fileStores[i] = new LocalFileStore(files[i]);
        }
        return fileStores;
    }

    @Override
    public FileStore[] listFiles(FileStoreFilter filter) {
        final FileStoreFilter finalFilter = filter;
        File[] files = this.file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return finalFilter.accept(new LocalFileStore(pathname));
            }
        });
        FileStore[] fileStores = new FileStore[files.length];
        for (int i = 0; i < fileStores.length; ++i) {
            fileStores[i] = new LocalFileStore(files[i]);
        }
        return fileStores;
    }

    @Override
    public boolean mkdir() {
        return this.file.mkdir();
    }

    @Override
    public InputStream getInputStream() {
        try {
            return new FileInputStream(this.file);
        }
        catch (FileNotFoundException e) {
            throw new FileStoreException(e);
        }
    }

    @Override
    public OutputStream getOutputStream() {
        try {
            return new FileOutputStream(this.file);
        }
        catch (FileNotFoundException e) {
            throw new FileStoreException(e);
        }
    }

    @Override
    public String getAbsolutePath() {
        return this.file.getAbsolutePath();
    }

    @Override
    public String getPath() {
        return this.file.getPath();
    }

    @Override
    public long length() {
        return this.file.length();
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public String getParent() {
        return this.file.getParent();
    }

    @Override
    public FileStore getParentFileStore() {
        return new LocalFileStore(this.file.getParentFile());
    }

    @Override
    public long lastModified() {
        return this.file.lastModified();
    }

    @Override
    public boolean setLastModified(long time) {
        return this.file.setLastModified(time);
    }

    @Override
    public boolean renameTo(FileStore dest) {
        FileStore dest2 = FileStoreFactory.getInstance().buildFileStore(dest.getPath());
        LocalFileStore localDest = (LocalFileStore)dest2;
        return this.file.renameTo(localDest.file);
    }

    @Override
    public boolean mkdirs() {
        return this.file.mkdirs();
    }

    @Override
    public boolean canRead() {
        return this.file.canRead();
    }

    @Override
    public boolean createNewFile() {
        try {
            return this.file.createNewFile();
        }
        catch (IOException e) {
            throw new FileStoreException(e);
        }
    }

    @Override
    public boolean isHidden() {
        return this.file.isHidden();
    }

    @Override
    public URL toURL() {
        try {
            return this.file.toURL();
        }
        catch (MalformedURLException e) {
            throw new FileStoreException(e);
        }
    }

    @Override
    public URI toURI() {
        return this.file.toURI();
    }
}

