/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.jazzlib;

class StreamManipulator {
    private byte[] window;
    private int window_start = 0;
    private int window_end = 0;
    private int buffer = 0;
    private int bits_in_buffer = 0;

    public final int peekBits(int n) {
        if (this.bits_in_buffer < n) {
            if (this.window_start == this.window_end) {
                return -1;
            }
            this.buffer |= (this.window[this.window_start++] & 0xFF | (this.window[this.window_start++] & 0xFF) << 8) << this.bits_in_buffer;
            this.bits_in_buffer += 16;
        }
        return this.buffer & (1 << n) - 1;
    }

    public final void dropBits(int n) {
        this.buffer >>>= n;
        this.bits_in_buffer -= n;
    }

    public final int getBits(int n) {
        int bits = this.peekBits(n);
        if (bits >= 0) {
            this.dropBits(n);
        }
        return bits;
    }

    public final int getAvailableBits() {
        return this.bits_in_buffer;
    }

    public final int getAvailableBytes() {
        return this.window_end - this.window_start + (this.bits_in_buffer >> 3);
    }

    public void skipToByteBoundary() {
        this.buffer >>= this.bits_in_buffer & 7;
        this.bits_in_buffer &= 0xFFFFFFF8;
    }

    public final boolean needsInput() {
        return this.window_start == this.window_end;
    }

    public int copyBytes(byte[] output, int offset, int length) {
        if (length < 0) {
            throw new IllegalArgumentException("length negative");
        }
        if ((this.bits_in_buffer & 7) != 0) {
            throw new IllegalStateException("Bit buffer is not aligned!");
        }
        int count = 0;
        while (this.bits_in_buffer > 0 && length > 0) {
            output[offset++] = (byte)this.buffer;
            this.buffer >>>= 8;
            this.bits_in_buffer -= 8;
            --length;
            ++count;
        }
        if (length == 0) {
            return count;
        }
        int avail = this.window_end - this.window_start;
        if (length > avail) {
            length = avail;
        }
        System.arraycopy(this.window, this.window_start, output, offset, length);
        this.window_start += length;
        if ((this.window_start - this.window_end & 1) != 0) {
            this.buffer = this.window[this.window_start++] & 0xFF;
            this.bits_in_buffer = 8;
        }
        return count + length;
    }

    public void reset() {
        this.bits_in_buffer = 0;
        this.buffer = 0;
        this.window_end = 0;
        this.window_start = 0;
    }

    public void setInput(byte[] buf, int off, int len) {
        if (this.window_start < this.window_end) {
            throw new IllegalStateException("Old input was not completely processed");
        }
        int end = off + len;
        if (0 > off || off > end || end > buf.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if ((len & 1) != 0) {
            this.buffer |= (buf[off++] & 0xFF) << this.bits_in_buffer;
            this.bits_in_buffer += 8;
        }
        this.window = buf;
        this.window_start = off;
        this.window_end = end;
    }
}

