/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.cabfile;

import com.trs.infra.util.cabfile.CFFile;
import com.trs.infra.util.cabfile.CabConstants;
import java.util.Calendar;

public class CabEntry
implements CabConstants {
    private CFFile m_oCFFile;
    private String m_sName;
    private long m_tTime;

    CabEntry(CFFile cffile) {
        this.m_oCFFile = cffile;
        if ((cffile.attribs & 0x80) != 0) {
            try {
                this.m_sName = new String(cffile.szName, "utf-8");
            }
            catch (Exception exception) {}
        } else {
            this.m_sName = new String(cffile.szName);
        }
        int year = (cffile.date >> 9) + 1980;
        int month = cffile.date >> 5 & 0xF;
        int day = cffile.date >> 0 & 0x1F;
        int hour = cffile.time >> 11;
        int minute = cffile.time >> 5 & 0x3F;
        int second = cffile.time << 1 & 0x1E;
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month - 1);
        cal.set(5, day);
        cal.set(11, hour);
        cal.set(12, minute);
        cal.set(13, second);
        cal.set(14, 0);
        this.m_tTime = cal.getTimeInMillis();
    }

    public String getName() {
        return this.m_sName;
    }

    public long getSize() {
        return this.m_oCFFile.cbFile;
    }

    public long getTime() {
        return this.m_tTime;
    }

    public int getAttribute() {
        return this.m_oCFFile.attribs;
    }

    public boolean isReadonly() {
        return (this.m_oCFFile.attribs & 1) != 0;
    }

    public boolean isHidden() {
        return (this.m_oCFFile.attribs & 2) != 0;
    }

    public boolean isSystem() {
        return (this.m_oCFFile.attribs & 4) != 0;
    }
}

