/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util;

import java.io.UnsupportedEncodingException;

public final class URLCoder {
    private static boolean[] dontNeed;
    private static String encoding;
    private static char[] hexDigit;

    public static final String decode(String s) {
        if (s != null) {
            byte[] buff = new byte[s.length()];
            int iLen = URLCoder.decode(s, buff);
            try {
                return new String(buff, 0, iLen, encoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return null;
    }

    private static final int decode(String str, byte[] out) {
        int iPos = 0;
        int iLen = out.length;
        int iDst = 0;
        block6: for (iPos = 0; iPos < iLen; ++iPos) {
            char c = str.charAt(iPos);
            switch (c) {
                case '+': {
                    out[iDst++] = 32;
                    continue block6;
                }
                case '%': {
                    try {
                        out[iDst++] = URLCoder.hex2byte(str.charAt(iPos + 1), str.charAt(iPos + 2));
                        iPos += 2;
                        continue block6;
                    }
                    catch (NumberFormatException e) {
                        break block6;
                    }
                }
                default: {
                    out[iDst++] = (byte)c;
                }
            }
        }
        return iDst;
    }

    public static final String decode(String str, String enc) throws UnsupportedEncodingException {
        byte[] buff = new byte[str.length()];
        int iLen = URLCoder.decode(str, buff);
        return new String(buff, 0, iLen, enc);
    }

    private static final String encode(byte[] buff) {
        int iResultLen = 0;
        char[] out = new char[3 * buff.length + 1];
        for (int i = 0; i < buff.length; ++i) {
            int c = buff[i];
            if (dontNeed[c &= 0xFF]) {
                if (c == 32) {
                    c = 43;
                }
                out[iResultLen++] = (char)c;
                continue;
            }
            out[iResultLen++] = 37;
            out[iResultLen++] = hexDigit[c >> 4 & 0xF];
            out[iResultLen++] = hexDigit[c & 0xF];
        }
        return new String(out, 0, iResultLen);
    }

    public static final String encode(String s) {
        if (s != null) {
            try {
                return URLCoder.encode(s.getBytes(encoding));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return null;
    }

    public static final String encode(String str, String enc) throws UnsupportedEncodingException {
        return URLCoder.encode(str.getBytes(enc));
    }

    private static final byte hex2byte(char h, char l) {
        int b;
        int a = h - 48;
        if (a >= 10) {
            a -= 7;
        }
        if ((b = l - 48) >= 10) {
            b -= 7;
        }
        return (byte)(a << 4 | b);
    }

    private static final void init() {
        int i;
        hexDigit = new char[16];
        URLCoder.hexDigit[0] = 48;
        URLCoder.hexDigit[1] = 49;
        URLCoder.hexDigit[2] = 50;
        URLCoder.hexDigit[3] = 51;
        URLCoder.hexDigit[4] = 52;
        URLCoder.hexDigit[5] = 53;
        URLCoder.hexDigit[6] = 54;
        URLCoder.hexDigit[7] = 55;
        URLCoder.hexDigit[8] = 56;
        URLCoder.hexDigit[9] = 57;
        URLCoder.hexDigit[10] = 65;
        URLCoder.hexDigit[11] = 66;
        URLCoder.hexDigit[12] = 67;
        URLCoder.hexDigit[13] = 68;
        URLCoder.hexDigit[14] = 69;
        URLCoder.hexDigit[15] = 70;
        encoding = null;
        String s = null;
        s = System.getProperty("trs.url.encoding");
        if (URLCoder.testEncoding(s)) {
            encoding = s;
        }
        if (URLCoder.testEncoding(s = System.getProperty("file.encoding"))) {
            encoding = s;
        }
        if (URLCoder.testEncoding(s = "GBK")) {
            encoding = s;
        }
        if (encoding == null) {
            encoding = "ASCII";
        }
        dontNeed = new boolean[256];
        for (i = 0; i < 256; ++i) {
            URLCoder.dontNeed[i] = false;
        }
        for (i = 97; i <= 122; ++i) {
            URLCoder.dontNeed[i] = true;
        }
        for (i = 65; i <= 90; ++i) {
            URLCoder.dontNeed[i] = true;
        }
        for (i = 48; i <= 57; ++i) {
            URLCoder.dontNeed[i] = true;
        }
        URLCoder.dontNeed[32] = true;
        URLCoder.dontNeed[45] = true;
        URLCoder.dontNeed[95] = true;
        URLCoder.dontNeed[46] = true;
        URLCoder.dontNeed[42] = true;
    }

    public static void main(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String s = args[i];
            if (s.equals("-e")) {
                encoding = args[++i];
                continue;
            }
            if (s.equals("-d")) {
                System.out.println(URLCoder.decode(args[++i]));
                continue;
            }
            System.out.println(URLCoder.encode(s));
        }
    }

    private static final boolean testEncoding(String enc) {
        if (enc != null) {
            try {
                "test".getBytes(enc);
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private URLCoder() {
    }

    static {
        URLCoder.init();
    }
}

