/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util;

import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.Logger;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.helpers.DefaultHandler;

public class CMyJAXPXMLParser {
    private static Logger logger = Logger.getLogger(CMyJAXPXMLParser.class);

    public static SAXParserFactory newSAXParserFactory() throws SAXNotRecognizedException, SAXNotSupportedException, ParserConfigurationException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        CMyJAXPXMLParser.enableFeature(factory, "http://apache.org/xml/features/disallow-doctype-decl");
        CMyJAXPXMLParser.disableFeature(factory, "http://xml.org/sax/features/external-general-entities");
        CMyJAXPXMLParser.disableFeature(factory, "http://xml.org/sax/features/external-parameter-entities");
        CMyJAXPXMLParser.disableFeature(factory, "http://apache.org/xml/features/nonvalidating/load-external-dtd");
        try {
            factory.setXIncludeAware(false);
        }
        catch (Throwable e) {
            logger.error((Object)"Fail to setXIncludeAware!", e);
        }
        return factory;
    }

    private static void enableFeature(SAXParserFactory _factory, String _feature) {
        try {
            _factory.setFeature(_feature, true);
        }
        catch (Throwable t) {
            logger.error((Object)("Fail to set " + _feature + "!"), t);
        }
    }

    private static void disableFeature(SAXParserFactory _factory, String _feature) {
        try {
            _factory.setFeature(_feature, false);
        }
        catch (Throwable t) {
            logger.error((Object)("Fail to set " + _feature + "!"), t);
        }
    }

    public static void parseXMLFile(InputSource is, DefaultHandler handler, boolean validating) throws ParserConfigurationException, SAXException, IOException {
        SAXParserFactory factory = CMyJAXPXMLParser.newSAXParserFactory();
        factory.setValidating(validating);
        factory.newSAXParser().parse(is, handler);
    }

    public static DocumentBuilderFactory newDocumentBuilderFactory() {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setExpandEntityReferences(false);
        return dbf;
    }

    public static DocumentBuilder newDocumentBuilder() throws ParserConfigurationException {
        return CMyJAXPXMLParser.newDocumentBuilderFactory().newDocumentBuilder();
    }
}

