/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.support.log;

import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.config.ConfigConstants;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.support.log.BaseDBLog;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyKeyGenerator;
import com.trs.infra.util.CMySign;
import com.trs.infra.util.CMyString;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import org.apache.log4j.Logger;

public class Log
extends BaseDBLog {
    private static Logger logger = Logger.getLogger(Log.class);
    public static final int OBJ_TYPE = 702;
    public static final String DB_TABLE_NAME = "WCMLOG";
    public static final String DB_ID_NAME = "LOGID";
    private static final String KEY_PRIVATE_LOGIN = ConfigConstants.DIR_APPROOT + "private_log.key";
    private static final String KEY_PUBLIC_LOGIN = ConfigConstants.DIR_APPROOT + "public_log.key";
    private String m_sValidateResult = null;

    @Override
    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    @Override
    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    @Override
    public int getWCMType() {
        return 702;
    }

    @Override
    public void insert() throws WCMException {
        if (this.isAddMode() && this.getAllProperty() != null) {
            if (this.getProperty("LOGOPTIME") == null) {
                this.setOpTime();
            }
            this.setProperty("SIGNINFO", this.createEncodeLogInfo());
            super.insert();
        }
    }

    public static final Log findById(int _nId) throws WCMException {
        if (_nId <= 0) {
            return null;
        }
        return (Log)BaseObj.findById(Log.class, _nId);
    }

    public static final Log createNewInstance() throws WCMException {
        return (Log)BaseObj.createNewInstance(Log.class);
    }

    public static final Log findByKey(Object _oKey) throws WCMException {
        return (Log)BaseObj.findByKey(Log.class, _oKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createEncodeLogInfo() {
        ByteArrayOutputStream bos = null;
        FilterOutputStream dos = null;
        try {
            CMySign su = CMySign.getSign(KEY_PRIVATE_LOGIN);
            bos = new ByteArrayOutputStream(512);
            dos = new DataOutputStream(bos);
            ((DataOutputStream)dos).writeInt(this.getObjId());
            ((DataOutputStream)dos).writeInt(this.getObjType());
            ((DataOutputStream)dos).writeInt(this.getOpType());
            ((DataOutputStream)dos).writeUTF(this.getObjName());
            ((DataOutputStream)dos).writeUTF(CMyString.showNull(this.getLogUserIP(), "127.0.0.1"));
            ((DataOutputStream)dos).writeUTF(this.getUserName());
            ((DataOutputStream)dos).writeUTF(this.getOpTime().toString("yyyy-MM-dd HH:mm:ss"));
            ((DataOutputStream)dos).flush();
            byte[] buff = su.sign(bos.toByteArray());
            ((DataOutputStream)dos).writeInt(buff.length);
            dos.write(buff);
            ((DataOutputStream)dos).flush();
            String string = su.encodeRadix64(bos.toByteArray());
            return string;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (dos != null) {
                try {
                    dos.close();
                }
                catch (Exception exception) {}
            }
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (Exception exception) {}
            }
        }
        return "";
    }

    public boolean isValidSignLog() {
        return this.validateSignInfo();
    }

    public String getValidSignResult() {
        return this.m_sValidateResult;
    }

    private boolean validateSignInfo() {
        String sEncodeInfo = this.getPropertyAsString("SIGNINFO");
        if (sEncodeInfo == null || sEncodeInfo.length() <= 0) {
            this.m_sValidateResult = I18NMessage.get(Log.class, "Log.label1", "\u65e5\u5fd7\u6ca1\u6709\u7ecf\u8fc7\u7b7e\u540d");
            return false;
        }
        this.m_sValidateResult = "";
        try {
            boolean bAddLog;
            byte[] buff = sEncodeInfo.getBytes();
            CMySign verify = CMySign.getVerify(KEY_PUBLIC_LOGIN);
            buff = verify.decodeRadix64(buff);
            DataInputStream is = new DataInputStream(new ByteArrayInputStream(buff));
            int nTemp = is.readInt();
            boolean bl = bAddLog = nTemp == 0;
            if (!bAddLog && this.getObjId() != nTemp) {
                this.m_sValidateResult = this.m_sValidateResult + I18NMessage.get(Log.class, "Log.label2", "LOGOBJID\u88ab\u7be1\u6539\u4e86\uff0c\u539f\u6709\u7684ID=[") + nTemp + "] ";
            }
            nTemp = is.readInt();
            if (this.getObjType() != nTemp) {
                this.m_sValidateResult = this.m_sValidateResult + I18NMessage.get(Log.class, "Log.label3", "LOGOBJTYPE\u88ab\u7be1\u6539\u4e86\uff0c\u539f\u6709\u7684LOGOBJTYPE=[") + nTemp + "] ";
            }
            nTemp = is.readInt();
            if (this.getOpType() != nTemp) {
                this.m_sValidateResult = this.m_sValidateResult + I18NMessage.get(Log.class, "Log.label4", "LOGOPTYPE\u88ab\u7be1\u6539\u4e86\uff0c\u539f\u6709\u7684LOGOPTYPE=[") + nTemp + "] ";
            }
            String sTemp = is.readUTF();
            if (!bAddLog && !sTemp.equals(this.getObjName())) {
                this.m_sValidateResult = this.m_sValidateResult + I18NMessage.get(Log.class, "Log.label5", "LOGOBJNAME\u88ab\u7be1\u6539\u4e86\uff0c\u539f\u6709\u7684LOGOBJNAME=[") + sTemp + "] ";
            }
            if (!(sTemp = is.readUTF()).equals(this.getLogUserIP())) {
                this.m_sValidateResult = this.m_sValidateResult + I18NMessage.get(Log.class, "Log.label6", "LOGUSERI\u88ab\u7be1\u6539\u4e86\uff0c\u539f\u6709\u7684LOGUSERIP=[") + sTemp + "] ";
            }
            if (!(sTemp = is.readUTF()).equals(this.getUserName())) {
                this.m_sValidateResult = this.m_sValidateResult + I18NMessage.get(Log.class, "Log.label7", "LOGUSER\u88ab\u7be1\u6539\u4e86\uff0c\u539f\u6709\u7684LOGUSER=[") + sTemp + "] ";
            }
            if (!(sTemp = is.readUTF()).equals(this.getOpTime().toString("yyyy-MM-dd HH:mm:ss"))) {
                this.m_sValidateResult = this.m_sValidateResult + I18NMessage.get(Log.class, "Log.label8", "LOGOPTIM\u88ab\u7be1\u6539\u4e86\uff0c\u539f\u6709\u7684LOGOPTIME=[") + sTemp + "] ";
            }
            if (!verify.verify(buff, nTemp = is.readInt())) {
                this.m_sValidateResult = this.m_sValidateResult + I18NMessage.get(Log.class, "Log.label9", "\u6570\u636e\u957f\u5ea6[") + nTemp + I18NMessage.get(Log.class, "Log.label10", "]\u4e0d\u4e00\u81f4");
            }
            return this.m_sValidateResult.length() <= 0;
        }
        catch (Exception ex) {
            return false;
        }
    }

    static {
        try {
            if (!CMyFile.fileExists(KEY_PRIVATE_LOGIN)) {
                logger.info((Object)("create " + KEY_PRIVATE_LOGIN + " file.."));
                CMyKeyGenerator.generatorKey(KEY_PRIVATE_LOGIN, KEY_PUBLIC_LOGIN);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

