/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.support.cache;

import com.trs.DreamFactory;
import com.trs.infra.BaseServer;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.config.XMLConfigServer;
import com.trs.infra.persistent.cache.ICachedPOMgr;
import com.trs.infra.support.cache.CacheMgrConfig;
import com.trs.infra.support.cache.ICacheMgr;
import com.trs.infra.util.CMyMemory;
import java.util.List;
import org.apache.log4j.Logger;

public class CacheServer
extends BaseServer {
    private CacheMgrConfig[] m_arConfig = null;
    private static Logger s_logger = Logger.getLogger(CacheServer.class);

    @Override
    protected void doShutdown() {
        try {
            int nMgrCount = this.getConfigs().length;
            for (int i = 0; i < nMgrCount; ++i) {
                this.getManagerAt(i).clear();
            }
            this.setConfig(null);
        }
        catch (Exception ex) {
            s_logger.error((Object)I18NMessage.get(CacheServer.class, "CacheServer.label1", "Cache Server\u5173\u95ed\u7684\u65f6\u5019\u51fa\u73b0\u5f02\u5e38\uff01"), (Throwable)ex);
        }
    }

    protected ICacheMgr getManagerAt(int _nIndex) {
        return (ICacheMgr)DreamFactory.createObjectById(this.getConfigs()[_nIndex].getBeanId());
    }

    @Override
    protected boolean doStart() throws WCMException {
        ICachedPOMgr currCachedPOMgr = (ICachedPOMgr)DreamFactory.createObjectById("ICachedPOMgr");
        if (currCachedPOMgr == null) {
            throw new WCMException(10, "ICachedPOMgr Config Error!");
        }
        currCachedPOMgr.init();
        int nMgrCount = this.getConfigs().length;
        for (int i = 0; i < nMgrCount; ++i) {
            s_logger.info((Object)("\u7f13\u5b58\u670d\u52a1\u5668" + (i + 1) + "[" + this.getConfigs()[i].getName() + "]\u6b63\u5728\u542f\u52a8,\u542f\u52a8\u524d\u5185\u5b58[" + CMyMemory.toMemoryInfo() + "]......."));
            this.getManagerAt(i).init();
            s_logger.info((Object)("\u7f13\u5b58\u670d\u52a1\u5668" + (i + 1) + "[" + this.getConfigs()[i].getName() + "]\u542f\u52a8\u5b8c\u6210\uff0c\u542f\u52a8\u540e\u5185\u5b58[" + CMyMemory.toMemoryInfo() + "]!"));
        }
        return true;
    }

    private void loadConfig() {
        List oConfigMgrs = XMLConfigServer.getInstance().getConfigObjects(CacheMgrConfig.class);
        if (oConfigMgrs == null || oConfigMgrs.size() == 0) {
            this.setConfig(new CacheMgrConfig[0]);
        } else {
            this.setConfig(CacheServer.toCacheMgrConfigArray(oConfigMgrs));
        }
    }

    public CacheMgrConfig[] getConfigs() {
        if (this.m_arConfig == null) {
            this.loadConfig();
        }
        return this.m_arConfig;
    }

    public void setConfig(CacheMgrConfig[] _configs) {
        this.m_arConfig = _configs;
    }

    private static CacheMgrConfig[] toCacheMgrConfigArray(List cacheMgrs) {
        if (cacheMgrs == null || cacheMgrs.size() == 0) {
            return null;
        }
        CacheMgrConfig[] result = new CacheMgrConfig[cacheMgrs.size()];
        for (int i = 0; i < cacheMgrs.size(); ++i) {
            result[i] = (CacheMgrConfig)cacheMgrs.get(i);
        }
        return result;
    }
}

