/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.persistent.db;

import com.trs.DreamFactory;
import com.trs.cluster.IClusterMsgCenter;
import com.trs.infra.BaseServer;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.InjectSQLHelper;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBConnectionConfig;
import com.trs.infra.persistent.db.DBConnectionMapper;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.database.CDBText;
import com.trs.infra.util.database.ConnectionPool;
import com.trs.infra.util.database.DBIdManager;
import com.trs.infra.util.database.DBType;
import com.trs.infra.util.database.FieldInfo;
import com.trs.infra.util.database.TableInfo;
import com.trs.infra.util.database.TableInfos;
import com.trs.util.dbcp.ConnectionCache;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.log4j.Logger;

public class DBManager
extends BaseServer {
    private static final Logger logger = Logger.getLogger((String)DBManager.class.getName());
    protected ConnectionPool m_oDBPool = null;
    private TableInfos m_oTableInfos;
    private DBIdManager m_oDbIdManager = null;
    private DBConnectionConfig m_oDBConnConfig;
    private static DBManager m_oDBManager = new DBManager();
    private Set m_oDBKeywords = null;

    public boolean isKeywords(String _sFieldName) {
        if (CMyString.isEmpty(_sFieldName)) {
            return true;
        }
        String sFieldName = _sFieldName.trim().toUpperCase();
        return this.m_oDBKeywords.contains(sFieldName);
    }

    public static DBManager getDBManager() {
        if (!m_oDBManager.isStarted()) {
            m_oDBManager.startup();
            if (!m_oDBManager.isStarted()) {
                System.err.println(I18NMessage.get(DBManager.class, "DBManager.label1", "\u7cfb\u7edf\u542f\u52a8\u5f02\u5e38,\u6570\u636e\u5e93\u542f\u52a8\u5931\u8d25!"));
                return null;
            }
        }
        return m_oDBManager;
    }

    private void loadConfig() {
        this.setDBConfig(DBConnectionMapper.getInstance().getDefaultDBConnectionConfig());
    }

    private void clearConfig() {
        DBConnectionMapper.getInstance().clear();
        this.setDBConfig(null);
    }

    private boolean init() throws WCMException {
        if (!this.initConfig()) {
            return false;
        }
        this.loadConfig();
        this.initDBPool();
        if (!this.loadSystemInfo()) {
            return false;
        }
        this.initTableInfos();
        this.initDBIdManager();
        this.initDBKeywords();
        return true;
    }

    private boolean initConfig() {
        return true;
    }

    private boolean loadSystemInfo() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initDBKeywords() {
        Connection conn = null;
        try {
            conn = this.getConnection();
            this.m_oDBKeywords = new HashSet(100);
            String[] pKeywords = conn.getMetaData().getSQLKeywords().split(",");
            String kw = null;
            int len = pKeywords.length;
            for (int i = 0; i < len; ++i) {
                kw = pKeywords[i].trim().toUpperCase();
                this.m_oDBKeywords.add(kw);
            }
            ResourceBundle rb = ResourceBundle.getBundle("WCMDBKeyWords");
            Enumeration<String> enuKeys = rb.getKeys();
            while (enuKeys.hasMoreElements()) {
                this.m_oDBKeywords.add(enuKeys.nextElement());
            }
        }
        catch (Exception e) {
            logger.error((Object)"init DB keywords fail!", (Throwable)e);
        }
        finally {
            this.freeConnection(conn);
        }
    }

    public Set getDBKeywords() {
        HashSet result = new HashSet(this.m_oDBKeywords.size());
        result.addAll(this.m_oDBKeywords);
        return result;
    }

    public Iterator iteratorKeywords() {
        return this.m_oDBKeywords.iterator();
    }

    private void release() {
        this.clearDBIdManager();
        this.clearTableInfos();
        this.closeDBPool();
        this.clearConfig();
        this.clearDBKeywords();
    }

    private void clearDBKeywords() {
        if (this.m_oDBKeywords != null) {
            this.m_oDBKeywords.clear();
        }
    }

    private synchronized void initDBPool() throws WCMException {
        if (this.m_oDBPool != null) {
            return;
        }
        DBType currDBType = this.getDBConnConfig().getDBType();
        String sDriverClass = currDBType.getDriverClass();
        if (sDriverClass == null) {
            throw new WCMException(10, I18NMessage.get(DBManager.class, "DBManager.label5", "\u521d\u59cb\u5316\u4fe1\u606f\u914d\u7f6e\uff1aDBTYPE\u6307\u5b9a\u7684\u6570\u636e\u5e93\u7c7b\u578b\u65e0\u6548\uff08\u503c=") + this.getDBConnConfig() + "\uff09");
        }
        try {
            this.m_oDBPool = new ConnectionPool(this.getDBConnConfig());
        }
        catch (SQLException ex) {
            logger.error((Object)(I18NMessage.get(DBManager.class, "DBManager.label6", "\u8fde\u63a5\u7f13\u51b2\u6c60\u521d\u59cb\u5316\u5931\u8d25: \nDB:") + this.getDBConnConfig().getConnectionURL()), (Throwable)ex);
            throw new WCMException(41, I18NMessage.get(DBManager.class, "DBManager.label7", "\u8fde\u63a5\u6570\u636e\u5e93\u51fa\u73b0\u5f02\u5e38\uff01\u6570\u636e\u5e93\u4fe1\u606f\u4e3a\uff1a") + this.getDBConnConfig(), ex);
        }
        logger.info((Object)(I18NMessage.get(DBManager.class, "DBManager.label8", "\u8fde\u63a5\u7f13\u51b2\u6c60\u521d\u59cb\u5316\u6210\u529f: DBURL=") + this.getDBConnConfig().getConnectionURL()));
    }

    private void closeDBPool() {
        if (this.m_oDBPool == null) {
            return;
        }
        this.m_oDBPool.close();
        this.m_oDBPool = null;
    }

    public DBConnectionConfig getDBConnConfig() {
        return this.m_oDBConnConfig;
    }

    public void setDBConfig(DBConnectionConfig config) {
        this.m_oDBConnConfig = config;
    }

    public Connection getConnection() throws WCMException {
        Connection oConn = null;
        try {
            oConn = this.getDBPool().getConnection();
        }
        catch (Exception ex) {
            throw new WCMException(41, I18NMessage.get(DBManager.class, "DBManager.label9", "\u83b7\u53d6\u6570\u636e\u5e93\u8fde\u63a5\u65f6\u5931\u8d25(Application.getConnection)"), ex);
        }
        if (oConn == null) {
            throw new WCMException(41, I18NMessage.get(DBManager.class, "DBManager.label10", "\u6ca1\u6709\u627e\u5230\u6709\u6548\u53ef\u7528\u7684\u6570\u636e\u5e93\u8fde\u63a5(Application.getConnection)"));
        }
        return oConn;
    }

    public FieldInfo getFieldInfo(String _tableName, String _fieldName) throws WCMException {
        return this.getTableInfos().getFieldInfo(_tableName, _fieldName);
    }

    public TableInfo getTableInfo(String _tableName) throws WCMException {
        return this.getTableInfos().getTableInfo(_tableName);
    }

    public DBType getDBType() {
        return this.getDBConnConfig().getDBType();
    }

    public int getDBTypeAsInt() {
        return this.getDBType().getType();
    }

    private synchronized void initTableInfos() throws WCMException {
        if (this.m_oTableInfos == null) {
            this.m_oTableInfos = new TableInfos();
        } else {
            this.m_oTableInfos.clear();
        }
        Connection oConn = null;
        try {
            oConn = this.getDBPool().getConnection();
            this.m_oTableInfos.load(oConn, this.getDBConnConfig().getDBType(), this.getDBConnConfig().getConnectionUser().toUpperCase());
            logger.info((Object)I18NMessage.get(DBManager.class, "DBManager.label11", "\u88c5\u8f7d\u6570\u636e\u5e93\u5b57\u6bb5\u914d\u7f6e\u4fe1\u606f\u6210\u529f\uff01"));
        }
        catch (Exception ex) {
            throw new WCMException(1100, I18NMessage.get(DBManager.class, "DBManager.label12", "\u88c5\u8f7d\u6570\u636e\u5e93\u5b57\u6bb5\u914d\u7f6e\u4fe1\u606f\u5931\u8d25(Application.start)"), ex);
        }
        finally {
            if (oConn != null) {
                this.freeConnection(oConn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyAddTable(String _sTableName) throws WCMException {
        if (_sTableName == null || (_sTableName = _sTableName.trim()).length() == 0) {
            throw new WCMException(10, I18NMessage.get(DBManager.class, "DBManager.label13", "\u65e0\u6548\u7684\u6570\u636e\u5e93\u540d\u79f0!"));
        }
        Connection conn = this.getConnection();
        try {
            this.getTableInfos().notifyAddTable(conn, this.getDBType(), this.getDBConnConfig().getConnectionUser().toUpperCase(), _sTableName);
        }
        catch (CMyException e) {
            e.printStackTrace();
        }
        finally {
            if (conn == null) {
                this.freeConnection(conn);
            }
        }
    }

    public void notifyRemoveTable(String _sTableName) throws WCMException {
        this.getTableInfos().notifyRemoveTable(_sTableName);
    }

    private synchronized void clearTableInfos() {
        if (this.m_oTableInfos == null) {
            return;
        }
        this.m_oTableInfos.clear();
    }

    private synchronized void initDBIdManager() throws WCMException {
        if (this.m_oDbIdManager == null) {
            this.m_oDbIdManager = new DBIdManager();
        }
        Connection oConn = null;
        try {
            oConn = this.getDBPool().getConnection();
            this.m_oDbIdManager.load(oConn, this.getDBType().sqlGetNextId());
            logger.info((Object)I18NMessage.get(DBManager.class, "DBManager.label14", "\u88c5\u8f7d\u6570\u636e\u5e93ID\u5b57\u6bb5\u4fe1\u606f\u6210\u529f\uff01"));
        }
        catch (Exception ex) {
            throw new WCMException(1100, I18NMessage.get(DBManager.class, "DBManager.label15", "\u88c5\u8f7d\u6570\u636e\u5e93ID\u5b57\u6bb5\u4fe1\u606f\u5931\u8d25(Application.start)"), ex);
        }
        finally {
            if (oConn != null) {
                this.freeConnection(oConn);
            }
        }
    }

    private synchronized void clearDBIdManager() {
        if (this.m_oDbIdManager == null) {
            return;
        }
        this.m_oDbIdManager = null;
    }

    public void freeConnection(Connection _oConn) {
        if (this.m_oDBPool == null) {
            return;
        }
        this.m_oDBPool.free(_oConn);
    }

    public String toDBInfo() throws WCMException {
        String sInfo = I18NMessage.get(DBManager.class, "DBManager.label16", "\u5f53\u524d\u6570\u636e\u5e93\u4fe1\u606f\u4e3a\uff1a\nDBConfig:") + this.getDBConnConfig() + "\nDBPool:" + this.getDBPool() + "\nTableInfos:" + this.m_oTableInfos + "\n";
        return sInfo;
    }

    public ConnectionCache getConnectionCache() throws WCMException {
        return this.getDBPool().getConnectionCache();
    }

    private ConnectionPool getDBPool() throws WCMException {
        if (this.m_oDBPool == null) {
            this.initDBPool();
        }
        return this.m_oDBPool;
    }

    public DBIdManager getDBIdManager() throws WCMException {
        if (this.m_oDbIdManager == null) {
            this.initDBIdManager();
        }
        return this.m_oDbIdManager;
    }

    public TableInfos getTableInfos() throws WCMException {
        if (this.m_oTableInfos == null) {
            this.initTableInfos();
        }
        return this.m_oTableInfos;
    }

    @Override
    protected void doShutdown() {
        this.release();
    }

    @Override
    protected boolean doStart() throws WCMException {
        return this.init();
    }

    public boolean sqlExecUpdateProcedure(String _strProc) throws WCMException {
        if (_strProc == null) {
            return false;
        }
        Connection oConn = null;
        Statement proc = null;
        try {
            oConn = this.getConnection();
            proc = oConn.prepareCall("{ call " + _strProc + "  }");
            boolean bl = proc.execute();
            return bl;
        }
        catch (Exception ex) {
            throw new WCMException(1100, I18NMessage.get(DBManager.class, "DBManager.label17", "\u6267\u884c\u6307\u5b9a\u7684\u5b58\u50a8\u8fc7\u7a0b\u5931\u8d25") + _strProc + "\uff08Application._sqlExecUpdateProcedure\uff09", ex);
        }
        finally {
            if (oConn != null) {
                this.freeConnection(oConn);
            }
            if (proc != null) {
                try {
                    proc.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public ResultSet sqlExecuteQuery(String _strSQL) throws WCMException {
        return this.sqlExecuteQuery(_strSQL, 0);
    }

    public ResultSet sqlExecuteQuery(String _strSQL, int _nMaxSize) throws WCMException {
        if (_strSQL.length() < 5) {
            return null;
        }
        InjectSQLHelper.validSQL(_strSQL, null);
        Connection oConn = null;
        Statement oStmt = null;
        ResultSet rsData = null;
        try {
            oConn = this.getConnection();
            oStmt = oConn.createStatement();
            if (_nMaxSize > 0) {
                oStmt.setMaxRows(_nMaxSize);
            }
            rsData = oStmt.executeQuery(_strSQL);
        }
        catch (SQLException ex) {
            throw new WCMException(40, I18NMessage.get(DBManager.class, "DBManager.label18", "\u67e5\u8be2\u6570\u636e\u5931\u8d25app._sqlExecuteQuery\uff1aSQL=") + _strSQL, ex);
        }
        catch (Exception ex) {
            throw new WCMException(0, I18NMessage.get(DBManager.class, "DBManager.label18", "\u67e5\u8be2\u6570\u636e\u5931\u8d25app._sqlExecuteQuery\uff1aSQL=") + _strSQL, ex);
        }
        finally {
            if (oConn != null) {
                this.freeConnection(oConn);
            }
        }
        return rsData;
    }

    public int sqlExecuteIntQuery(String _strSQL) throws WCMException {
        if (_strSQL.length() < 5) {
            return -999;
        }
        InjectSQLHelper.validSQL(_strSQL, null);
        int nResult = -999;
        Connection oConn = null;
        Statement oStmt = null;
        ResultSet rsData = null;
        try {
            oConn = this.getConnection();
            oStmt = oConn.createStatement();
            oStmt.setMaxRows(1);
            rsData = oStmt.executeQuery(_strSQL);
            if (rsData.next()) {
                nResult = rsData.getInt(1);
            }
        }
        catch (SQLException ex) {
            throw new WCMException(40, I18NMessage.get(DBManager.class, "DBManager.label18", "\u67e5\u8be2\u6570\u636e\u5931\u8d25app._sqlExecuteQuery\uff1aSQL=") + _strSQL, ex);
        }
        catch (Exception ex) {
            throw new WCMException(0, I18NMessage.get(DBManager.class, "DBManager.label18", "\u67e5\u8be2\u6570\u636e\u5931\u8d25app._sqlExecuteQuery\uff1aSQL=") + _strSQL, ex);
        }
        finally {
            try {
                if (oConn != null) {
                    this.freeConnection(oConn);
                }
                if (oStmt != null) {
                    oStmt.close();
                }
                if (rsData != null) {
                    rsData.close();
                }
            }
            catch (Exception exception) {}
        }
        return nResult;
    }

    public int sqlExecuteIntQuery(WCMFilter _filter) throws WCMException {
        if (_filter == null) {
            return -999;
        }
        String sSQL = _filter.toSQL();
        List lParameters = _filter.getSearchValues();
        return this.sqlExecuteIntQuery(sSQL, lParameters);
    }

    public int sqlExecuteIntQuery(String _sSQL, List _lParameters) throws WCMException {
        InjectSQLHelper.validSQL(_sSQL, _lParameters);
        int nResult = -999;
        Connection oConn = null;
        PreparedStatement oStmt = null;
        ResultSet rsData = null;
        try {
            oConn = this.getConnection();
            oStmt = oConn.prepareStatement(_sSQL);
            oStmt.setMaxRows(1);
            DBManager.setParameters(oStmt, _lParameters);
            rsData = oStmt.executeQuery();
            if (rsData.next()) {
                nResult = rsData.getInt(1);
            }
        }
        catch (SQLException ex) {
            throw new WCMException(40, I18NMessage.get(DBManager.class, "DBManager.label19", "\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff1aSQL=") + _sSQL, ex);
        }
        catch (Exception ex) {
            throw new WCMException(0, I18NMessage.get(DBManager.class, "DBManager.label19", "\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff1aSQL=") + _sSQL, ex);
        }
        finally {
            try {
                if (oConn != null) {
                    this.freeConnection(oConn);
                }
                if (oStmt != null) {
                    oStmt.close();
                }
                if (rsData != null) {
                    rsData.close();
                }
            }
            catch (Exception exception) {}
        }
        return nResult;
    }

    public long sqlExecuteQuery(String _sSQL, List _lParameters, long _lDefault) throws WCMException {
        InjectSQLHelper.validSQL(_sSQL, _lParameters);
        Connection oConn = null;
        PreparedStatement oStmt = null;
        ResultSet rsData = null;
        try {
            oConn = this.getConnection();
            oStmt = oConn.prepareStatement(_sSQL);
            oStmt.setMaxRows(1);
            DBManager.setParameters(oStmt, _lParameters);
            rsData = oStmt.executeQuery();
            if (rsData.next()) {
                long l = rsData.getLong(1);
                return l;
            }
        }
        catch (SQLException ex) {
            throw new WCMException(40, I18NMessage.get(DBManager.class, "DBManager.label19", "\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff1aSQL=") + _sSQL, ex);
        }
        catch (Exception ex) {
            throw new WCMException(0, I18NMessage.get(DBManager.class, "DBManager.label19", "\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff1aSQL=") + _sSQL, ex);
        }
        finally {
            try {
                if (oConn != null) {
                    this.freeConnection(oConn);
                }
                if (oStmt != null) {
                    oStmt.close();
                }
                if (rsData != null) {
                    rsData.close();
                }
            }
            catch (Exception exception) {}
        }
        return _lDefault;
    }

    public int sqlExecuteQuery(String _sSQL, List _lParameters, int _lDefault) throws WCMException {
        InjectSQLHelper.validSQL(_sSQL, _lParameters);
        Connection oConn = null;
        PreparedStatement oStmt = null;
        ResultSet rsData = null;
        try {
            oConn = this.getConnection();
            oStmt = oConn.prepareStatement(_sSQL);
            oStmt.setMaxRows(1);
            DBManager.setParameters(oStmt, _lParameters);
            rsData = oStmt.executeQuery();
            if (rsData.next()) {
                int n = rsData.getInt(1);
                return n;
            }
        }
        catch (SQLException ex) {
            throw new WCMException(40, I18NMessage.get(DBManager.class, "DBManager.label19", "\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff1aSQL=") + _sSQL, ex);
        }
        catch (Exception ex) {
            throw new WCMException(0, I18NMessage.get(DBManager.class, "DBManager.label19", "\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff1aSQL=") + _sSQL, ex);
        }
        finally {
            try {
                if (oConn != null) {
                    this.freeConnection(oConn);
                }
                if (oStmt != null) {
                    oStmt.close();
                }
                if (rsData != null) {
                    rsData.close();
                }
            }
            catch (Exception exception) {}
        }
        return _lDefault;
    }

    public int[] sqlExecuteIntsQuery(WCMFilter _filter) throws WCMException {
        if (_filter == null) {
            return new int[0];
        }
        WCMFilter countFilter = new WCMFilter(_filter);
        countFilter.setSelect("count(" + countFilter.getSelect() + ")");
        int nCount = this.sqlExecuteIntQuery(countFilter);
        if (nCount <= 0) {
            return new int[0];
        }
        Connection oConn = null;
        PreparedStatement oStmt = null;
        ResultSet rsData = null;
        int[] pResults = new int[nCount];
        try {
            oConn = this.getConnection();
            oStmt = oConn.prepareStatement(_filter.toSQL());
            DBManager.setParameters(oStmt, _filter.getSearchValues());
            int index = 0;
            rsData = oStmt.executeQuery();
            while (rsData.next()) {
                if (index >= pResults.length) {
                    int[] pTemp = new int[pResults.length + 1];
                    System.arraycopy(pResults, 0, pTemp, 0, pResults.length);
                    pResults = pTemp;
                }
                pResults[index++] = rsData.getInt(1);
            }
        }
        catch (SQLException ex) {
            throw new WCMException(40, I18NMessage.get(DBManager.class, "DBManager.label19", "\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff1aSQL=") + _filter.toSQL(), ex);
        }
        catch (Exception ex) {
            throw new WCMException(0, I18NMessage.get(DBManager.class, "DBManager.label19", "\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff1aSQL=") + _filter.toSQL(), ex);
        }
        finally {
            try {
                if (oConn != null) {
                    this.freeConnection(oConn);
                }
                if (oStmt != null) {
                    oStmt.close();
                }
                if (rsData != null) {
                    rsData.close();
                }
            }
            catch (Exception exception) {}
        }
        return pResults;
    }

    public String[] sqlExecuteStringsQuery(WCMFilter _filter) throws WCMException {
        if (_filter == null) {
            return new String[0];
        }
        WCMFilter countFilter = new WCMFilter(_filter);
        countFilter.setSelect("count(" + countFilter.getSelect() + ")");
        int nCount = this.sqlExecuteIntQuery(countFilter);
        if (nCount <= 0) {
            return new String[0];
        }
        String[] pResults = new String[nCount];
        Connection oConn = null;
        PreparedStatement oStmt = null;
        ResultSet rsData = null;
        try {
            oConn = this.getConnection();
            oStmt = oConn.prepareStatement(_filter.toSQL());
            DBManager.setParameters(oStmt, _filter.getSearchValues());
            int index = 0;
            rsData = oStmt.executeQuery();
            while (rsData.next()) {
                if (index >= pResults.length) {
                    String[] pTemp = new String[pResults.length + 1];
                    System.arraycopy(pResults, 0, pTemp, 0, pResults.length);
                    pResults = pTemp;
                }
                pResults[index++] = rsData.getString(1);
            }
        }
        catch (SQLException ex) {
            throw new WCMException(40, I18NMessage.get(DBManager.class, "DBManager.label19", "\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff1aSQL=") + _filter.toSQL(), ex);
        }
        catch (Exception ex) {
            throw new WCMException(0, I18NMessage.get(DBManager.class, "DBManager.label19", "\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff1aSQL=") + _filter.toSQL(), ex);
        }
        finally {
            try {
                if (oConn != null) {
                    this.freeConnection(oConn);
                }
                if (oStmt != null) {
                    oStmt.close();
                }
                if (rsData != null) {
                    rsData.close();
                }
            }
            catch (Exception exception) {}
        }
        return pResults;
    }

    public int sqlExecuteCountQuery(WCMFilter _filter) throws WCMException {
        if (_filter == null) {
            return -999;
        }
        int nResult = -999;
        Connection oConn = null;
        PreparedStatement oStmt = null;
        ResultSet rsData = null;
        try {
            oConn = this.getConnection();
            oStmt = oConn.prepareStatement(_filter.toCountSQL());
            oStmt.setMaxRows(1);
            DBManager.setParameters(oStmt, _filter.getSearchValues());
            rsData = oStmt.executeQuery();
            if (rsData.next()) {
                nResult = rsData.getInt(1);
            }
        }
        catch (SQLException ex) {
            throw new WCMException(40, I18NMessage.get(DBManager.class, "DBManager.label19", "\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff1aSQL=") + _filter.toSQL(), ex);
        }
        catch (Exception ex) {
            throw new WCMException(0, I18NMessage.get(DBManager.class, "DBManager.label19", "\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff1aSQL=") + _filter.toSQL(), ex);
        }
        finally {
            try {
                if (oConn != null) {
                    this.freeConnection(oConn);
                }
                if (oStmt != null) {
                    oStmt.close();
                }
                if (rsData != null) {
                    rsData.close();
                }
            }
            catch (Exception exception) {}
        }
        return nResult;
    }

    public int sqlExecuteUpdate(String[] _strSQLs) throws WCMException {
        if (_strSQLs.length < 1) {
            return 0;
        }
        Connection oConn = null;
        Statement oStmt = null;
        int i = -1;
        int nRet = 0;
        try {
            oConn = this.getConnection();
            oStmt = oConn.createStatement();
            for (i = 0; i < _strSQLs.length; ++i) {
                if (_strSQLs[i] == null) continue;
                nRet = oStmt.executeUpdate(_strSQLs[i]);
            }
            int n = nRet;
            return n;
        }
        catch (Exception ex) {
            throw new WCMException(1100, I18NMessage.get(DBManager.class, "DBManager.label20", "\u6267\u884cSQL\u8bed\u53e5\u5931\u8d25") + (i >= 0 ? ":" + _strSQLs[0] : "") + "\uff08Application._sqlExecuteUpdate\uff09", ex);
        }
        finally {
            if (oConn != null) {
                this.freeConnection(oConn);
            }
            if (oStmt != null) {
                try {
                    oStmt.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public int sqlExecuteUpdate(String _strSQL) throws WCMException {
        if (_strSQL == null) {
            return 0;
        }
        Connection oConn = null;
        Statement oStmt = null;
        int nRet = 0;
        try {
            oConn = this.getConnection();
            oStmt = oConn.createStatement();
            int n = nRet = oStmt.executeUpdate(_strSQL);
            return n;
        }
        catch (Exception ex) {
            throw new WCMException(1100, I18NMessage.get(DBManager.class, "DBManager.label20", "\u6267\u884cSQL\u8bed\u53e5\u5931\u8d25") + _strSQL + "\uff08Application._sqlExecuteUpdate\uff09", ex);
        }
        finally {
            if (oConn != null) {
                this.freeConnection(oConn);
            }
            if (oStmt != null) {
                try {
                    oStmt.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void sqlExecuteUpdate(int[] _pParamerters, String ... _pUpdateSQL) throws WCMException {
        this.sqlExecuteUpdate(_pUpdateSQL, _pParamerters);
    }

    public void sqlExecuteUpdate(String[] _pUpdateSQL, int[] _pParamerters) throws WCMException {
        Connection conn = this.getConnection();
        Statement preStm = null;
        int i = -1;
        try {
            if (!conn.getAutoCommit()) {
                logger.error((Object)"sqlExecuteUpdate not  autocommit");
            }
            for (i = 0; i < _pUpdateSQL.length; ++i) {
                if (_pUpdateSQL[i] == null) continue;
                preStm = conn.prepareStatement(_pUpdateSQL[i]);
                for (int j = 0; j < _pParamerters.length; ++j) {
                    preStm.setInt(j + 1, _pParamerters[j]);
                }
                preStm.executeUpdate();
                preStm.close();
                preStm = null;
            }
        }
        catch (Exception e) {
            throw new WCMException(I18NMessage.get(DBManager.class, "DBManager.label21", "\u6267\u884c") + _pUpdateSQL[i] + I18NMessage.get(DBManager.class, "DBManager.label22", "\u5931\u8d25\uff01"), e);
        }
        finally {
            if (preStm != null) {
                try {
                    preStm.close();
                }
                catch (Exception exception) {}
            }
            this.freeConnection(conn);
        }
    }

    public void sqlExecuteUpdate(String[] _pUpdateSQL, String[] _pParamerters) throws WCMException {
        this.sqlExecuteUpdate(_pUpdateSQL, (Object[])_pParamerters);
    }

    public void sqlExecuteUpdateNew(Object[] _pParamerters, String ... _pUpdateSQL) throws WCMException {
        this.sqlExecuteUpdate(_pUpdateSQL, _pParamerters);
    }

    public void sqlExecuteUpdate(Object[] _pParamerters, String ... _pUpdateSQL) throws WCMException {
        this.sqlExecuteUpdate(_pUpdateSQL, _pParamerters);
    }

    public void sqlExecuteUpdate(String[] _pUpdateSQL, Object[] _pParamerters) throws WCMException {
        int i;
        Connection conn = this.getConnection();
        Statement preStm = null;
        int j = 0;
        try {
            for (i = 0; i < _pUpdateSQL.length; ++i) {
                if (_pUpdateSQL[i] == null) continue;
                preStm = conn.prepareStatement(_pUpdateSQL[i]);
                for (j = 0; j < _pParamerters.length; ++j) {
                    if (_pParamerters[j] instanceof CMyDateTime) {
                        preStm.setTimestamp(j + 1, ((CMyDateTime)_pParamerters[j]).toTimestamp());
                        continue;
                    }
                    preStm.setObject(j + 1, _pParamerters[j]);
                }
                preStm.executeUpdate();
                preStm.close();
                preStm = null;
            }
        }
        catch (Exception e) {
            throw new WCMException(I18NMessage.get(DBManager.class, "DBManager.label23", "\u8bbe\u7f6eParamer#") + (j + 1) + I18NMessage.get(DBManager.class, "DBManager.label24", "\u5931\u8d25\uff01\nSQL=") + _pUpdateSQL[i], e);
        }
        finally {
            if (preStm != null) {
                try {
                    preStm.close();
                }
                catch (Exception exception) {}
            }
            this.freeConnection(conn);
        }
    }

    public static void setParameters(PreparedStatement _oPreStmt, List listSearchValues) throws WCMException {
        if (_oPreStmt == null || listSearchValues == null || listSearchValues.size() <= 0) {
            return;
        }
        DBType currDbType = DBManager.getDBManager().getDBType();
        Object value = null;
        int i = 0;
        try {
            int nSize = listSearchValues.size();
            for (i = 0; i < nSize; ++i) {
                value = listSearchValues.get(i);
                if (value == null) continue;
                if (value instanceof Long) {
                    _oPreStmt.setLong(i + 1, (Long)value);
                    continue;
                }
                if (value instanceof Float) {
                    _oPreStmt.setFloat(i + 1, ((Float)value).floatValue());
                    continue;
                }
                if (value instanceof Double) {
                    _oPreStmt.setDouble(i + 1, (Double)value);
                    continue;
                }
                if (value instanceof Integer) {
                    _oPreStmt.setInt(i + 1, (Integer)value);
                    continue;
                }
                if (value instanceof String) {
                    currDbType.setStringFieldValue(_oPreStmt, i + 1, value);
                    continue;
                }
                if (value instanceof CMyDateTime) {
                    _oPreStmt.setTimestamp(i + 1, ((CMyDateTime)value).toTimestamp());
                    continue;
                }
                if (value instanceof CDBText) {
                    _oPreStmt.setString(i + 1, ((CDBText)value).getText());
                    continue;
                }
                throw new WCMException(1103, I18NMessage.get(DBManager.class, "DBManager.label25", "\u672a\u77e5\u7684\u5bf9\u8c61") + (i + 1) + I18NMessage.get(DBManager.class, "DBManager.label26", "\u5c5e\u6027\u7c7b\u578b"));
            }
        }
        catch (SQLException ex) {
            throw new WCMException(40, I18NMessage.get(DBManager.class, "DBManager.label27", "\u67e5\u8be2\u6570\u636e\u5e93\uff0c\u586b\u5199PreparedStatement\u53c2\u6570[Index=") + (i + 1) + ", value=" + value + I18NMessage.get(DBManager.class, "DBManager.label28", "]\u65f6\u51fa\u9519"), ex);
        }
        catch (Exception ex) {
            throw new WCMException(0, I18NMessage.get(DBManager.class, "DBManager.label27", "\u67e5\u8be2\u6570\u636e\u5e93\uff0c\u586b\u5199PreparedStatement\u53c2\u6570[Index=") + (i + 1) + ", value=" + value + I18NMessage.get(DBManager.class, "DBManager.label28", "]\u65f6\u51fa\u9519"), ex);
        }
    }

    public int sqlExecuteIntQuery(String _sQuerySQL, int[] _pParamerters) throws WCMException {
        InjectSQLHelper.validSQL(_sQuerySQL, _pParamerters);
        int nResult = -999;
        Connection conn = this.getConnection();
        PreparedStatement preStm = null;
        ResultSet rsData = null;
        try {
            preStm = conn.prepareStatement(_sQuerySQL);
            for (int j = 0; j < _pParamerters.length; ++j) {
                preStm.setInt(j + 1, _pParamerters[j]);
            }
            preStm.setMaxRows(1);
            rsData = preStm.executeQuery();
            if (rsData.next()) {
                nResult = rsData.getInt(1);
            }
            rsData.close();
            rsData = null;
            preStm.close();
            preStm = null;
        }
        catch (Exception e) {
            throw new WCMException(I18NMessage.get(DBManager.class, "DBManager.label29", "\u6267\u884cSQL\u5931\u8d25\uff01"), e);
        }
        finally {
            if (rsData != null) {
                try {
                    rsData.close();
                }
                catch (Exception exception) {}
            }
            if (preStm != null) {
                try {
                    preStm.close();
                }
                catch (Exception exception) {}
            }
            this.freeConnection(conn);
        }
        return nResult;
    }

    public String sqlExecuteStringQuery(String _sQuerySQL, int[] _pParamerters) throws WCMException {
        InjectSQLHelper.validSQL(_sQuerySQL, _pParamerters);
        String sResult = null;
        Connection conn = this.getConnection();
        PreparedStatement preStm = null;
        ResultSet rsData = null;
        try {
            preStm = conn.prepareStatement(_sQuerySQL);
            for (int j = 0; j < _pParamerters.length; ++j) {
                preStm.setInt(j + 1, _pParamerters[j]);
            }
            preStm.setMaxRows(1);
            rsData = preStm.executeQuery();
            if (rsData.next()) {
                sResult = rsData.getString(1);
            }
            rsData.close();
            rsData = null;
            preStm.close();
            preStm = null;
        }
        catch (Exception e) {
            throw new WCMException(I18NMessage.get(DBManager.class, "DBManager.label29", "\u6267\u884cSQL\u5931\u8d25\uff01"), e);
        }
        finally {
            if (rsData != null) {
                try {
                    rsData.close();
                }
                catch (Exception exception) {}
            }
            if (preStm != null) {
                try {
                    preStm.close();
                }
                catch (Exception exception) {}
            }
            this.freeConnection(conn);
        }
        return sResult;
    }

    public static void setParameters(PreparedStatement _oPreStmt, WCMFilter filter) throws WCMException {
        if (_oPreStmt == null || filter == null) {
            return;
        }
        List listSearchValues = filter.getSearchValues();
        DBManager.setParameters(_oPreStmt, listSearchValues);
    }

    public void reloadTableInfo(String _sTableName) throws WCMException {
        this.reloadTableInfo(_sTableName, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void reloadTableInfo(String _sTableName, boolean _bSendMsgOfCluster) throws WCMException {
        if (_sTableName == null || (_sTableName = _sTableName.trim()).length() == 0) {
            return;
        }
        Connection oConn = this.getConnection();
        try {
            this.getTableInfos().load(oConn, this.getDBType(), this.getDBConnConfig().getConnectionUser().toUpperCase(), _sTableName);
        }
        catch (Exception ex) {
            if (_bSendMsgOfCluster) throw new WCMException(1100, I18NMessage.get(DBManager.class, "DBManager.label32", "\u88c5\u8f7d\u6307\u5b9a\u8868[") + _sTableName + I18NMessage.get(DBManager.class, "DBManager.label33", "]\u5931\u8d25\uff01"), ex);
            logger.warn((Object)"Reload failed, sleep 300ms & take a second shot.", (Throwable)ex);
            try {
                Thread.sleep(300L);
                this.getTableInfos().load(oConn, this.getDBType(), this.getDBConnConfig().getConnectionUser().toUpperCase(), _sTableName);
                return;
            }
            catch (Exception exception) {
                throw new WCMException(1100, I18NMessage.get(DBManager.class, "DBManager.label32", "\u88c5\u8f7d\u6307\u5b9a\u8868[") + _sTableName + I18NMessage.get(DBManager.class, "DBManager.label33", "]\u5931\u8d25\uff01"), ex);
            }
        }
        finally {
            if (oConn != null) {
                this.freeConnection(oConn);
            }
        }
        if (!_bSendMsgOfCluster) {
            return;
        }
        try {
            IClusterMsgCenter clusterMsgCenter = (IClusterMsgCenter)DreamFactory.createObjectById("IClusterMsgCenter");
            clusterMsgCenter.send("RELOAD.TABLE", new String[]{_sTableName});
            return;
        }
        catch (Exception e) {
            throw new WCMException("\u96c6\u7fa4\u5e7f\u64ad\u6d88\u606f\u5931\u8d25\uff01", e);
        }
    }

    public static void main(String[] args) {
        System.out.println(DBManager.getDBManager().isKeywords("WHILE"));
        try {
            DBManager.getDBManager().setServerName(I18NMessage.get(DBManager.class, "DBManager.label34", "\u6570\u636e\u5e93\u7ba1\u7406\u5668\uff01"));
            DBManager.getDBManager().startup();
            logger.info((Object)DBManager.getDBManager().toDBInfo());
            DBManager.getDBManager().shutdown();
        }
        catch (Exception ex) {
            logger.error((Object)I18NMessage.get(DBManager.class, "DBManager.label35", "\u6d4b\u8bd5\u5931\u8d25\uff01"), (Throwable)ex);
        }
    }
}

