/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.persistent.db;

import com.trs.infra.I18NMessage;
import com.trs.infra.config.persistent.IConfigElement;
import com.trs.infra.util.database.DBType;

public class DBConnectionConfig
implements IConfigElement {
    private String m_sName;
    private String m_sClassName;
    private String m_sConnectionURL;
    private String m_sConnectionUser;
    private String m_sConnectionPassword;
    private String m_sCacheScheme;
    private int m_nInitConnects;
    private int m_nMaxConnects;
    private int m_iTimeToLiveOverUse = -1;
    private boolean m_bWaitIfBusy;
    private boolean m_bDowithClob;
    private boolean m_zTraceAssign;
    private String m_sTestSQL;
    private boolean m_zTestOnAssign;
    private boolean m_zTestOnIdle;
    private int m_iMaxIdleTime;
    private int m_iMonitorInterval;
    private int m_iMaxOrphanTime;
    private DBType m_oDbType = null;

    @Override
    public void setName(String _sName) {
        this.m_sName = _sName;
    }

    @Override
    public String getName() {
        return this.m_sName;
    }

    public boolean isWaitIfBusy() {
        return this.m_bWaitIfBusy;
    }

    public void setWaitIfBusy(boolean waitIfBusy) {
        this.m_bWaitIfBusy = waitIfBusy;
    }

    public int getInitConnects() {
        return this.m_nInitConnects;
    }

    public void setInitConnects(int initConnects) {
        this.m_nInitConnects = initConnects;
    }

    public int getMaxConnects() {
        return this.m_nMaxConnects;
    }

    public void setMaxConnects(int maxConnects) {
        this.m_nMaxConnects = maxConnects;
    }

    public String getClassName() {
        return this.m_sClassName;
    }

    public void setClassName(String className) {
        this.m_sClassName = className;
    }

    public String getConnectionPassword() {
        return this.m_sConnectionPassword;
    }

    public void setConnectionPassword(String connectionPassword) {
        this.m_sConnectionPassword = connectionPassword;
    }

    public String getConnectionURL() {
        return this.m_sConnectionURL;
    }

    public void setConnectionURL(String connectionURL) {
        this.m_sConnectionURL = connectionURL;
    }

    public String getConnectionUser() {
        return this.m_sConnectionUser;
    }

    public void setConnectionUser(String connectionUser) {
        this.m_sConnectionUser = connectionUser;
    }

    public boolean isDowithClob() {
        return this.m_bDowithClob;
    }

    public void setDowithClob(boolean dowithClob) {
        this.m_bDowithClob = dowithClob;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBType getDBType() {
        try {
            if (this.m_oDbType == null) {
                Class<?> clazz;
                Class<?> clazz2 = clazz = Class.forName(this.getClassName());
                synchronized (clazz2) {
                    this.m_oDbType = (DBType)clazz.newInstance();
                }
            }
            return this.m_oDbType;
        }
        catch (Exception ex) {
            throw new RuntimeException(I18NMessage.get(DBConnectionConfig.class, "DBConnectionConfig.label1", "\u65e0\u6cd5\u5c06[") + this.getClassName() + I18NMessage.get(DBConnectionConfig.class, "DBConnectionConfig.label2", "]\u6784\u9020\u6210\u76f8\u5e94\u6570\u636e\u7c7b\u578b\u7684\u5b9e\u4f8b"), ex);
        }
    }

    public boolean isTraceAssign() {
        return this.m_zTraceAssign;
    }

    public void setTraceAssign(boolean traceAssign) {
        this.m_zTraceAssign = traceAssign;
    }

    public int getTimeToLiveOverUse() {
        return this.m_iTimeToLiveOverUse;
    }

    public void setTimeToLiveOverUse(int timeToLiveOverUse) {
        this.m_iTimeToLiveOverUse = timeToLiveOverUse;
    }

    public String getCacheScheme() {
        return this.m_sCacheScheme;
    }

    public void setCacheScheme(String cacheScheme) {
        this.m_sCacheScheme = cacheScheme;
    }

    public String getTestSQL() {
        return this.m_sTestSQL;
    }

    public void setTestSQL(String testSQL) {
        this.m_sTestSQL = testSQL;
    }

    public boolean isTestOnAssign() {
        return this.m_zTestOnAssign;
    }

    public void setTestOnAssign(boolean testOnAssign) {
        this.m_zTestOnAssign = testOnAssign;
    }

    public int getMaxIdleTime() {
        return this.m_iMaxIdleTime;
    }

    public void setMaxIdleTime(int maxIdleTime) {
        this.m_iMaxIdleTime = maxIdleTime;
    }

    public int getMonitorInterval() {
        return this.m_iMonitorInterval;
    }

    public void setMonitorInterval(int monitorInterval) {
        this.m_iMonitorInterval = monitorInterval;
    }

    public boolean isTestOnIdle() {
        return this.m_zTestOnIdle;
    }

    public void setTestOnIdle(boolean testOnIdle) {
        this.m_zTestOnIdle = testOnIdle;
    }

    public int getMaxOrphanTime() {
        return this.m_iMaxOrphanTime;
    }

    public void setMaxOrphanTime(int maxOrphanTime) {
        this.m_iMaxOrphanTime = maxOrphanTime;
    }
}

