/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra;

import com.trs.infra.util.CMyString;
import com.trs.infra.util.store.FileService;
import com.trs.infra.util.store.FileStore;
import com.trs.infra.util.store.FileStoreFilter;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public final class I18NMessage {
    private static final Logger LOG = Logger.getLogger(I18NMessage.class);
    private static final Map MESSAGES = new HashMap(500, 0.2f);

    public static String makeObjectNotFound(String[] args) {
        return CMyString.format(I18NMessage.get(I18NMessage.class, "I18NMessage.label1", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684{1}[ID={0}]"), args);
    }

    public static String get(Class objCls, String key, String defaultValue) {
        String pkg = objCls.getPackage().getName();
        String v = (String)MESSAGES.get(pkg + "." + key);
        if (v != null) {
            return v;
        }
        return defaultValue;
    }

    static void load(String rootDir, String lang) {
        LOG.info((Object)"load i18n message begin...");
        long start = System.currentTimeMillis();
        FileService fDir = new FileService(rootDir);
        if (!fDir.exists() || !fDir.isDirectory()) {
            throw new IllegalArgumentException("No such directory:" + rootDir);
        }
        String fn2 = "i18nmessage";
        if (lang != null) {
            // empty if block
        }
        final String fileName = fn2 = fn2 + ".properties";
        final HashSet files = new HashSet(500, 0.2f);
        fDir.listFiles(new FileStoreFilter(){

            @Override
            public boolean accept(FileStore pathname) {
                if (pathname.isDirectory()) {
                    pathname.listFiles(this);
                } else if (fileName.equals(pathname.getName())) {
                    files.add(pathname.getAbsolutePath());
                }
                return false;
            }
        });
        for (String fn2 : files) {
            I18NMessage.read(fn2);
        }
        long end = System.currentTimeMillis();
        LOG.info((Object)("i18n message loaded.time used(ms):" + (end - start)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void read(String fn) {
        InputStream ins = null;
        InputStreamReader insr = null;
        BufferedReader reader = null;
        try {
            ins = new FileService(fn).getInputStream();
            insr = new InputStreamReader(ins, "GBK");
            reader = new BufferedReader(insr);
            String line = reader.readLine();
            String pkg = line.substring(1);
            line = reader.readLine();
            while (line != null) {
                int nIndex = line.indexOf(61);
                MESSAGES.put(pkg + "." + line.substring(0, nIndex), line.substring(nIndex + 1).replaceAll("\\\\n", "\n"));
                line = reader.readLine();
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (ins != null) {
                try {
                    ins.close();
                }
                catch (Exception exception) {}
            }
            if (insr != null) {
                try {
                    insr.close();
                }
                catch (Exception exception) {}
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

