/*
 * Decompiled with CFR 0.152.
 */
package com.trs.exchange.testmove;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.components.common.publish.persistent.publisher.FolderPublishConfig;
import com.trs.components.metadata.center.MetaViewData;
import com.trs.components.metadata.center.MetaViewEmployerMgr;
import com.trs.components.metadata.definition.MetaView;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.exchange.DataMigrationLogger;
import com.trs.exchange.ExchangeHelper;
import com.trs.exchange.MyDBManager;
import com.trs.exchange.metadata.WebSiteConstants;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyString;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.WriterAppender;

public class TestMoveZJOL {
    private static Logger logger = Logger.getLogger(TestMoveZJOL.class);
    protected MyDBManager m_oDBMgr = null;
    protected FilesMan filesMan = null;
    protected DataMigrationLogger m_oDLogger = null;
    MetaViewEmployerMgr m_oMetaViewEmployerMgr = null;

    public TestMoveZJOL(MyDBManager _dbMgr) {
        this.m_oDBMgr = _dbMgr;
        this.filesMan = FilesMan.getFilesMan();
        this.m_oMetaViewEmployerMgr = (MetaViewEmployerMgr)DreamFactory.createObjectById("IMetaViewEmployerMgr");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveInfor(String sql, int orgGroup) throws Exception {
        this.initLogger(orgGroup);
        int nLasMigrationId = this.m_oDLogger.readLastInfo();
        if (nLasMigrationId == -1) {
            logger.warn((Object)("[ID=" + orgGroup + "]\u5df2\u7ecf\u8fc1\u79fb\u5b8c\uff0c\u91cd\u590d\u6267\u884c\uff01"));
            return;
        }
        logger.info((Object)("End Data Migration to [" + orgGroup + "]!"));
        Connection oConn = null;
        PreparedStatement oPreStmt = null;
        ResultSet result = null;
        int nSrcId = 0;
        try {
            oConn = this.m_oDBMgr.getConnection();
            oPreStmt = oConn.prepareStatement(sql);
            result = oPreStmt.executeQuery();
            while (result.next()) {
                Channel channel = Channel.createNewInstance();
                this.m_oDLogger.recordStartData(++nSrcId);
                ExchangeHelper.readFromRs(channel, result, result.getMetaData(), this.m_oDBMgr.getDbType());
                if (result.getInt("parent_id") == 0) {
                    channel.setParent(0);
                    channel.setName(result.getString("CHNLDESC"));
                } else {
                    WCMFilter oFilter = new WCMFilter("wcmchannel", "sourceid=?", "");
                    oFilter.addSearchValues(result.getString("parent_id"));
                    Channels channels = Channels.openWCMObjs(null, oFilter);
                    if (channels.isEmpty()) {
                        logger.info((Object)("\u7b2c" + nSrcId + "\u6761\u6570\u636e\u627e\u4e0d\u5230\u7236\u8282\u70b9"));
                        continue;
                    }
                    Channel channel1 = (Channel)channels.getAt(0);
                    int nId = channel1.getId();
                    channel.setParent(nId);
                    String sName = channel1.getDesc();
                    channel.setName(sName + "_" + result.getString("CHNLDESC"));
                }
                WCMFilter oFilter1 = new WCMFilter("wcmchannel", "chnlname=? ", "");
                oFilter1.addSearchValues(channel.getName());
                Channels channels1 = Channels.openWCMObjs(null, oFilter1);
                if (!channels1.isEmpty()) {
                    Channel mChannel = (Channel)channels1.getAt(0);
                    this.m_oDLogger.ZjolChannel(result.getString("SOURCEID"));
                    continue;
                }
                channel.save();
                String sDataPath = result.getString("full_path_name");
                sDataPath = sDataPath.substring(1, sDataPath.length() - 1);
                sDataPath = sDataPath.substring(sDataPath.lastIndexOf("/") + 1);
                FolderPublishConfig oConfig = FolderPublishConfig.createNewInstance();
                oConfig.setFolder(101, channel.getId());
                oConfig.setDataPath("" + sDataPath);
                oConfig.save();
                int nViewId = WebSiteConstants.getWebSiteMetaViewId();
                MetaView oMetaView = MetaView.findById(nViewId);
                if (null == oMetaView) {
                    throw new WCMException("\u7cfb\u7edf\u4e2d\u627e\u4e0d\u5230\u89c6\u56feID\u4e3a\u3010" + nViewId + "\u3011\u7684\u89c6\u56fe");
                }
                this.m_oMetaViewEmployerMgr.setEmployer(ContextHelper.getLoginUser(), channel, oMetaView);
                this.m_oDLogger.recordEndData(nSrcId);
            }
        }
        catch (Exception ex) {
            if (nSrcId > 0) {
                this.error("\u5904\u7406\u8fd9\u6761\u6570\u636e\u51fa\u73b0\u95ee\u9898\uff01[\u6570\u636eID=" + nSrcId + "]", ex);
            } else {
                this.error("\u67e5\u8be2\u6570\u636e\u51fa\u73b0\u95ee\u9898\uff1f[SQL=" + sql + "]", ex);
            }
        }
        finally {
            if (result != null) {
                try {
                    result.close();
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to close result", (Throwable)e);
                }
            }
            if (oPreStmt != null) {
                try {
                    oPreStmt.close();
                }
                catch (Exception ex) {
                    logger.error((Object)"Failed to close prepared statement", (Throwable)ex);
                }
            }
            if (oConn != null) {
                this.m_oDBMgr.freeConnection(oConn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveNews(String sql, int orgGroup) throws Exception {
        this.initLogger(orgGroup);
        int nLasMigrationId = this.m_oDLogger.readLastInfo();
        if (nLasMigrationId == -1) {
            logger.warn((Object)("[ID=" + orgGroup + "]\u5df2\u7ecf\u8fc1\u79fb\u5b8c\uff0c\u91cd\u590d\u6267\u884c\uff01"));
            return;
        }
        logger.info((Object)("End Data Migration to [" + orgGroup + "]!"));
        Connection oConn = null;
        PreparedStatement oPreStmt = null;
        ResultSet result = null;
        int nSrcId = 0;
        Reader inStream = null;
        try {
            oConn = this.m_oDBMgr.getConnection();
            oPreStmt = oConn.prepareStatement(sql);
            result = oPreStmt.executeQuery();
            while (result.next()) {
                ++nSrcId;
                Clob clob = result.getClob("attribute_value");
                inStream = clob.getCharacterStream();
                char[] c = new char[(int)clob.length()];
                inStream.read(c);
                String data = new String(c);
                System.out.println(data);
                inStream.close();
                MetaViewData metaViewData = MetaViewData.createNewInstance();
                this.m_oDLogger.recordStartData(nSrcId);
                ExchangeHelper.readFromRs(metaViewData, result, result.getMetaData(), this.m_oDBMgr.getDbType());
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("content", data);
                metaViewData.save();
                this.m_oDLogger.recordEndData(nSrcId);
            }
        }
        catch (Exception ex) {
            if (nSrcId > 0) {
                this.error("\u5904\u7406\u8fd9\u6761\u6570\u636e\u51fa\u73b0\u95ee\u9898\uff01[\u6570\u636eID=" + nSrcId + "]", ex);
            } else {
                this.error("\u67e5\u8be2\u6570\u636e\u51fa\u73b0\u95ee\u9898\uff1f[SQL=" + sql + "]", ex);
            }
        }
        finally {
            if (result != null) {
                try {
                    result.close();
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to close result", (Throwable)e);
                }
            }
            if (oPreStmt != null) {
                try {
                    oPreStmt.close();
                }
                catch (Exception ex) {
                    logger.error((Object)"Failed to close prepared statement", (Throwable)ex);
                }
            }
            if (oConn != null) {
                this.m_oDBMgr.freeConnection(oConn);
            }
        }
    }

    private void initLogger(int _nDstChannelId) throws Exception {
        this.m_oDLogger = new DataMigrationLogger(this.m_oDBMgr.getSrcNameOfDB(), _nDstChannelId);
        String sLogFilePath = this.filesMan.getPathConfigValue("N0", 0);
        sLogFilePath = CMyString.setStrEndWith(sLogFilePath, File.separatorChar);
        String sLogFileName = sLogFilePath + "exchange_" + this.m_oDBMgr.getSrcNameOfDB() + ".log";
        PatternLayout layout = new PatternLayout("[ExchangeLog] %m - %d - %-5p %x  - %c%l -%-4r [%t] %n");
        WriterAppender appender = new WriterAppender((Layout)layout, (OutputStream)new FileOutputStream(sLogFileName, true));
        appender.setEncoding("UTF-8");
        logger.removeAllAppenders();
        logger.addAppender((Appender)appender);
    }

    protected void warn(String _sInfo, Exception _ex) throws WCMException {
        logger.error((Object)_sInfo, (Throwable)_ex);
    }

    protected void error(String _sInfo) throws WCMException {
        this.error(_sInfo, null);
    }

    protected void error(String _sInfo, Exception _ex) throws WCMException {
        logger.error((Object)_sInfo, (Throwable)_ex);
        throw new WCMException(_sInfo, _ex);
    }
}

