/*
 * Decompiled with CFR 0.152.
 */
package com.trs.db.update;

import com.trs.db.update.SQLServerUpdateSQL;
import com.trs.infra.I18NMessage;
import com.trs.infra.persistent.db.DBConnectionConfig;
import com.trs.infra.persistent.db.DBConnectionMapper;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class UpdateSQLGenerator {
    public static void main(String[] args) throws Exception {
        String dbNameTarget = "LocalSQLServer";
        if (args.length > 0) {
            dbNameTarget = args[0];
        }
        DBConnectionConfig dbConfig = DBConnectionMapper.getInstance().getDBConnectionConfigByName(dbNameTarget);
        String lastUpdateTime = UpdateSQLGenerator.getLastUpdateTime(dbConfig);
        System.out.println("lastUpdateTime=" + lastUpdateTime);
        SQLServerUpdateSQL.main(new String[]{lastUpdateTime});
        System.out.println(I18NMessage.get(UpdateSQLGenerator.class, "UpdateSQLGenerator.label1", "\u5df2\u6210\u529f\u751f\u6210\u9488\u5bf9\u6570\u636e\u6e90 [") + dbNameTarget + I18NMessage.get(UpdateSQLGenerator.class, "UpdateSQLGenerator.label2", "] \u7684\u66f4\u65b0\u811a\u672c."));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getLastUpdateTime(DBConnectionConfig dbConfig) throws Exception {
        ResultSet rs;
        PreparedStatement pStmt;
        Connection conn;
        block5: {
            conn = UpdateSQLGenerator.getDBConnection(dbConfig.getDBType().getDriverClass(), dbConfig.getConnectionURL(), dbConfig.getConnectionUser(), dbConfig.getConnectionPassword());
            pStmt = null;
            rs = null;
            pStmt = conn.prepareStatement("select * from wcmdbupdate order by updtime desc");
            rs = pStmt.executeQuery();
            if (!rs.next()) throw new Exception(I18NMessage.get(UpdateSQLGenerator.class, "UpdateSQLGenerator.label4", "wcmdbupdate\u8868\u7adf\u7136\u8fde\u4e00\u6761\u6570\u636e\u8868\u66f4\u65b0\u8bb0\u5f55\u90fd\u6ca1\u6709!!"));
            String lastUpdTime = rs.getString("updtime");
            if (lastUpdTime == null) break block5;
            String string = lastUpdTime.substring(0, 19);
            UpdateSQLGenerator.closeResultSet(rs);
            UpdateSQLGenerator.closeStatement(pStmt);
            UpdateSQLGenerator.closeConnection(conn);
            return string;
        }
        try {
            try {
                throw new Exception(I18NMessage.get(UpdateSQLGenerator.class, "UpdateSQLGenerator.label3", "wcmdbupdate\u6700\u540e\u7684\u66f4\u65b0\u8bb0\u5f55\u7adf\u7136\u6ca1\u6709updtime!!"));
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                throw e;
            }
        }
        catch (Throwable throwable) {
            UpdateSQLGenerator.closeResultSet(rs);
            UpdateSQLGenerator.closeStatement(pStmt);
            UpdateSQLGenerator.closeConnection(conn);
            throw throwable;
        }
    }

    private static Connection getDBConnection(String driver, String url, String user, String pwd) {
        try {
            Class.forName(driver);
        }
        catch (Throwable t) {
            System.err.println("load JDBC Driver: [" + driver + "] fail!");
            t.printStackTrace(System.err);
            throw new RuntimeException(t.toString(), t);
        }
        try {
            Connection conn = DriverManager.getConnection(url, user, pwd);
            return conn;
        }
        catch (Throwable t) {
            System.err.println("DriverManager.getConnection(" + url + ", " + user + ", " + pwd + ") fail! jdbcDriver=" + driver);
            t.printStackTrace(System.err);
            throw new RuntimeException(t.toString(), t);
        }
    }

    private static void closeResultSet(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    private static void closeStatement(Statement stmt) {
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    private static void closeConnection(Connection conn) {
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }
}

