/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wechat.service;

import com.trs.DreamFactory;
import com.trs.components.common.publish.domain.publisher.PublishPathCompass;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.wcm.content.domain.AppendixMgr;
import com.trs.components.wcm.content.persistent.Appendix;
import com.trs.components.wcm.content.persistent.Appendixes;
import com.trs.components.wcm.content.persistent.ChnlDoc;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.infra.util.CMyString;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.ISelfDefinedServiceProvider;
import java.net.URLEncoder;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class WXNewsGenerateService
implements ISelfDefinedServiceProvider {
    private static Logger log = Logger.getLogger(WXNewsGenerateService.class);

    public String queryByRecIds(MethodContext methodContext) throws Exception {
        AppendixMgr appendixMgr = (AppendixMgr)DreamFactory.createObjectById("AppendixMgr");
        PublishPathCompass compass = new PublishPathCompass();
        String objectIds = methodContext.getValue("recIds");
        String[] recIds = objectIds.split(",");
        ArrayList<ChnlDoc> list = new ArrayList<ChnlDoc>();
        for (int i = 0; i < recIds.length; ++i) {
            ChnlDoc chnlDoc = ChnlDoc.findById(Integer.parseInt(recIds[i]));
            list.add(chnlDoc);
        }
        StringBuilder news = new StringBuilder();
        news.append("{\"articles\":[");
        for (int i = 0; i < list.size(); ++i) {
            ChnlDoc chnlDoc = (ChnlDoc)list.get(i);
            Document doc = chnlDoc.getDocument();
            news.append("{\"title\":\"");
            news.append(URLEncoder.encode(doc.getTitle(), "utf-8"));
            news.append("\",\"content\":\"");
            news.append(URLEncoder.encode(doc.getHtmlContent(), "utf-8"));
            news.append("\",\"description\":\"");
            news.append(URLEncoder.encode(doc.getAbstract(), "utf-8"));
            news.append("\",\"url\":\"");
            news.append(doc.getPubURL());
            news.append("\",\"picurl\":\"");
            Appendixes aApps = appendixMgr.getAppendixes(doc, 20);
            if (aApps.size() > 0) {
                Appendix appendix = (Appendix)aApps.getAt(0);
                IPublishContent oPublishContent = (IPublishContent)PublishElementFactory.lookupElement(605, doc.getId());
                String absolutePath = compass.getAbsoluteHttpPath(oPublishContent) + appendix.getFile();
                news.append(absolutePath);
            } else {
                news.append("");
            }
            news.append("\",\"author\":\"");
            news.append(doc.getCrUserName());
            news.append("\"},");
        }
        if (list.size() > 0) {
            news.deleteCharAt(news.length() - 1);
        }
        news.append("]}");
        String callBack = methodContext.getValue("callback");
        if (!CMyString.isEmpty(callBack)) {
            return callBack + "(" + news.toString() + ")";
        }
        return news.toString();
    }
}

