/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.process.element;

import com.trs.DreamFactory;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.cms.process.IFlowContent;
import com.trs.cms.process.definition.Flow;
import com.trs.cms.process.definition.FlowEmployMgr;
import com.trs.cms.process.engine.FlowDoc;
import com.trs.components.wcm.content.domain.DocumentMgr;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.ChnlDoc;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.resource.Status;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;

public class FlowContentDocumentImpl
implements IFlowContent {
    private boolean m_zLostDocument = false;
    private Document m_oDocument = null;
    private int m_nDocId = 0;
    private FlowDoc m_oFlowDoc = null;
    private Flow m_oFlow = null;
    private CMyDateTime m_dtStartTime = null;
    private long m_lSerialNum = -1L;
    private static final String QUERY_CHNLDOCID = "select RecId from WCMChnlDoc where DocId=? and ChnlId=?";
    private int m_nChnlDocId = -1;

    public FlowContentDocumentImpl(Document _currDocument) {
        this.makeFrom(_currDocument);
    }

    public FlowContentDocumentImpl(int _nId) {
        try {
            this.loadById(_nId);
        }
        catch (Exception e) {
            throw new RuntimeException(I18NMessage.get(FlowContentDocumentImpl.class, "FlowContentDocumentImpl.label1", "\u5b9e\u4f8b\u5316\u5de5\u4f5c\u6d41\u5bf9\u8c61\u5931\u8d25\uff01\u7c7b\u578b\u4e3a\u6587\u6863\uff0cDocId=") + _nId, e);
        }
    }

    public FlowContentDocumentImpl() {
    }

    public Document getDocument() throws WCMException {
        if (this.m_oDocument == null && !this.m_zLostDocument) {
            this.m_oDocument = Document.findById(this.m_nDocId);
            if (this.m_oDocument == null) {
                this.m_zLostDocument = true;
            }
        }
        return this.m_oDocument;
    }

    @Override
    public boolean canEdit(User _currUser) throws WCMException {
        if (this.getDocument() == null) {
            return false;
        }
        return this.getDocument().canEdit(_currUser);
    }

    @Override
    public Flow getOwnerFlow() throws WCMException {
        if (this.m_oFlow != null) {
            return this.m_oFlow;
        }
        Document oDocument = this.getDocument();
        String sFlowId = oDocument.getAttributeValue("FlowId");
        if (!CMyString.isEmpty(sFlowId)) {
            return Flow.findById(Integer.parseInt(sFlowId));
        }
        return this.getFlowEmployMgr().getFlow(this.getDocument().getChannel());
    }

    @Override
    public String getDesc() throws WCMException {
        if (this.getDocument() == null) {
            return I18NMessage.get(FlowContentDocumentImpl.class, "FlowContentDocumentImpl.label2", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u6587\u6863[ID=") + this.m_nDocId + "]";
        }
        String sChannelName = ((Document)this.getSubinstance()).getChannel().getDispDesc();
        return "[\u680f\u76ee-" + sChannelName + "]" + this.getDocument().toString();
    }

    @Override
    public int getContentType() {
        return 605;
    }

    @Override
    public int getSubinstanceId() {
        return this.m_nDocId;
    }

    @Override
    public void setSubinstance(int _nSubinstanceId) {
        this.m_nDocId = _nSubinstanceId;
    }

    @Override
    public void updateStatus(User user, int statusId) throws WCMException {
        String sDocForceUpdateStatus;
        Channel oCurrChannel;
        Document oCurrDocument = this.getDocument();
        ChnlDoc chnlDoc = ChnlDoc.findByDocAndChnl(oCurrDocument, oCurrChannel = oCurrDocument.getChannel());
        if (chnlDoc == null) {
            return;
        }
        int nOldStatusId = chnlDoc.getStatusId();
        if (nOldStatusId == 1027 && !"true".equalsIgnoreCase(sDocForceUpdateStatus = ConfigServer.getServer().getSysConfigValue("DOC_FORCE_UPDATE_STATUS", "false"))) {
            return;
        }
        this.getDocumentMgr().changeStatus(oCurrDocument, oCurrChannel, Status.findById(statusId));
    }

    @Override
    public void cancelUpdate(User user) throws WCMException {
        this.getDocument().cancelUpdate(user);
    }

    @Override
    public User getCrUser() throws WCMException {
        return this.getDocument().getCrUser();
    }

    @Override
    public int getStatusId() throws WCMException {
        if (this.getDocument() == null) {
            return -1;
        }
        return this.getDocument().getStatusId();
    }

    @Override
    public String getStatusDesc() throws WCMException {
        if (this.getDocument() == null) {
            return I18NMessage.get(FlowContentDocumentImpl.class, "FlowContentDocumentImpl.label3", "\u672a\u77e5");
        }
        Status aStatus = this.getDocument().getStatus();
        return aStatus == null ? I18NMessage.get(FlowContentDocumentImpl.class, "FlowContentDocumentImpl.label3", "\u672a\u77e5") : aStatus.getDisp();
    }

    private FlowEmployMgr getFlowEmployMgr() {
        return (FlowEmployMgr)DreamFactory.createObjectById("FlowEmployMgr");
    }

    private DocumentMgr getDocumentMgr() {
        return (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
    }

    @Override
    public CMSObj getSubinstance() throws WCMException {
        return this.getDocument();
    }

    @Override
    public void setSubinstance(CMSObj _subinstance) {
        this.m_oDocument = (Document)_subinstance;
        this.setSubinstance(_subinstance.getId());
    }

    @Override
    public String getContentShowPage() throws WCMException {
        if (this.getDocument() == null) {
            return I18NMessage.get(FlowContentDocumentImpl.class, "FlowContentDocumentImpl.label4", "\u6307\u5b9a\u7684\u5185\u5bb9\u4e0d\u5b58\u5728");
        }
        Channel docChannel = this.getDocument().getChannel();
        if (docChannel == null) {
            return "";
        }
        String sPageUrl = docChannel.getContentShowPage();
        String sAppend = "";
        sAppend = sPageUrl.indexOf(63) > 0 ? (sPageUrl.endsWith("?") ? "" : "&") : "?";
        int nChnlDocId = this.getChnlDocId();
        return sPageUrl + sAppend + "DocumentId=" + this.getDocument().getId() + "&ChannelId=" + docChannel.getId() + "&ChnlDocId=" + nChnlDocId;
    }

    @Override
    public String getContentAddEditPage() throws WCMException {
        if (this.getDocument() == null) {
            return I18NMessage.get(FlowContentDocumentImpl.class, "FlowContentDocumentImpl.label5", "javascript:alert('\u6307\u5b9a\u7684\u5185\u5bb9\u4e0d\u5b58\u5728\uff01');");
        }
        Channel docChannel = this.getDocument().getChannel();
        if (docChannel == null) {
            return "";
        }
        String sPageUrl = docChannel.getContentAddEditPage();
        String sAppend = "";
        sAppend = sPageUrl.indexOf(63) > 0 ? (sPageUrl.endsWith("?") ? "" : "&") : "?";
        int nChnlDocId = this.getChnlDocId();
        return docChannel.getContentAddEditPage() + sAppend + "DocumentId=" + this.getDocument().getId() + "&ChannelId=" + docChannel.getId() + "&ChnlDocId=" + nChnlDocId;
    }

    private int getChnlDocId() throws WCMException {
        if (this.m_nChnlDocId == -1) {
            this.m_nChnlDocId = DBManager.getDBManager().sqlExecuteIntQuery(QUERY_CHNLDOCID, new int[]{this.getDocument().getId(), this.getDocument().getChannelId()});
        }
        return this.m_nChnlDocId;
    }

    @Override
    public String getDeletePage() throws WCMException {
        if (this.getDocument() == null) {
            return I18NMessage.get(FlowContentDocumentImpl.class, "FlowContentDocumentImpl.label5", "javascript:alert('\u6307\u5b9a\u7684\u5185\u5bb9\u4e0d\u5b58\u5728\uff01');");
        }
        Channel docChannel = this.getDocument().getChannel();
        if (docChannel == null) {
            return "";
        }
        return "serviceId=wcm6_viewdocument&methodName=delete&drop=false&objectids=" + this.getChnlDocId();
    }

    @Override
    public String getPublishPage() throws WCMException {
        if (this.getDocument() == null) {
            return I18NMessage.get(FlowContentDocumentImpl.class, "FlowContentDocumentImpl.label5", "javascript:alert('\u6307\u5b9a\u7684\u5185\u5bb9\u4e0d\u5b58\u5728\uff01');");
        }
        return "../document/document_publish.jsp?DocumentIds=" + this.getDocument().getId() + "&PubType=3";
    }

    @Override
    public int getId() {
        return this.m_nDocId;
    }

    @Override
    public String getInfo() {
        try {
            return this.getDesc();
        }
        catch (Exception e) {
            e.printStackTrace();
            return I18NMessage.get(FlowContentDocumentImpl.class, "FlowContentDocumentImpl.label6", "\u83b7\u53d6\u63cf\u8ff0\u51fa\u73b0\u5f02\u5e38\uff01\uff01\uff01");
        }
    }

    @Override
    public CMSObj getSubstance() {
        return this.m_oDocument;
    }

    @Override
    public int getType() {
        return 605;
    }

    @Override
    public boolean loadById(int _nId) throws WCMException {
        Document document = Document.findById(_nId);
        if (document == null) {
            throw new WCMException(I18NMessage.get(FlowContentDocumentImpl.class, "FlowContentDocumentImpl.label7", "\u6307\u5b9a\u7684\u6587\u6863\u6ca1\u6709\u627e\u5230\uff01[DocId=") + _nId + "]");
        }
        this.makeFrom(document);
        return true;
    }

    @Override
    public void makeFrom(CMSObj _cmsObj) throws WCMException {
        if (!(_cmsObj instanceof Document)) {
            throw new WCMException(I18NMessage.get(FlowContentDocumentImpl.class, "FlowContentDocumentImpl.label8", "\u7c7b\u578b\u4e0d\u5339\u914d\uff01"));
        }
        this.makeFrom((Document)_cmsObj);
    }

    private void makeFrom(Document _document) {
        this.m_oDocument = _document;
        this.m_nDocId = _document.getId();
    }

    @Override
    public void setSubstance(CMSObj _cmsObj) {
        try {
            this.makeFrom(_cmsObj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public FlowDoc getFlowDoc() {
        return this.m_oFlowDoc;
    }

    @Override
    public void setFlowDoc(FlowDoc _flowDoc) {
        this.m_oFlowDoc = _flowDoc;
    }

    @Override
    public String getProperty(String _sName) {
        return this.m_oDocument.getPropertyAsString(_sName);
    }

    @Override
    public CMyDateTime getStartTime() {
        return this.m_dtStartTime;
    }

    @Override
    public void setStartTime(CMyDateTime _dtStartTime) {
        this.m_dtStartTime = _dtStartTime;
    }

    @Override
    public boolean isDeleted() {
        try {
            Channel currChnl = this.m_oDocument.getChannel();
            if (currChnl == null) {
                return true;
            }
            if (currChnl.getStatus() < 0) {
                return true;
            }
        }
        catch (WCMException ex) {
            ex.printStackTrace();
        }
        return this.m_oDocument.isDeleted();
    }

    @Override
    public long getSerialNum() {
        return this.m_lSerialNum;
    }

    @Override
    public void setSerialNum(long _lSerialNum) {
        this.m_lSerialNum = _lSerialNum;
    }

    @Override
    public void setFlow(Flow flow) {
        this.m_oFlow = flow;
    }
}

