/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.trsserver;

import com.trs.DreamFactory;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.Role;
import com.trs.cms.auth.persistent.Roles;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.cache.ICachedPOMgr;

public class ChannelsWithRightMaker {
    private User m_oCurrUser = null;
    private int m_nRightIndex = -1;
    private StringBuffer m_sbResults = null;
    private Roles m_oRoles = null;
    private Groups m_oGroups = null;
    private Channels m_oChannelsLimmit = null;

    public ChannelsWithRightMaker(User _user, int _nRightIndex) {
        this.m_oCurrUser = _user;
        this.m_nRightIndex = _nRightIndex;
    }

    public String getChannelIdsWithRight(String _sChannelIds) throws WCMException {
        this.m_oChannelsLimmit = Channels.findByIds(this.m_oCurrUser, _sChannelIds);
        return this.getChannelIdsWithRight();
    }

    public String getChannelIdsWithRight() throws WCMException {
        if (this.m_oCurrUser.isAdministrator()) {
            return "";
        }
        if (this.m_sbResults == null) {
            if (this.m_oChannelsLimmit != null) {
                this.makeChannelIdsWithRightInRegion();
            } else {
                this.makeChannelIdsWithRight();
            }
        }
        if (this.m_sbResults.length() == 0) {
            return null;
        }
        return this.m_sbResults.substring(0, this.m_sbResults.length() - 1);
    }

    private synchronized void makeChannelIdsWithRight() throws WCMException {
        if (this.m_sbResults != null) {
            return;
        }
        this.m_oRoles = this.m_oCurrUser.getRoles();
        Role everyRole = Role.findById(2);
        if (everyRole != null) {
            this.m_oRoles.addElement(everyRole);
        }
        this.m_oGroups = this.m_oCurrUser.getGroups();
        ICachedPOMgr currCachedPOMgr = (ICachedPOMgr)DreamFactory.createObjectById("ICachedPOMgr");
        if (currCachedPOMgr == null) {
            throw new WCMException(10, "ICachedPOMgr Config Error!");
        }
        Channels channels = Channels.createNewInstance(this.m_oCurrUser);
        channels.open(null);
        this.m_sbResults = new StringBuffer(7 * channels.size());
        int length = channels.size();
        for (int i = 0; i < length; ++i) {
            Channel channel = (Channel)channels.getAt(i);
            if (channel.isDeleted() || !AuthServer.hasRight(this.m_oCurrUser, (CMSObj)channel, this.m_nRightIndex)) continue;
            this.m_sbResults.append(channel.getId());
            this.m_sbResults.append(",");
        }
    }

    private synchronized void makeChannelIdsWithRightInRegion() throws WCMException {
        if (this.m_sbResults != null) {
            return;
        }
        this.m_oRoles = this.m_oCurrUser.getRoles();
        Role everyRole = Role.findById(2);
        if (everyRole != null) {
            this.m_oRoles.addElement(everyRole);
        }
        this.m_oGroups = this.m_oCurrUser.getGroups();
        this.m_sbResults = new StringBuffer(7 * this.m_oChannelsLimmit.size());
        int nSize = this.m_oChannelsLimmit.size();
        for (int i = 0; i < nSize; ++i) {
            Channel channel = (Channel)this.m_oChannelsLimmit.getAt(i);
            if (channel == null || channel.isDeleted() || !AuthServer.hasRight(this.m_oCurrUser, (CMSObj)channel, this.m_nRightIndex)) continue;
            this.m_sbResults.append(channel.getId());
            this.m_sbResults.append(",");
        }
    }

    public static void main(String[] args) {
    }
}

