/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.persistent;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.content.domain.DocumentMgr;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.ChnlDocs;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.resource.DocLevel;
import com.trs.components.wcm.resource.Status;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyDateTime;
import java.sql.Timestamp;
import java.util.Hashtable;
import org.apache.log4j.Logger;

public class ChnlDoc
extends CMSObj {
    private static Logger logger = Logger.getLogger(ChnlDoc.class);
    public static final int OBJ_TYPE = 614;
    public static final String DB_TABLE_NAME = "WCMCHNLDOC";
    public static final String DB_ID_NAME = "RECID";
    public static boolean IS_ORDER_BY_PRI = true;
    public static int PRI_DOCS_SIZE = 100;
    public static int NOT_ON_TOP = 0;
    private Document m_oDocument = null;
    public static final Hashtable<String, String> H_DB_DOCUMENT_PROPERTIES = new Hashtable(3);
    public static final int MODAL_ALL = 0;
    public static final int MODAL_ENTITY = 1;
    public static final int MODAL_LINK = 2;
    public static final int MODAL_MIRROR = 3;
    private static final String UPDATE_DOCORDERPRI_SQLWHERE = " WHERE DocOrderPri>0 AND DocOrderPri<=";
    public static String DB_DOCUMENT_FIELDS = "";

    @Override
    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    @Override
    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    @Override
    public int getWCMType() {
        return 614;
    }

    public int getSiteId() {
        return this.getPropertyAsInt("SITEID", 0);
    }

    public boolean setSiteId(int _nSiteId) throws WCMException {
        return this.setProperty("SITEID", _nSiteId);
    }

    public int getChannelId() {
        return this.getPropertyAsInt("CHNLID", 0);
    }

    public Channel getChannel() throws WCMException {
        int nChannelId = this.getChannelId();
        if (nChannelId == 0) {
            return null;
        }
        return Channel.findById(Math.abs(nChannelId));
    }

    public boolean setChannelId(int _nChannelId) throws WCMException {
        return this.setProperty("CHNLID", _nChannelId);
    }

    public boolean setActionType(int actionType) throws WCMException {
        return this.setProperty("ACTIONTYPE", actionType);
    }

    public int getDocId() {
        return this.getPropertyAsInt("DOCID", 0);
    }

    public boolean setDeleted(boolean _bDeleted) throws WCMException {
        int nStatusId = this.getStatusId();
        if (nStatusId < 0 == _bDeleted) {
            return false;
        }
        return this.setStatusId(-nStatusId);
    }

    public boolean setDocId(int _nDocId) throws WCMException {
        return this.setProperty("DOCID", _nDocId);
    }

    public boolean setDocument(Document _document, boolean _bOnlyCache) throws WCMException {
        this.m_oDocument = _document;
        if (_bOnlyCache) {
            return true;
        }
        return this.setProperty("DOCID", _document.getId());
    }

    public int getStatusId() {
        return this.getPropertyAsInt("DOCSTATUS", 0);
    }

    public Status getStatus() throws WCMException {
        int nStatusId = this.getStatusId();
        if (nStatusId < 0) {
            nStatusId = -nStatusId;
        }
        return Status.findById(nStatusId);
    }

    public String getStatusName() throws WCMException {
        if (this.getStatusId() == 0) {
            return "";
        }
        Status docStatus = this.getStatus();
        if (docStatus == null) {
            return I18NMessage.get(ChnlDoc.class, "ChnlDoc.label1", "\u672a\u77e5");
        }
        return docStatus.getDisp();
    }

    public boolean setStatusId(int _nStatusId) throws WCMException {
        return this.setProperty("DOCSTATUS", _nStatusId);
    }

    public int getDocOrder() {
        return this.getPropertyAsInt("DOCORDER", 0);
    }

    public boolean setDocOrder(int _nDocOrder) throws WCMException {
        return this.setProperty("DOCORDER", _nDocOrder);
    }

    public CMyDateTime getDocPubTime() {
        return (CMyDateTime)this.getProperty("DOCPUBTIME");
    }

    public boolean setDocPubTime(CMyDateTime _dtDocPubTime) throws WCMException {
        return this.setProperty("DOCPUBTIME", _dtDocPubTime);
    }

    public String getDocPubURL() {
        return this.getPropertyAsString("DOCPUBURL");
    }

    public boolean setDocPubURL(String _sDocPubURL) throws WCMException {
        return this.setProperty("DOCPUBURL", _sDocPubURL);
    }

    public int getDocOrderPri() {
        return this.getDocOrderPri(false);
    }

    public int getDocOrderPri(boolean _bReturnDBValue) {
        int nOrder = this.getPropertyAsInt("DOCORDERPRI", 0);
        if (_bReturnDBValue) {
            return nOrder;
        }
        return nOrder == 0 ? 0 : PRI_DOCS_SIZE - nOrder + 1;
    }

    public boolean setDocOrderPri(int _nDocOrderPri) throws WCMException {
        DocumentMgr currMgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
        if (_nDocOrderPri < 0) {
            throw new WCMException(10, I18NMessage.get(ChnlDoc.class, "ChnlDoc.label2", "\u5bf9\u4e0d\u8d77,\u7f6e\u9876\u987a\u5e8f\u4e0d\u80fd\u5c0f\u4e8e0!"));
        }
        if (_nDocOrderPri > currMgr.getMaxToppedNum()) {
            throw new WCMException(10, I18NMessage.get(ChnlDoc.class, "ChnlDoc.label3", "\u5bf9\u4e0d\u8d77,\u7f6e\u9876\u987a\u5e8f\u4e0d\u80fd\u8d85\u8fc7\u6700\u5927\u503c[+") + currMgr.getMaxToppedNum() + "!");
        }
        int nDbOrder = currMgr.getMaxToppedNum() + 1 - _nDocOrderPri;
        if (_nDocOrderPri == NOT_ON_TOP) {
            return this.setProperty("DOCORDERPRI", _nDocOrderPri);
        }
        return this.setProperty("DOCORDERPRI", nDbOrder);
    }

    public boolean setDocTopPriOrder(int _nOrder) throws WCMException {
        if (_nOrder < 0 || _nOrder > PRI_DOCS_SIZE) {
            throw new WCMException(1104, I18NMessage.get(ChnlDoc.class, "ChnlDoc.label4", "\u65e0\u6548\u7684\u7f6e\u9876\u4f4d\u7f6e!"));
        }
        int nDocOrder = 0;
        if (_nOrder == NOT_ON_TOP) {
            if (this.isTopped()) {
                nDocOrder = PRI_DOCS_SIZE - this.getDocOrderPri() + 1;
                String sMoveUpSql = "UPDATE " + this.getDbTableName() + " SET DocOrderPri=(DocOrderPri+1) " + UPDATE_DOCORDERPRI_SQLWHERE + nDocOrder + " AND ChnlId=" + this.getChannelId();
                DBManager.getDBManager().sqlExecuteUpdate(sMoveUpSql);
            }
            nDocOrder = NOT_ON_TOP;
        } else {
            nDocOrder = PRI_DOCS_SIZE - _nOrder + 1;
            String sMoveDownSql = "UPDATE " + this.getDbTableName() + " SET DocOrderPri=(DocOrderPri-1) " + UPDATE_DOCORDERPRI_SQLWHERE + nDocOrder + " AND ChnlId=" + this.getChannelId();
            DBManager.getDBManager().sqlExecuteUpdate(sMoveDownSql);
        }
        return this.setProperty("DOCORDERPRI", nDocOrder);
    }

    public boolean isTopped() {
        return this.getPropertyAsInt("DOCORDERPRI", 0) > 0;
    }

    public CMyDateTime getInvalidTime() {
        return (CMyDateTime)this.getProperty("INVALIDTIME");
    }

    public boolean setInvalidTime(CMyDateTime _dtInvalidTime) throws WCMException {
        return this.setProperty("INVALIDTIME", _dtInvalidTime);
    }

    public boolean isDeleted() {
        return this.getStatusId() < 0;
    }

    @Override
    public void setId(int _nId) {
        this.id = _nId;
    }

    @Override
    public boolean isValid() throws WCMException {
        if (this.isAddMode()) {
            if (this.getAllProperty().get("CHNLID") == null) {
                throw new WCMException(1106, I18NMessage.get(ChnlDoc.class, "ChnlDoc.label5", "\u5c5e\u6027ChannelId\u6ca1\u6709\u8bbe\u7f6e(ChnlDoc.isValid)"));
            }
            if (this.getAllProperty().get("DOCID") == null) {
                throw new WCMException(1106, I18NMessage.get(ChnlDoc.class, "ChnlDoc.label6", "\u5c5e\u6027DocId\u6ca1\u6709\u8bbe\u7f6e(ChnlDoc.isValid)"));
            }
            if (this.getAllProperty().get("DOCSTATUS") == null) {
                throw new WCMException(1106, I18NMessage.get(ChnlDoc.class, "ChnlDoc.label7", "\u5c5e\u6027StatusId\u6ca1\u6709\u8bbe\u7f6e(ChnlDoc.isValid)"));
            }
            if (this.getAllProperty().get("DOCORDER") == null) {
                throw new WCMException(1106, I18NMessage.get(ChnlDoc.class, "ChnlDoc.label8", "\u5c5e\u6027DocOrder\u6ca1\u6709\u8bbe\u7f6e(ChnlDoc.isValid)"));
            }
            if (this.getAllProperty().get("MODAL") == null) {
                throw new WCMException(1106, I18NMessage.get(ChnlDoc.class, "ChnlDoc.label9", "\u5c5e\u6027Modal\u6ca1\u6709\u8bbe\u7f6e(ChnlDoc.isValid)"));
            }
        } else {
            if (!this.isModified()) {
                throw new WCMException(1107, I18NMessage.get(ChnlDoc.class, "ChnlDoc.label10", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(ChnlDoc.isValid)"));
            }
            if (this.isEntity() && this.isChangeProperty("ChnlId") && this.containsProperty("DocChannel")) {
                this.setProperty("DocChannel", this.getNewProperty("ChnlId"));
            }
            if (this.isChangeProperty("DocStatus")) {
                this.setOperUser(this.getLockerUser());
                this.setOperTime();
            }
        }
        this.setProperty("OperTime", CMyDateTime.now());
        if (this.m_oOperator != null) {
            this.setOperUser(this.m_oOperator);
        }
        return true;
    }

    public boolean setOperUser(User _currUser) throws WCMException {
        if (_currUser == null || !_currUser.isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(ChnlDoc.class, "ChnlDoc.label11", "\u65e0\u6548\u7684\u7528\u6237\u5bf9\u8c61(") + this.getClass().getName() + ".setOperUser)");
        }
        return this.setOperUser(_currUser.getName());
    }

    public boolean setOperUser(String _sUserName) throws WCMException {
        return this.setProperty("OPERUSER", _sUserName);
    }

    public User getOperUser() {
        String sName = this.getOperUserName();
        return sName == null ? null : User.findByName(sName);
    }

    public String getOperUserName() {
        return (String)this.getProperty("OPERUSER");
    }

    public boolean setOperTime() throws WCMException {
        return this.setProperty("OPERTIME", CMyDateTime.now());
    }

    public CMyDateTime getOperTime() {
        return (CMyDateTime)this.getProperty("OPERTIME");
    }

    public int getModal() {
        return this.getPropertyAsInt("MODAL", 0);
    }

    public boolean isEntity() {
        return this.getModal() == 1;
    }

    public boolean setModal(int _nModal) throws WCMException {
        return this.setProperty("MODAL", _nModal);
    }

    public DocLevel getDocLevel() throws WCMException {
        int nDocLevelId = this.getDocLevleId();
        if (nDocLevelId == 0) {
            return DocLevel.findById(1);
        }
        return DocLevel.findById(nDocLevelId);
    }

    public boolean setDocLevel(DocLevel _docLevel) throws WCMException {
        if (_docLevel == null) {
            return this.setDocLevel(0);
        }
        return this.setDocLevel(_docLevel.getId());
    }

    public int getDocLevleId() {
        return this.getPropertyAsInt("DOCLEVEL", 0);
    }

    public boolean setDocLevel(int _nDocLevelId) throws WCMException {
        return this.setProperty("DOCLEVEL", _nDocLevelId);
    }

    public String getDocLevelName() throws WCMException {
        if (this.getDocId() == 0) {
            return "";
        }
        DocLevel docLevel = this.getDocLevel();
        if (docLevel == null) {
            return I18NMessage.get(ChnlDoc.class, "ChnlDoc.label1", "\u672a\u77e5");
        }
        return docLevel.getLName();
    }

    public static final ChnlDoc findById(int _nId) throws WCMException {
        if (_nId <= 0) {
            return null;
        }
        return (ChnlDoc)BaseObj.findById(ChnlDoc.class, _nId);
    }

    public static final ChnlDoc createNewInstance() throws WCMException {
        return (ChnlDoc)BaseObj.createNewInstance(ChnlDoc.class);
    }

    public static final ChnlDoc findByKey(Object _oKey) throws WCMException {
        return (ChnlDoc)BaseObj.findByKey(ChnlDoc.class, _oKey);
    }

    public Document getDocument() throws WCMException {
        if (this.m_oDocument != null) {
            return this.m_oDocument;
        }
        int nDocumentId = this.getDocId();
        if (nDocumentId == 0) {
            return null;
        }
        this.m_oDocument = Document.findById(nDocumentId);
        return this.m_oDocument;
    }

    public int getDocumentId() {
        return this.getPropertyAsInt("DOCID", 0);
    }

    @Override
    protected void deleteOthersBeforeDelete() {
        super.deleteOthersBeforeDelete();
        if (this.getModal() == 1) {
            try {
                Document document = this.getDocument();
                if (document != null) {
                    document.delete();
                }
            }
            catch (WCMException e) {
                logger.error((Object)(I18NMessage.get(ChnlDoc.class, "ChnlDoc.label12", "\u540c\u6b65\u5220\u9664\u6587\u6863[") + this.getDocId() + I18NMessage.get(ChnlDoc.class, "ChnlDoc.label13", "]\u5931\u8d25\uff01")), (Throwable)e);
                throw new RuntimeException(I18NMessage.get(ChnlDoc.class, "ChnlDoc.label12", "\u540c\u6b65\u5220\u9664\u6587\u6863[") + this.getDocId() + I18NMessage.get(ChnlDoc.class, "ChnlDoc.label13", "]\u5931\u8d25\uff01"), e);
            }
        }
    }

    @Override
    protected void updateOthersAfterModified() {
        super.updateOthersAfterModified();
        if (this.getModal() == 1) {
            try {
                if (this.isChangeProperty("DOCSTATUS")) {
                    int nNewDocStatusId = this.getNewPropertyAsInt("DOCSTATUS", 0);
                    String sUpdateDocumentSQL = "update WCMDocument set DocStatus=?, OperUser=?, OperTime=? where DOCID=?";
                    Integer iStatusId = new Integer(nNewDocStatusId);
                    Integer iDocId = new Integer(this.getDocId());
                    Timestamp tsCurTime = new Timestamp(System.currentTimeMillis());
                    String sUserName = this.getLockerUserName();
                    Object[] pDocumentParameters = new Object[]{iStatusId, sUserName, tsCurTime, iDocId};
                    this.getDBManager().sqlExecuteUpdate(new String[]{sUpdateDocumentSQL}, pDocumentParameters);
                    if (nNewDocStatusId < 0) {
                        String sUpdateChnlDocSQL = "update WCMChnlDoc set Modal=-Modal where DOCID=? and Modal>0 and Modal<>1";
                        Object[] pParameters = new Object[]{iDocId};
                        this.getDBManager().sqlExecuteUpdate(new String[]{sUpdateChnlDocSQL}, pParameters);
                    } else if (this.getStatusId() < 0 & nNewDocStatusId > 0) {
                        String sUpdateChnlDocSQL = "update WCMChnlDoc set Modal=-Modal where DOCID=? and Modal<0";
                        Object[] pParameters = new Object[]{iDocId};
                        this.getDBManager().sqlExecuteUpdate(new String[]{sUpdateChnlDocSQL}, pParameters);
                    }
                }
                if (this.isChangeProperty("CHNLID")) {
                    String sUpdateDocumentSQL = "update WCMDocument set DOCCHANNEL=" + this.getNewPropertyAsInt("CHNLID", 0) + " where DOCID=" + this.getDocId();
                    String sUpdateDocumentSQL2 = "update WCMChnlDoc set DOCCHANNEL=" + this.getNewPropertyAsInt("CHNLID", 0) + " where DOCID=" + this.getDocId();
                    this.getDBManager().sqlExecuteUpdate(new String[]{sUpdateDocumentSQL, sUpdateDocumentSQL2});
                }
                if (this.isChangeProperty("DOCPUBTIME")) {
                    String sUpdateDocumentSQL = "update WCMDocument set DOCPUBTIME=? where DOCID=" + this.getDocId();
                    String[] sqls = new String[]{sUpdateDocumentSQL};
                    Object[] params = new Object[]{(CMyDateTime)this.getNewProperty("DOCPUBTIME")};
                    this.getDBManager().sqlExecuteUpdate(sqls, params);
                }
            }
            catch (WCMException e) {
                logger.error((Object)(I18NMessage.get(ChnlDoc.class, "ChnlDoc.label14", "\u540c\u6b65\u6587\u6863[") + this.getDocId() + I18NMessage.get(ChnlDoc.class, "ChnlDoc.label15", "]\u5c5e\u6027\u5931\u8d25\uff01")), (Throwable)e);
                throw new RuntimeException(I18NMessage.get(ChnlDoc.class, "ChnlDoc.label14", "\u540c\u6b65\u6587\u6863[") + this.getDocId() + I18NMessage.get(ChnlDoc.class, "ChnlDoc.label15", "]\u5c5e\u6027\u5931\u8d25\uff01"), e);
            }
        }
    }

    public static final ChnlDoc findByDocAndChnl(Document _currDocument, Channel _currChannel) throws WCMException {
        if (_currDocument == null || _currChannel == null) {
            return null;
        }
        if (_currDocument.getChannelId() != _currChannel.getId() && _currChannel.isOnlySearch()) {
            return ChnlDoc.findByDocument(_currDocument);
        }
        String sWhere = "ChnlId=? and DocId=?";
        WCMFilter aFilter = new WCMFilter("", sWhere, "");
        aFilter.addSearchValues(0, _currChannel.getId());
        aFilter.addSearchValues(1, _currDocument.getId());
        aFilter.setMaxRowNumber(1);
        ChnlDocs aChnlDocs = ChnlDocs.openWCMObjs(ContextHelper.getLoginUser(), aFilter);
        if (!aChnlDocs.isEmpty()) {
            return (ChnlDoc)aChnlDocs.getAt(0);
        }
        return ChnlDoc.findByDocAndChnl(_currDocument.getId(), -_currChannel.getId());
    }

    public static ChnlDoc findByDocAndChnl(int _nDocumentId, int _nChannelId) throws WCMException {
        String sWhere = "DocId=? and ChnlId=?";
        WCMFilter aFilter = new WCMFilter("", sWhere, "");
        aFilter.addSearchValues(0, _nDocumentId);
        aFilter.addSearchValues(1, _nChannelId);
        aFilter.setMaxRowNumber(1);
        ChnlDocs aChnlDocs = new ChnlDocs(null);
        aChnlDocs.open(aFilter);
        if (aChnlDocs.isEmpty()) {
            aFilter.addSearchValues(1, -_nChannelId);
            aChnlDocs.open(aFilter);
        }
        if (!aChnlDocs.isEmpty()) {
            return (ChnlDoc)aChnlDocs.getAt(0);
        }
        return null;
    }

    public static final ChnlDoc findByDocument(Document _currDocument) throws WCMException {
        return ChnlDoc.findByDocAndChnl(_currDocument, _currDocument.getChannel());
    }

    public boolean isPublished() {
        return this.getStatusId() == 10;
    }

    public int getPubStatus() {
        return this.getPropertyAsInt("PUBSTATUS", 0);
    }

    public boolean setPubStatus(int pubStatus) throws WCMException {
        return this.setProperty("PUBSTATUS", pubStatus);
    }

    @Override
    public String toString() {
        StringBuffer buff = new StringBuffer();
        try {
            buff.append(this.getDocument().getTitle());
        }
        catch (Exception e) {
            buff.append(I18NMessage.get(ChnlDoc.class, "ChnlDoc.label16", "\u6587\u6863"));
        }
        buff.append("[DOCID=");
        buff.append(this.getDocId());
        buff.append(", CHNLID=");
        buff.append(this.getChannelId());
        buff.append(", MODAL=");
        buff.append(this.getModal());
        buff.append("]");
        return buff.toString();
    }

    static {
        String sDocPropertyName = "DOCSTATUS";
        String sChnlDocFieldName = "DOCSTATUS";
        H_DB_DOCUMENT_PROPERTIES.put(sDocPropertyName, sChnlDocFieldName);
        DB_DOCUMENT_FIELDS = "WCMCHNLDOC." + sChnlDocFieldName + " AS " + sDocPropertyName;
        sDocPropertyName = "DOCORDER";
        sChnlDocFieldName = "DOCORDER";
        H_DB_DOCUMENT_PROPERTIES.put(sDocPropertyName, sChnlDocFieldName);
        DB_DOCUMENT_FIELDS = DB_DOCUMENT_FIELDS + ",WCMCHNLDOC." + sChnlDocFieldName + " AS " + sDocPropertyName;
        sDocPropertyName = "DOCPUBTIME";
        sChnlDocFieldName = "DOCPUBTIME";
        H_DB_DOCUMENT_PROPERTIES.put(sDocPropertyName, sChnlDocFieldName);
        DB_DOCUMENT_FIELDS = DB_DOCUMENT_FIELDS + ",WCMCHNLDOC." + sChnlDocFieldName + " AS " + sDocPropertyName;
        sDocPropertyName = "DOCPUBURL";
        sChnlDocFieldName = "DOCPUBURL";
        H_DB_DOCUMENT_PROPERTIES.put(sDocPropertyName, sChnlDocFieldName);
        DB_DOCUMENT_FIELDS = DB_DOCUMENT_FIELDS + ",WCMCHNLDOC." + sChnlDocFieldName + " AS " + sDocPropertyName;
        sDocPropertyName = "NEWCRUSER";
        sChnlDocFieldName = "CRUSER";
        H_DB_DOCUMENT_PROPERTIES.put(sDocPropertyName, sChnlDocFieldName);
        DB_DOCUMENT_FIELDS = DB_DOCUMENT_FIELDS + ",WCMCHNLDOC." + sChnlDocFieldName + " AS " + sDocPropertyName;
        sDocPropertyName = "NEWCRTIME";
        sChnlDocFieldName = "CRTIME";
        H_DB_DOCUMENT_PROPERTIES.put(sDocPropertyName, sChnlDocFieldName);
        DB_DOCUMENT_FIELDS = DB_DOCUMENT_FIELDS + ",WCMCHNLDOC." + sChnlDocFieldName + " AS " + sDocPropertyName;
        try {
            ConfigServer server = ConfigServer.getServer();
            String sValue = server.getSysConfigValue("PRI_DOCS_SIZE", "");
            if (sValue.length() > 0) {
                PRI_DOCS_SIZE = Integer.parseInt(sValue);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

